/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ClusterEventResourceType;
import software.amazon.awssdk.services.sagemaker.model.EventSortBy;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClusterEventsRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListClusterEventsRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(ListClusterEventsRequest.getter(ListClusterEventsRequest::clusterName)).setter(ListClusterEventsRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceGroupName").getter(ListClusterEventsRequest.getter(ListClusterEventsRequest::instanceGroupName)).setter(ListClusterEventsRequest.setter(Builder::instanceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()}).build();
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeId").getter(ListClusterEventsRequest.getter(ListClusterEventsRequest::nodeId)).setter(ListClusterEventsRequest.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()}).build();
    private static final SdkField<Instant> EVENT_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventTimeAfter").getter(ListClusterEventsRequest.getter(ListClusterEventsRequest::eventTimeAfter)).setter(ListClusterEventsRequest.setter(Builder::eventTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTimeAfter").build()}).build();
    private static final SdkField<Instant> EVENT_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventTimeBefore").getter(ListClusterEventsRequest.getter(ListClusterEventsRequest::eventTimeBefore)).setter(ListClusterEventsRequest.setter(Builder::eventTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTimeBefore").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(ListClusterEventsRequest.getter(ListClusterEventsRequest::sortByAsString)).setter(ListClusterEventsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListClusterEventsRequest.getter(ListClusterEventsRequest::sortOrderAsString)).setter(ListClusterEventsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ListClusterEventsRequest.getter(ListClusterEventsRequest::resourceTypeAsString)).setter(ListClusterEventsRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListClusterEventsRequest.getter(ListClusterEventsRequest::maxResults)).setter(ListClusterEventsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListClusterEventsRequest.getter(ListClusterEventsRequest::nextToken)).setter(ListClusterEventsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, INSTANCE_GROUP_NAME_FIELD, NODE_ID_FIELD, EVENT_TIME_AFTER_FIELD, EVENT_TIME_BEFORE_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, RESOURCE_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListClusterEventsRequest.memberNameToFieldInitializer();
    private final String clusterName;
    private final String instanceGroupName;
    private final String nodeId;
    private final Instant eventTimeAfter;
    private final Instant eventTimeBefore;
    private final String sortBy;
    private final String sortOrder;
    private final String resourceType;
    private final Integer maxResults;
    private final String nextToken;

    private ListClusterEventsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.instanceGroupName = builder.instanceGroupName;
        this.nodeId = builder.nodeId;
        this.eventTimeAfter = builder.eventTimeAfter;
        this.eventTimeBefore = builder.eventTimeBefore;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.resourceType = builder.resourceType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String instanceGroupName() {
        return this.instanceGroupName;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final Instant eventTimeAfter() {
        return this.eventTimeAfter;
    }

    public final Instant eventTimeBefore() {
        return this.eventTimeBefore;
    }

    public final EventSortBy sortBy() {
        return EventSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final ClusterEventResourceType resourceType() {
        return ClusterEventResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterEventsRequest)) {
            return false;
        }
        ListClusterEventsRequest other = (ListClusterEventsRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.instanceGroupName(), other.instanceGroupName()) && Objects.equals(this.nodeId(), other.nodeId()) && Objects.equals(this.eventTimeAfter(), other.eventTimeAfter()) && Objects.equals(this.eventTimeBefore(), other.eventTimeBefore()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListClusterEventsRequest").add("ClusterName", (Object)this.clusterName()).add("InstanceGroupName", (Object)this.instanceGroupName()).add("NodeId", (Object)this.nodeId()).add("EventTimeAfter", (Object)this.eventTimeAfter()).add("EventTimeBefore", (Object)this.eventTimeBefore()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("ResourceType", (Object)this.resourceTypeAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "InstanceGroupName": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupName()));
            }
            case "NodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
            case "EventTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.eventTimeAfter()));
            }
            case "EventTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.eventTimeBefore()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("InstanceGroupName", INSTANCE_GROUP_NAME_FIELD);
        map.put("NodeId", NODE_ID_FIELD);
        map.put("EventTimeAfter", EVENT_TIME_AFTER_FIELD);
        map.put("EventTimeBefore", EVENT_TIME_BEFORE_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListClusterEventsRequest, T> g) {
        return obj -> g.apply((ListClusterEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String instanceGroupName;
        private String nodeId;
        private Instant eventTimeAfter;
        private Instant eventTimeBefore;
        private String sortBy;
        private String sortOrder;
        private String resourceType;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterEventsRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.instanceGroupName(model.instanceGroupName);
            this.nodeId(model.nodeId);
            this.eventTimeAfter(model.eventTimeAfter);
            this.eventTimeBefore(model.eventTimeBefore);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.resourceType(model.resourceType);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getInstanceGroupName() {
            return this.instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final Instant getEventTimeAfter() {
            return this.eventTimeAfter;
        }

        public final void setEventTimeAfter(Instant eventTimeAfter) {
            this.eventTimeAfter = eventTimeAfter;
        }

        @Override
        public final Builder eventTimeAfter(Instant eventTimeAfter) {
            this.eventTimeAfter = eventTimeAfter;
            return this;
        }

        public final Instant getEventTimeBefore() {
            return this.eventTimeBefore;
        }

        public final void setEventTimeBefore(Instant eventTimeBefore) {
            this.eventTimeBefore = eventTimeBefore;
        }

        @Override
        public final Builder eventTimeBefore(Instant eventTimeBefore) {
            this.eventTimeBefore = eventTimeBefore;
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(EventSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ClusterEventResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListClusterEventsRequest build() {
            return new ListClusterEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClusterEventsRequest> {
        public Builder clusterName(String var1);

        public Builder instanceGroupName(String var1);

        public Builder nodeId(String var1);

        public Builder eventTimeAfter(Instant var1);

        public Builder eventTimeBefore(Instant var1);

        public Builder sortBy(String var1);

        public Builder sortBy(EventSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ClusterEventResourceType var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

