/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ClusterEventResourceType;
import software.amazon.awssdk.services.sagemaker.model.EventDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterEventDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterEventDetail> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventId").getter(ClusterEventDetail.getter(ClusterEventDetail::eventId)).setter(ClusterEventDetail.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(ClusterEventDetail.getter(ClusterEventDetail::clusterArn)).setter(ClusterEventDetail.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(ClusterEventDetail.getter(ClusterEventDetail::clusterName)).setter(ClusterEventDetail.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceGroupName").getter(ClusterEventDetail.getter(ClusterEventDetail::instanceGroupName)).setter(ClusterEventDetail.setter(Builder::instanceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ClusterEventDetail.getter(ClusterEventDetail::instanceId)).setter(ClusterEventDetail.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ClusterEventDetail.getter(ClusterEventDetail::resourceTypeAsString)).setter(ClusterEventDetail.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventTime").getter(ClusterEventDetail.getter(ClusterEventDetail::eventTime)).setter(ClusterEventDetail.setter(Builder::eventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTime").build()}).build();
    private static final SdkField<EventDetails> EVENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventDetails").getter(ClusterEventDetail.getter(ClusterEventDetail::eventDetails)).setter(ClusterEventDetail.setter(Builder::eventDetails)).constructor(EventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDetails").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ClusterEventDetail.getter(ClusterEventDetail::description)).setter(ClusterEventDetail.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, CLUSTER_ARN_FIELD, CLUSTER_NAME_FIELD, INSTANCE_GROUP_NAME_FIELD, INSTANCE_ID_FIELD, RESOURCE_TYPE_FIELD, EVENT_TIME_FIELD, EVENT_DETAILS_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterEventDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventId;
    private final String clusterArn;
    private final String clusterName;
    private final String instanceGroupName;
    private final String instanceId;
    private final String resourceType;
    private final Instant eventTime;
    private final EventDetails eventDetails;
    private final String description;

    private ClusterEventDetail(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.instanceGroupName = builder.instanceGroupName;
        this.instanceId = builder.instanceId;
        this.resourceType = builder.resourceType;
        this.eventTime = builder.eventTime;
        this.eventDetails = builder.eventDetails;
        this.description = builder.description;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String instanceGroupName() {
        return this.instanceGroupName;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final ClusterEventResourceType resourceType() {
        return ClusterEventResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final Instant eventTime() {
        return this.eventTime;
    }

    public final EventDetails eventDetails() {
        return this.eventDetails;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterEventDetail)) {
            return false;
        }
        ClusterEventDetail other = (ClusterEventDetail)obj;
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.instanceGroupName(), other.instanceGroupName()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.eventTime(), other.eventTime()) && Objects.equals(this.eventDetails(), other.eventDetails()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterEventDetail").add("EventId", (Object)this.eventId()).add("ClusterArn", (Object)this.clusterArn()).add("ClusterName", (Object)this.clusterName()).add("InstanceGroupName", (Object)this.instanceGroupName()).add("InstanceId", (Object)this.instanceId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("EventTime", (Object)this.eventTime()).add("EventDetails", (Object)this.eventDetails()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "InstanceGroupName": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupName()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "EventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "EventDetails": {
                return Optional.ofNullable(clazz.cast(this.eventDetails()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventId", EVENT_ID_FIELD);
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("InstanceGroupName", INSTANCE_GROUP_NAME_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("EventTime", EVENT_TIME_FIELD);
        map.put("EventDetails", EVENT_DETAILS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterEventDetail, T> g) {
        return obj -> g.apply((ClusterEventDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private String clusterArn;
        private String clusterName;
        private String instanceGroupName;
        private String instanceId;
        private String resourceType;
        private Instant eventTime;
        private EventDetails eventDetails;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterEventDetail model) {
            this.eventId(model.eventId);
            this.clusterArn(model.clusterArn);
            this.clusterName(model.clusterName);
            this.instanceGroupName(model.instanceGroupName);
            this.instanceId(model.instanceId);
            this.resourceType(model.resourceType);
            this.eventTime(model.eventTime);
            this.eventDetails(model.eventDetails);
            this.description(model.description);
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getInstanceGroupName() {
            return this.instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ClusterEventResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final EventDetails.Builder getEventDetails() {
            return this.eventDetails != null ? this.eventDetails.toBuilder() : null;
        }

        public final void setEventDetails(EventDetails.BuilderImpl eventDetails) {
            this.eventDetails = eventDetails != null ? eventDetails.build() : null;
        }

        @Override
        public final Builder eventDetails(EventDetails eventDetails) {
            this.eventDetails = eventDetails;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public ClusterEventDetail build() {
            return new ClusterEventDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterEventDetail> {
        public Builder eventId(String var1);

        public Builder clusterArn(String var1);

        public Builder clusterName(String var1);

        public Builder instanceGroupName(String var1);

        public Builder instanceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ClusterEventResourceType var1);

        public Builder eventTime(Instant var1);

        public Builder eventDetails(EventDetails var1);

        default public Builder eventDetails(Consumer<EventDetails.Builder> eventDetails) {
            return this.eventDetails((EventDetails)((EventDetails.Builder)EventDetails.builder().applyMutation(eventDetails)).build());
        }

        public Builder description(String var1);
    }
}

