/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptimizationModelAccessConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OptimizationModelAccessConfig> {
    private static final SdkField<Boolean> ACCEPT_EULA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AcceptEula").getter(OptimizationModelAccessConfig.getter(OptimizationModelAccessConfig::acceptEula)).setter(OptimizationModelAccessConfig.setter(Builder::acceptEula)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptEula").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_EULA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OptimizationModelAccessConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean acceptEula;

    private OptimizationModelAccessConfig(BuilderImpl builder) {
        this.acceptEula = builder.acceptEula;
    }

    public final Boolean acceptEula() {
        return this.acceptEula;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptEula());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizationModelAccessConfig)) {
            return false;
        }
        OptimizationModelAccessConfig other = (OptimizationModelAccessConfig)obj;
        return Objects.equals(this.acceptEula(), other.acceptEula());
    }

    public final String toString() {
        return ToString.builder((String)"OptimizationModelAccessConfig").add("AcceptEula", (Object)this.acceptEula()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptEula": {
                return Optional.ofNullable(clazz.cast(this.acceptEula()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Boolean>> map = new HashMap<String, SdkField<Boolean>>();
        map.put("AcceptEula", ACCEPT_EULA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptimizationModelAccessConfig, T> g) {
        return obj -> g.apply((OptimizationModelAccessConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean acceptEula;

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizationModelAccessConfig model) {
            this.acceptEula(model.acceptEula);
        }

        public final Boolean getAcceptEula() {
            return this.acceptEula;
        }

        public final void setAcceptEula(Boolean acceptEula) {
            this.acceptEula = acceptEula;
        }

        @Override
        public final Builder acceptEula(Boolean acceptEula) {
            this.acceptEula = acceptEula;
            return this;
        }

        public OptimizationModelAccessConfig build() {
            return new OptimizationModelAccessConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OptimizationModelAccessConfig> {
        public Builder acceptEula(Boolean var1);
    }
}

