/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.InferenceExperimentDataStorageConfig;
import software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSchedule;
import software.amazon.awssdk.services.sagemaker.model.InferenceExperimentType;
import software.amazon.awssdk.services.sagemaker.model.ModelVariantConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelVariantConfigListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.ShadowModeConfig;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInferenceExperimentRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateInferenceExperimentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateInferenceExperimentRequest.getter(CreateInferenceExperimentRequest::name)).setter(CreateInferenceExperimentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateInferenceExperimentRequest.getter(CreateInferenceExperimentRequest::typeAsString)).setter(CreateInferenceExperimentRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<InferenceExperimentSchedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schedule").getter(CreateInferenceExperimentRequest.getter(CreateInferenceExperimentRequest::schedule)).setter(CreateInferenceExperimentRequest.setter(Builder::schedule)).constructor(InferenceExperimentSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateInferenceExperimentRequest.getter(CreateInferenceExperimentRequest::description)).setter(CreateInferenceExperimentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateInferenceExperimentRequest.getter(CreateInferenceExperimentRequest::roleArn)).setter(CreateInferenceExperimentRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(CreateInferenceExperimentRequest.getter(CreateInferenceExperimentRequest::endpointName)).setter(CreateInferenceExperimentRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<List<ModelVariantConfig>> MODEL_VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelVariants").getter(CreateInferenceExperimentRequest.getter(CreateInferenceExperimentRequest::modelVariants)).setter(CreateInferenceExperimentRequest.setter(Builder::modelVariants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVariants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelVariantConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InferenceExperimentDataStorageConfig> DATA_STORAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataStorageConfig").getter(CreateInferenceExperimentRequest.getter(CreateInferenceExperimentRequest::dataStorageConfig)).setter(CreateInferenceExperimentRequest.setter(Builder::dataStorageConfig)).constructor(InferenceExperimentDataStorageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStorageConfig").build()}).build();
    private static final SdkField<ShadowModeConfig> SHADOW_MODE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShadowModeConfig").getter(CreateInferenceExperimentRequest.getter(CreateInferenceExperimentRequest::shadowModeConfig)).setter(CreateInferenceExperimentRequest.setter(Builder::shadowModeConfig)).constructor(ShadowModeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShadowModeConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKey").getter(CreateInferenceExperimentRequest.getter(CreateInferenceExperimentRequest::kmsKey)).setter(CreateInferenceExperimentRequest.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateInferenceExperimentRequest.getter(CreateInferenceExperimentRequest::tags)).setter(CreateInferenceExperimentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, SCHEDULE_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, ENDPOINT_NAME_FIELD, MODEL_VARIANTS_FIELD, DATA_STORAGE_CONFIG_FIELD, SHADOW_MODE_CONFIG_FIELD, KMS_KEY_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateInferenceExperimentRequest.memberNameToFieldInitializer();
    private final String name;
    private final String type;
    private final InferenceExperimentSchedule schedule;
    private final String description;
    private final String roleArn;
    private final String endpointName;
    private final List<ModelVariantConfig> modelVariants;
    private final InferenceExperimentDataStorageConfig dataStorageConfig;
    private final ShadowModeConfig shadowModeConfig;
    private final String kmsKey;
    private final List<Tag> tags;

    private CreateInferenceExperimentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.type = builder.type;
        this.schedule = builder.schedule;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.endpointName = builder.endpointName;
        this.modelVariants = builder.modelVariants;
        this.dataStorageConfig = builder.dataStorageConfig;
        this.shadowModeConfig = builder.shadowModeConfig;
        this.kmsKey = builder.kmsKey;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final InferenceExperimentType type() {
        return InferenceExperimentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final InferenceExperimentSchedule schedule() {
        return this.schedule;
    }

    public final String description() {
        return this.description;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final boolean hasModelVariants() {
        return this.modelVariants != null && !(this.modelVariants instanceof SdkAutoConstructList);
    }

    public final List<ModelVariantConfig> modelVariants() {
        return this.modelVariants;
    }

    public final InferenceExperimentDataStorageConfig dataStorageConfig() {
        return this.dataStorageConfig;
    }

    public final ShadowModeConfig shadowModeConfig() {
        return this.shadowModeConfig;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelVariants() ? this.modelVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStorageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowModeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInferenceExperimentRequest)) {
            return false;
        }
        CreateInferenceExperimentRequest other = (CreateInferenceExperimentRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.endpointName(), other.endpointName()) && this.hasModelVariants() == other.hasModelVariants() && Objects.equals(this.modelVariants(), other.modelVariants()) && Objects.equals(this.dataStorageConfig(), other.dataStorageConfig()) && Objects.equals(this.shadowModeConfig(), other.shadowModeConfig()) && Objects.equals(this.kmsKey(), other.kmsKey()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInferenceExperimentRequest").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Schedule", (Object)this.schedule()).add("Description", (Object)this.description()).add("RoleArn", (Object)this.roleArn()).add("EndpointName", (Object)this.endpointName()).add("ModelVariants", this.hasModelVariants() ? this.modelVariants() : null).add("DataStorageConfig", (Object)this.dataStorageConfig()).add("ShadowModeConfig", (Object)this.shadowModeConfig()).add("KmsKey", (Object)this.kmsKey()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "ModelVariants": {
                return Optional.ofNullable(clazz.cast(this.modelVariants()));
            }
            case "DataStorageConfig": {
                return Optional.ofNullable(clazz.cast(this.dataStorageConfig()));
            }
            case "ShadowModeConfig": {
                return Optional.ofNullable(clazz.cast(this.shadowModeConfig()));
            }
            case "KmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("ModelVariants", MODEL_VARIANTS_FIELD);
        map.put("DataStorageConfig", DATA_STORAGE_CONFIG_FIELD);
        map.put("ShadowModeConfig", SHADOW_MODE_CONFIG_FIELD);
        map.put("KmsKey", KMS_KEY_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInferenceExperimentRequest, T> g) {
        return obj -> g.apply((CreateInferenceExperimentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private InferenceExperimentSchedule schedule;
        private String description;
        private String roleArn;
        private String endpointName;
        private List<ModelVariantConfig> modelVariants = DefaultSdkAutoConstructList.getInstance();
        private InferenceExperimentDataStorageConfig dataStorageConfig;
        private ShadowModeConfig shadowModeConfig;
        private String kmsKey;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInferenceExperimentRequest model) {
            super(model);
            this.name(model.name);
            this.type(model.type);
            this.schedule(model.schedule);
            this.description(model.description);
            this.roleArn(model.roleArn);
            this.endpointName(model.endpointName);
            this.modelVariants(model.modelVariants);
            this.dataStorageConfig(model.dataStorageConfig);
            this.shadowModeConfig(model.shadowModeConfig);
            this.kmsKey(model.kmsKey);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InferenceExperimentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final InferenceExperimentSchedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(InferenceExperimentSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(InferenceExperimentSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final List<ModelVariantConfig.Builder> getModelVariants() {
            List<ModelVariantConfig.Builder> result = ModelVariantConfigListCopier.copyToBuilder(this.modelVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelVariants(Collection<ModelVariantConfig.BuilderImpl> modelVariants) {
            this.modelVariants = ModelVariantConfigListCopier.copyFromBuilder(modelVariants);
        }

        @Override
        public final Builder modelVariants(Collection<ModelVariantConfig> modelVariants) {
            this.modelVariants = ModelVariantConfigListCopier.copy(modelVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariants(ModelVariantConfig ... modelVariants) {
            this.modelVariants(Arrays.asList(modelVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariants(Consumer<ModelVariantConfig.Builder> ... modelVariants) {
            this.modelVariants(Stream.of(modelVariants).map(c -> (ModelVariantConfig)((ModelVariantConfig.Builder)ModelVariantConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InferenceExperimentDataStorageConfig.Builder getDataStorageConfig() {
            return this.dataStorageConfig != null ? this.dataStorageConfig.toBuilder() : null;
        }

        public final void setDataStorageConfig(InferenceExperimentDataStorageConfig.BuilderImpl dataStorageConfig) {
            this.dataStorageConfig = dataStorageConfig != null ? dataStorageConfig.build() : null;
        }

        @Override
        public final Builder dataStorageConfig(InferenceExperimentDataStorageConfig dataStorageConfig) {
            this.dataStorageConfig = dataStorageConfig;
            return this;
        }

        public final ShadowModeConfig.Builder getShadowModeConfig() {
            return this.shadowModeConfig != null ? this.shadowModeConfig.toBuilder() : null;
        }

        public final void setShadowModeConfig(ShadowModeConfig.BuilderImpl shadowModeConfig) {
            this.shadowModeConfig = shadowModeConfig != null ? shadowModeConfig.build() : null;
        }

        @Override
        public final Builder shadowModeConfig(ShadowModeConfig shadowModeConfig) {
            this.shadowModeConfig = shadowModeConfig;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInferenceExperimentRequest build() {
            return new CreateInferenceExperimentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInferenceExperimentRequest> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(InferenceExperimentType var1);

        public Builder schedule(InferenceExperimentSchedule var1);

        default public Builder schedule(Consumer<InferenceExperimentSchedule.Builder> schedule) {
            return this.schedule((InferenceExperimentSchedule)((InferenceExperimentSchedule.Builder)InferenceExperimentSchedule.builder().applyMutation(schedule)).build());
        }

        public Builder description(String var1);

        public Builder roleArn(String var1);

        public Builder endpointName(String var1);

        public Builder modelVariants(Collection<ModelVariantConfig> var1);

        public Builder modelVariants(ModelVariantConfig ... var1);

        public Builder modelVariants(Consumer<ModelVariantConfig.Builder> ... var1);

        public Builder dataStorageConfig(InferenceExperimentDataStorageConfig var1);

        default public Builder dataStorageConfig(Consumer<InferenceExperimentDataStorageConfig.Builder> dataStorageConfig) {
            return this.dataStorageConfig((InferenceExperimentDataStorageConfig)((InferenceExperimentDataStorageConfig.Builder)InferenceExperimentDataStorageConfig.builder().applyMutation(dataStorageConfig)).build());
        }

        public Builder shadowModeConfig(ShadowModeConfig var1);

        default public Builder shadowModeConfig(Consumer<ShadowModeConfig.Builder> shadowModeConfig) {
            return this.shadowModeConfig((ShadowModeConfig)((ShadowModeConfig.Builder)ShadowModeConfig.builder().applyMutation(shadowModeConfig)).build());
        }

        public Builder kmsKey(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

