/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.CodeRepositorySummary;
import software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesResponse;

public class ListCodeRepositoriesPublisher
implements SdkPublisher<ListCodeRepositoriesResponse> {
    private final SageMakerAsyncClient client;
    private final ListCodeRepositoriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCodeRepositoriesPublisher(SageMakerAsyncClient client, ListCodeRepositoriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCodeRepositoriesPublisher(SageMakerAsyncClient client, ListCodeRepositoriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCodeRepositoriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCodeRepositoriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CodeRepositorySummary> codeRepositorySummaryList() {
        Function<ListCodeRepositoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.codeRepositorySummaryList() != null) {
                return response.codeRepositorySummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCodeRepositoriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCodeRepositoriesResponseFetcher
    implements AsyncPageFetcher<ListCodeRepositoriesResponse> {
        private ListCodeRepositoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListCodeRepositoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCodeRepositoriesResponse> nextPage(ListCodeRepositoriesResponse previousPage) {
            if (previousPage == null) {
                return ListCodeRepositoriesPublisher.this.client.listCodeRepositories(ListCodeRepositoriesPublisher.this.firstRequest);
            }
            return ListCodeRepositoriesPublisher.this.client.listCodeRepositories((ListCodeRepositoriesRequest)((Object)ListCodeRepositoriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

