/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.BatchStrategy;
import software.amazon.awssdk.services.sagemaker.model.TransformEnvironmentMapCopier;
import software.amazon.awssdk.services.sagemaker.model.TransformInput;
import software.amazon.awssdk.services.sagemaker.model.TransformOutput;
import software.amazon.awssdk.services.sagemaker.model.TransformResources;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformJobDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformJobDefinition> {
    private static final SdkField<Integer> MAX_CONCURRENT_TRANSFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxConcurrentTransforms").getter(TransformJobDefinition.getter(TransformJobDefinition::maxConcurrentTransforms)).setter(TransformJobDefinition.setter(Builder::maxConcurrentTransforms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentTransforms").build()}).build();
    private static final SdkField<Integer> MAX_PAYLOAD_IN_MB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxPayloadInMB").getter(TransformJobDefinition.getter(TransformJobDefinition::maxPayloadInMB)).setter(TransformJobDefinition.setter(Builder::maxPayloadInMB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPayloadInMB").build()}).build();
    private static final SdkField<String> BATCH_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BatchStrategy").getter(TransformJobDefinition.getter(TransformJobDefinition::batchStrategyAsString)).setter(TransformJobDefinition.setter(Builder::batchStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchStrategy").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Environment").getter(TransformJobDefinition.getter(TransformJobDefinition::environment)).setter(TransformJobDefinition.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<TransformInput> TRANSFORM_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransformInput").getter(TransformJobDefinition.getter(TransformJobDefinition::transformInput)).setter(TransformJobDefinition.setter(Builder::transformInput)).constructor(TransformInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformInput").build()}).build();
    private static final SdkField<TransformOutput> TRANSFORM_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransformOutput").getter(TransformJobDefinition.getter(TransformJobDefinition::transformOutput)).setter(TransformJobDefinition.setter(Builder::transformOutput)).constructor(TransformOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformOutput").build()}).build();
    private static final SdkField<TransformResources> TRANSFORM_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransformResources").getter(TransformJobDefinition.getter(TransformJobDefinition::transformResources)).setter(TransformJobDefinition.setter(Builder::transformResources)).constructor(TransformResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformResources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_CONCURRENT_TRANSFORMS_FIELD, MAX_PAYLOAD_IN_MB_FIELD, BATCH_STRATEGY_FIELD, ENVIRONMENT_FIELD, TRANSFORM_INPUT_FIELD, TRANSFORM_OUTPUT_FIELD, TRANSFORM_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransformJobDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer maxConcurrentTransforms;
    private final Integer maxPayloadInMB;
    private final String batchStrategy;
    private final Map<String, String> environment;
    private final TransformInput transformInput;
    private final TransformOutput transformOutput;
    private final TransformResources transformResources;

    private TransformJobDefinition(BuilderImpl builder) {
        this.maxConcurrentTransforms = builder.maxConcurrentTransforms;
        this.maxPayloadInMB = builder.maxPayloadInMB;
        this.batchStrategy = builder.batchStrategy;
        this.environment = builder.environment;
        this.transformInput = builder.transformInput;
        this.transformOutput = builder.transformOutput;
        this.transformResources = builder.transformResources;
    }

    public final Integer maxConcurrentTransforms() {
        return this.maxConcurrentTransforms;
    }

    public final Integer maxPayloadInMB() {
        return this.maxPayloadInMB;
    }

    public final BatchStrategy batchStrategy() {
        return BatchStrategy.fromValue(this.batchStrategy);
    }

    public final String batchStrategyAsString() {
        return this.batchStrategy;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environment() {
        return this.environment;
    }

    public final TransformInput transformInput() {
        return this.transformInput;
    }

    public final TransformOutput transformOutput() {
        return this.transformOutput;
    }

    public final TransformResources transformResources() {
        return this.transformResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentTransforms());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPayloadInMB());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transformInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformResources());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformJobDefinition)) {
            return false;
        }
        TransformJobDefinition other = (TransformJobDefinition)obj;
        return Objects.equals(this.maxConcurrentTransforms(), other.maxConcurrentTransforms()) && Objects.equals(this.maxPayloadInMB(), other.maxPayloadInMB()) && Objects.equals(this.batchStrategyAsString(), other.batchStrategyAsString()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.transformInput(), other.transformInput()) && Objects.equals(this.transformOutput(), other.transformOutput()) && Objects.equals(this.transformResources(), other.transformResources());
    }

    public final String toString() {
        return ToString.builder((String)"TransformJobDefinition").add("MaxConcurrentTransforms", (Object)this.maxConcurrentTransforms()).add("MaxPayloadInMB", (Object)this.maxPayloadInMB()).add("BatchStrategy", (Object)this.batchStrategyAsString()).add("Environment", this.hasEnvironment() ? this.environment() : null).add("TransformInput", (Object)this.transformInput()).add("TransformOutput", (Object)this.transformOutput()).add("TransformResources", (Object)this.transformResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxConcurrentTransforms": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrentTransforms()));
            }
            case "MaxPayloadInMB": {
                return Optional.ofNullable(clazz.cast(this.maxPayloadInMB()));
            }
            case "BatchStrategy": {
                return Optional.ofNullable(clazz.cast(this.batchStrategyAsString()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "TransformInput": {
                return Optional.ofNullable(clazz.cast(this.transformInput()));
            }
            case "TransformOutput": {
                return Optional.ofNullable(clazz.cast(this.transformOutput()));
            }
            case "TransformResources": {
                return Optional.ofNullable(clazz.cast(this.transformResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MaxConcurrentTransforms", MAX_CONCURRENT_TRANSFORMS_FIELD);
        map.put("MaxPayloadInMB", MAX_PAYLOAD_IN_MB_FIELD);
        map.put("BatchStrategy", BATCH_STRATEGY_FIELD);
        map.put("Environment", ENVIRONMENT_FIELD);
        map.put("TransformInput", TRANSFORM_INPUT_FIELD);
        map.put("TransformOutput", TRANSFORM_OUTPUT_FIELD);
        map.put("TransformResources", TRANSFORM_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransformJobDefinition, T> g) {
        return obj -> g.apply((TransformJobDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxConcurrentTransforms;
        private Integer maxPayloadInMB;
        private String batchStrategy;
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();
        private TransformInput transformInput;
        private TransformOutput transformOutput;
        private TransformResources transformResources;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformJobDefinition model) {
            this.maxConcurrentTransforms(model.maxConcurrentTransforms);
            this.maxPayloadInMB(model.maxPayloadInMB);
            this.batchStrategy(model.batchStrategy);
            this.environment(model.environment);
            this.transformInput(model.transformInput);
            this.transformOutput(model.transformOutput);
            this.transformResources(model.transformResources);
        }

        public final Integer getMaxConcurrentTransforms() {
            return this.maxConcurrentTransforms;
        }

        public final void setMaxConcurrentTransforms(Integer maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
        }

        @Override
        public final Builder maxConcurrentTransforms(Integer maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
            return this;
        }

        public final Integer getMaxPayloadInMB() {
            return this.maxPayloadInMB;
        }

        public final void setMaxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
        }

        @Override
        public final Builder maxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
            return this;
        }

        public final String getBatchStrategy() {
            return this.batchStrategy;
        }

        public final void setBatchStrategy(String batchStrategy) {
            this.batchStrategy = batchStrategy;
        }

        @Override
        public final Builder batchStrategy(String batchStrategy) {
            this.batchStrategy = batchStrategy;
            return this;
        }

        @Override
        public final Builder batchStrategy(BatchStrategy batchStrategy) {
            this.batchStrategy(batchStrategy == null ? null : batchStrategy.toString());
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (this.environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = TransformEnvironmentMapCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = TransformEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final TransformInput.Builder getTransformInput() {
            return this.transformInput != null ? this.transformInput.toBuilder() : null;
        }

        public final void setTransformInput(TransformInput.BuilderImpl transformInput) {
            this.transformInput = transformInput != null ? transformInput.build() : null;
        }

        @Override
        public final Builder transformInput(TransformInput transformInput) {
            this.transformInput = transformInput;
            return this;
        }

        public final TransformOutput.Builder getTransformOutput() {
            return this.transformOutput != null ? this.transformOutput.toBuilder() : null;
        }

        public final void setTransformOutput(TransformOutput.BuilderImpl transformOutput) {
            this.transformOutput = transformOutput != null ? transformOutput.build() : null;
        }

        @Override
        public final Builder transformOutput(TransformOutput transformOutput) {
            this.transformOutput = transformOutput;
            return this;
        }

        public final TransformResources.Builder getTransformResources() {
            return this.transformResources != null ? this.transformResources.toBuilder() : null;
        }

        public final void setTransformResources(TransformResources.BuilderImpl transformResources) {
            this.transformResources = transformResources != null ? transformResources.build() : null;
        }

        @Override
        public final Builder transformResources(TransformResources transformResources) {
            this.transformResources = transformResources;
            return this;
        }

        public TransformJobDefinition build() {
            return new TransformJobDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformJobDefinition> {
        public Builder maxConcurrentTransforms(Integer var1);

        public Builder maxPayloadInMB(Integer var1);

        public Builder batchStrategy(String var1);

        public Builder batchStrategy(BatchStrategy var1);

        public Builder environment(Map<String, String> var1);

        public Builder transformInput(TransformInput var1);

        default public Builder transformInput(Consumer<TransformInput.Builder> transformInput) {
            return this.transformInput((TransformInput)((TransformInput.Builder)TransformInput.builder().applyMutation(transformInput)).build());
        }

        public Builder transformOutput(TransformOutput var1);

        default public Builder transformOutput(Consumer<TransformOutput.Builder> transformOutput) {
            return this.transformOutput((TransformOutput)((TransformOutput.Builder)TransformOutput.builder().applyMutation(transformOutput)).build());
        }

        public Builder transformResources(TransformResources var1);

        default public Builder transformResources(Consumer<TransformResources.Builder> transformResources) {
            return this.transformResources((TransformResources)((TransformResources.Builder)TransformResources.builder().applyMutation(transformResources)).build());
        }
    }
}

