/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentCapacitySize;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceComponentRollingUpdatePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceComponentRollingUpdatePolicy> {
    private static final SdkField<InferenceComponentCapacitySize> MAXIMUM_BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaximumBatchSize").getter(InferenceComponentRollingUpdatePolicy.getter(InferenceComponentRollingUpdatePolicy::maximumBatchSize)).setter(InferenceComponentRollingUpdatePolicy.setter(Builder::maximumBatchSize)).constructor(InferenceComponentCapacitySize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchSize").build()}).build();
    private static final SdkField<Integer> WAIT_INTERVAL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WaitIntervalInSeconds").getter(InferenceComponentRollingUpdatePolicy.getter(InferenceComponentRollingUpdatePolicy::waitIntervalInSeconds)).setter(InferenceComponentRollingUpdatePolicy.setter(Builder::waitIntervalInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitIntervalInSeconds").build()}).build();
    private static final SdkField<Integer> MAXIMUM_EXECUTION_TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumExecutionTimeoutInSeconds").getter(InferenceComponentRollingUpdatePolicy.getter(InferenceComponentRollingUpdatePolicy::maximumExecutionTimeoutInSeconds)).setter(InferenceComponentRollingUpdatePolicy.setter(Builder::maximumExecutionTimeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumExecutionTimeoutInSeconds").build()}).build();
    private static final SdkField<InferenceComponentCapacitySize> ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RollbackMaximumBatchSize").getter(InferenceComponentRollingUpdatePolicy.getter(InferenceComponentRollingUpdatePolicy::rollbackMaximumBatchSize)).setter(InferenceComponentRollingUpdatePolicy.setter(Builder::rollbackMaximumBatchSize)).constructor(InferenceComponentCapacitySize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackMaximumBatchSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_BATCH_SIZE_FIELD, WAIT_INTERVAL_IN_SECONDS_FIELD, MAXIMUM_EXECUTION_TIMEOUT_IN_SECONDS_FIELD, ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InferenceComponentRollingUpdatePolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final InferenceComponentCapacitySize maximumBatchSize;
    private final Integer waitIntervalInSeconds;
    private final Integer maximumExecutionTimeoutInSeconds;
    private final InferenceComponentCapacitySize rollbackMaximumBatchSize;

    private InferenceComponentRollingUpdatePolicy(BuilderImpl builder) {
        this.maximumBatchSize = builder.maximumBatchSize;
        this.waitIntervalInSeconds = builder.waitIntervalInSeconds;
        this.maximumExecutionTimeoutInSeconds = builder.maximumExecutionTimeoutInSeconds;
        this.rollbackMaximumBatchSize = builder.rollbackMaximumBatchSize;
    }

    public final InferenceComponentCapacitySize maximumBatchSize() {
        return this.maximumBatchSize;
    }

    public final Integer waitIntervalInSeconds() {
        return this.waitIntervalInSeconds;
    }

    public final Integer maximumExecutionTimeoutInSeconds() {
        return this.maximumExecutionTimeoutInSeconds;
    }

    public final InferenceComponentCapacitySize rollbackMaximumBatchSize() {
        return this.rollbackMaximumBatchSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBatchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitIntervalInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumExecutionTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackMaximumBatchSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentRollingUpdatePolicy)) {
            return false;
        }
        InferenceComponentRollingUpdatePolicy other = (InferenceComponentRollingUpdatePolicy)obj;
        return Objects.equals(this.maximumBatchSize(), other.maximumBatchSize()) && Objects.equals(this.waitIntervalInSeconds(), other.waitIntervalInSeconds()) && Objects.equals(this.maximumExecutionTimeoutInSeconds(), other.maximumExecutionTimeoutInSeconds()) && Objects.equals(this.rollbackMaximumBatchSize(), other.rollbackMaximumBatchSize());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceComponentRollingUpdatePolicy").add("MaximumBatchSize", (Object)this.maximumBatchSize()).add("WaitIntervalInSeconds", (Object)this.waitIntervalInSeconds()).add("MaximumExecutionTimeoutInSeconds", (Object)this.maximumExecutionTimeoutInSeconds()).add("RollbackMaximumBatchSize", (Object)this.rollbackMaximumBatchSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaximumBatchSize": {
                return Optional.ofNullable(clazz.cast(this.maximumBatchSize()));
            }
            case "WaitIntervalInSeconds": {
                return Optional.ofNullable(clazz.cast(this.waitIntervalInSeconds()));
            }
            case "MaximumExecutionTimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumExecutionTimeoutInSeconds()));
            }
            case "RollbackMaximumBatchSize": {
                return Optional.ofNullable(clazz.cast(this.rollbackMaximumBatchSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MaximumBatchSize", MAXIMUM_BATCH_SIZE_FIELD);
        map.put("WaitIntervalInSeconds", WAIT_INTERVAL_IN_SECONDS_FIELD);
        map.put("MaximumExecutionTimeoutInSeconds", MAXIMUM_EXECUTION_TIMEOUT_IN_SECONDS_FIELD);
        map.put("RollbackMaximumBatchSize", ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentRollingUpdatePolicy, T> g) {
        return obj -> g.apply((InferenceComponentRollingUpdatePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InferenceComponentCapacitySize maximumBatchSize;
        private Integer waitIntervalInSeconds;
        private Integer maximumExecutionTimeoutInSeconds;
        private InferenceComponentCapacitySize rollbackMaximumBatchSize;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentRollingUpdatePolicy model) {
            this.maximumBatchSize(model.maximumBatchSize);
            this.waitIntervalInSeconds(model.waitIntervalInSeconds);
            this.maximumExecutionTimeoutInSeconds(model.maximumExecutionTimeoutInSeconds);
            this.rollbackMaximumBatchSize(model.rollbackMaximumBatchSize);
        }

        public final InferenceComponentCapacitySize.Builder getMaximumBatchSize() {
            return this.maximumBatchSize != null ? this.maximumBatchSize.toBuilder() : null;
        }

        public final void setMaximumBatchSize(InferenceComponentCapacitySize.BuilderImpl maximumBatchSize) {
            this.maximumBatchSize = maximumBatchSize != null ? maximumBatchSize.build() : null;
        }

        @Override
        public final Builder maximumBatchSize(InferenceComponentCapacitySize maximumBatchSize) {
            this.maximumBatchSize = maximumBatchSize;
            return this;
        }

        public final Integer getWaitIntervalInSeconds() {
            return this.waitIntervalInSeconds;
        }

        public final void setWaitIntervalInSeconds(Integer waitIntervalInSeconds) {
            this.waitIntervalInSeconds = waitIntervalInSeconds;
        }

        @Override
        public final Builder waitIntervalInSeconds(Integer waitIntervalInSeconds) {
            this.waitIntervalInSeconds = waitIntervalInSeconds;
            return this;
        }

        public final Integer getMaximumExecutionTimeoutInSeconds() {
            return this.maximumExecutionTimeoutInSeconds;
        }

        public final void setMaximumExecutionTimeoutInSeconds(Integer maximumExecutionTimeoutInSeconds) {
            this.maximumExecutionTimeoutInSeconds = maximumExecutionTimeoutInSeconds;
        }

        @Override
        public final Builder maximumExecutionTimeoutInSeconds(Integer maximumExecutionTimeoutInSeconds) {
            this.maximumExecutionTimeoutInSeconds = maximumExecutionTimeoutInSeconds;
            return this;
        }

        public final InferenceComponentCapacitySize.Builder getRollbackMaximumBatchSize() {
            return this.rollbackMaximumBatchSize != null ? this.rollbackMaximumBatchSize.toBuilder() : null;
        }

        public final void setRollbackMaximumBatchSize(InferenceComponentCapacitySize.BuilderImpl rollbackMaximumBatchSize) {
            this.rollbackMaximumBatchSize = rollbackMaximumBatchSize != null ? rollbackMaximumBatchSize.build() : null;
        }

        @Override
        public final Builder rollbackMaximumBatchSize(InferenceComponentCapacitySize rollbackMaximumBatchSize) {
            this.rollbackMaximumBatchSize = rollbackMaximumBatchSize;
            return this;
        }

        public InferenceComponentRollingUpdatePolicy build() {
            return new InferenceComponentRollingUpdatePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceComponentRollingUpdatePolicy> {
        public Builder maximumBatchSize(InferenceComponentCapacitySize var1);

        default public Builder maximumBatchSize(Consumer<InferenceComponentCapacitySize.Builder> maximumBatchSize) {
            return this.maximumBatchSize((InferenceComponentCapacitySize)((InferenceComponentCapacitySize.Builder)InferenceComponentCapacitySize.builder().applyMutation(maximumBatchSize)).build());
        }

        public Builder waitIntervalInSeconds(Integer var1);

        public Builder maximumExecutionTimeoutInSeconds(Integer var1);

        public Builder rollbackMaximumBatchSize(InferenceComponentCapacitySize var1);

        default public Builder rollbackMaximumBatchSize(Consumer<InferenceComponentCapacitySize.Builder> rollbackMaximumBatchSize) {
            return this.rollbackMaximumBatchSize((InferenceComponentCapacitySize)((InferenceComponentCapacitySize.Builder)InferenceComponentCapacitySize.builder().applyMutation(rollbackMaximumBatchSize)).build());
        }
    }
}

