/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLineageGroupPolicyResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, GetLineageGroupPolicyResponse> {
    private static final SdkField<String> LINEAGE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LineageGroupArn").getter(GetLineageGroupPolicyResponse.getter(GetLineageGroupPolicyResponse::lineageGroupArn)).setter(GetLineageGroupPolicyResponse.setter(Builder::lineageGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineageGroupArn").build()}).build();
    private static final SdkField<String> RESOURCE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourcePolicy").getter(GetLineageGroupPolicyResponse.getter(GetLineageGroupPolicyResponse::resourcePolicy)).setter(GetLineageGroupPolicyResponse.setter(Builder::resourcePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINEAGE_GROUP_ARN_FIELD, RESOURCE_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLineageGroupPolicyResponse.memberNameToFieldInitializer();
    private final String lineageGroupArn;
    private final String resourcePolicy;

    private GetLineageGroupPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.lineageGroupArn = builder.lineageGroupArn;
        this.resourcePolicy = builder.resourcePolicy;
    }

    public final String lineageGroupArn() {
        return this.lineageGroupArn;
    }

    public final String resourcePolicy() {
        return this.resourcePolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lineageGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcePolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLineageGroupPolicyResponse)) {
            return false;
        }
        GetLineageGroupPolicyResponse other = (GetLineageGroupPolicyResponse)((Object)obj);
        return Objects.equals(this.lineageGroupArn(), other.lineageGroupArn()) && Objects.equals(this.resourcePolicy(), other.resourcePolicy());
    }

    public final String toString() {
        return ToString.builder((String)"GetLineageGroupPolicyResponse").add("LineageGroupArn", (Object)this.lineageGroupArn()).add("ResourcePolicy", (Object)this.resourcePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LineageGroupArn": {
                return Optional.ofNullable(clazz.cast(this.lineageGroupArn()));
            }
            case "ResourcePolicy": {
                return Optional.ofNullable(clazz.cast(this.resourcePolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("LineageGroupArn", LINEAGE_GROUP_ARN_FIELD);
        map.put("ResourcePolicy", RESOURCE_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLineageGroupPolicyResponse, T> g) {
        return obj -> g.apply((GetLineageGroupPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String lineageGroupArn;
        private String resourcePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLineageGroupPolicyResponse model) {
            super(model);
            this.lineageGroupArn(model.lineageGroupArn);
            this.resourcePolicy(model.resourcePolicy);
        }

        public final String getLineageGroupArn() {
            return this.lineageGroupArn;
        }

        public final void setLineageGroupArn(String lineageGroupArn) {
            this.lineageGroupArn = lineageGroupArn;
        }

        @Override
        public final Builder lineageGroupArn(String lineageGroupArn) {
            this.lineageGroupArn = lineageGroupArn;
            return this;
        }

        public final String getResourcePolicy() {
            return this.resourcePolicy;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        @Override
        public GetLineageGroupPolicyResponse build() {
            return new GetLineageGroupPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLineageGroupPolicyResponse> {
        public Builder lineageGroupArn(String var1);

        public Builder resourcePolicy(String var1);
    }
}

