/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AppStatus;
import software.amazon.awssdk.services.sagemaker.model.AppType;
import software.amazon.awssdk.services.sagemaker.model.ResourceSpec;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAppResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeAppResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppArn").getter(DescribeAppResponse.getter(DescribeAppResponse::appArn)).setter(DescribeAppResponse.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppArn").build()}).build();
    private static final SdkField<String> APP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppType").getter(DescribeAppResponse.getter(DescribeAppResponse::appTypeAsString)).setter(DescribeAppResponse.setter(Builder::appType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppType").build()}).build();
    private static final SdkField<String> APP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppName").getter(DescribeAppResponse.getter(DescribeAppResponse::appName)).setter(DescribeAppResponse.setter(Builder::appName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppName").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(DescribeAppResponse.getter(DescribeAppResponse::domainId)).setter(DescribeAppResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserProfileName").getter(DescribeAppResponse.getter(DescribeAppResponse::userProfileName)).setter(DescribeAppResponse.setter(Builder::userProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()}).build();
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpaceName").getter(DescribeAppResponse.getter(DescribeAppResponse::spaceName)).setter(DescribeAppResponse.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeAppResponse.getter(DescribeAppResponse::statusAsString)).setter(DescribeAppResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Boolean> RECOVERY_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RecoveryMode").getter(DescribeAppResponse.getter(DescribeAppResponse::recoveryMode)).setter(DescribeAppResponse.setter(Builder::recoveryMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryMode").build()}).build();
    private static final SdkField<Instant> LAST_HEALTH_CHECK_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastHealthCheckTimestamp").getter(DescribeAppResponse.getter(DescribeAppResponse::lastHealthCheckTimestamp)).setter(DescribeAppResponse.setter(Builder::lastHealthCheckTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastHealthCheckTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_USER_ACTIVITY_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUserActivityTimestamp").getter(DescribeAppResponse.getter(DescribeAppResponse::lastUserActivityTimestamp)).setter(DescribeAppResponse.setter(Builder::lastUserActivityTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUserActivityTimestamp").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeAppResponse.getter(DescribeAppResponse::creationTime)).setter(DescribeAppResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeAppResponse.getter(DescribeAppResponse::failureReason)).setter(DescribeAppResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<ResourceSpec> RESOURCE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceSpec").getter(DescribeAppResponse.getter(DescribeAppResponse::resourceSpec)).setter(DescribeAppResponse.setter(Builder::resourceSpec)).constructor(ResourceSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSpec").build()}).build();
    private static final SdkField<String> BUILT_IN_LIFECYCLE_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuiltInLifecycleConfigArn").getter(DescribeAppResponse.getter(DescribeAppResponse::builtInLifecycleConfigArn)).setter(DescribeAppResponse.setter(Builder::builtInLifecycleConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuiltInLifecycleConfigArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_TYPE_FIELD, APP_NAME_FIELD, DOMAIN_ID_FIELD, USER_PROFILE_NAME_FIELD, SPACE_NAME_FIELD, STATUS_FIELD, RECOVERY_MODE_FIELD, LAST_HEALTH_CHECK_TIMESTAMP_FIELD, LAST_USER_ACTIVITY_TIMESTAMP_FIELD, CREATION_TIME_FIELD, FAILURE_REASON_FIELD, RESOURCE_SPEC_FIELD, BUILT_IN_LIFECYCLE_CONFIG_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAppResponse.memberNameToFieldInitializer();
    private final String appArn;
    private final String appType;
    private final String appName;
    private final String domainId;
    private final String userProfileName;
    private final String spaceName;
    private final String status;
    private final Boolean recoveryMode;
    private final Instant lastHealthCheckTimestamp;
    private final Instant lastUserActivityTimestamp;
    private final Instant creationTime;
    private final String failureReason;
    private final ResourceSpec resourceSpec;
    private final String builtInLifecycleConfigArn;

    private DescribeAppResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appType = builder.appType;
        this.appName = builder.appName;
        this.domainId = builder.domainId;
        this.userProfileName = builder.userProfileName;
        this.spaceName = builder.spaceName;
        this.status = builder.status;
        this.recoveryMode = builder.recoveryMode;
        this.lastHealthCheckTimestamp = builder.lastHealthCheckTimestamp;
        this.lastUserActivityTimestamp = builder.lastUserActivityTimestamp;
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
        this.resourceSpec = builder.resourceSpec;
        this.builtInLifecycleConfigArn = builder.builtInLifecycleConfigArn;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final AppType appType() {
        return AppType.fromValue(this.appType);
    }

    public final String appTypeAsString() {
        return this.appType;
    }

    public final String appName() {
        return this.appName;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String userProfileName() {
        return this.userProfileName;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final AppStatus status() {
        return AppStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Boolean recoveryMode() {
        return this.recoveryMode;
    }

    public final Instant lastHealthCheckTimestamp() {
        return this.lastHealthCheckTimestamp;
    }

    public final Instant lastUserActivityTimestamp() {
        return this.lastUserActivityTimestamp;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final ResourceSpec resourceSpec() {
        return this.resourceSpec;
    }

    public final String builtInLifecycleConfigArn() {
        return this.builtInLifecycleConfigArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.appName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastHealthCheckTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUserActivityTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.builtInLifecycleConfigArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppResponse)) {
            return false;
        }
        DescribeAppResponse other = (DescribeAppResponse)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.appTypeAsString(), other.appTypeAsString()) && Objects.equals(this.appName(), other.appName()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.userProfileName(), other.userProfileName()) && Objects.equals(this.spaceName(), other.spaceName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.recoveryMode(), other.recoveryMode()) && Objects.equals(this.lastHealthCheckTimestamp(), other.lastHealthCheckTimestamp()) && Objects.equals(this.lastUserActivityTimestamp(), other.lastUserActivityTimestamp()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.resourceSpec(), other.resourceSpec()) && Objects.equals(this.builtInLifecycleConfigArn(), other.builtInLifecycleConfigArn());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAppResponse").add("AppArn", (Object)this.appArn()).add("AppType", (Object)this.appTypeAsString()).add("AppName", (Object)this.appName()).add("DomainId", (Object)this.domainId()).add("UserProfileName", (Object)this.userProfileName()).add("SpaceName", (Object)this.spaceName()).add("Status", (Object)this.statusAsString()).add("RecoveryMode", (Object)this.recoveryMode()).add("LastHealthCheckTimestamp", (Object)this.lastHealthCheckTimestamp()).add("LastUserActivityTimestamp", (Object)this.lastUserActivityTimestamp()).add("CreationTime", (Object)this.creationTime()).add("FailureReason", (Object)this.failureReason()).add("ResourceSpec", (Object)this.resourceSpec()).add("BuiltInLifecycleConfigArn", (Object)this.builtInLifecycleConfigArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "AppType": {
                return Optional.ofNullable(clazz.cast(this.appTypeAsString()));
            }
            case "AppName": {
                return Optional.ofNullable(clazz.cast(this.appName()));
            }
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "UserProfileName": {
                return Optional.ofNullable(clazz.cast(this.userProfileName()));
            }
            case "SpaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "RecoveryMode": {
                return Optional.ofNullable(clazz.cast(this.recoveryMode()));
            }
            case "LastHealthCheckTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastHealthCheckTimestamp()));
            }
            case "LastUserActivityTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUserActivityTimestamp()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ResourceSpec": {
                return Optional.ofNullable(clazz.cast(this.resourceSpec()));
            }
            case "BuiltInLifecycleConfigArn": {
                return Optional.ofNullable(clazz.cast(this.builtInLifecycleConfigArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AppArn", APP_ARN_FIELD);
        map.put("AppType", APP_TYPE_FIELD);
        map.put("AppName", APP_NAME_FIELD);
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("UserProfileName", USER_PROFILE_NAME_FIELD);
        map.put("SpaceName", SPACE_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RecoveryMode", RECOVERY_MODE_FIELD);
        map.put("LastHealthCheckTimestamp", LAST_HEALTH_CHECK_TIMESTAMP_FIELD);
        map.put("LastUserActivityTimestamp", LAST_USER_ACTIVITY_TIMESTAMP_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("ResourceSpec", RESOURCE_SPEC_FIELD);
        map.put("BuiltInLifecycleConfigArn", BUILT_IN_LIFECYCLE_CONFIG_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppResponse, T> g) {
        return obj -> g.apply((DescribeAppResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String appArn;
        private String appType;
        private String appName;
        private String domainId;
        private String userProfileName;
        private String spaceName;
        private String status;
        private Boolean recoveryMode;
        private Instant lastHealthCheckTimestamp;
        private Instant lastUserActivityTimestamp;
        private Instant creationTime;
        private String failureReason;
        private ResourceSpec resourceSpec;
        private String builtInLifecycleConfigArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppResponse model) {
            super(model);
            this.appArn(model.appArn);
            this.appType(model.appType);
            this.appName(model.appName);
            this.domainId(model.domainId);
            this.userProfileName(model.userProfileName);
            this.spaceName(model.spaceName);
            this.status(model.status);
            this.recoveryMode(model.recoveryMode);
            this.lastHealthCheckTimestamp(model.lastHealthCheckTimestamp);
            this.lastUserActivityTimestamp(model.lastUserActivityTimestamp);
            this.creationTime(model.creationTime);
            this.failureReason(model.failureReason);
            this.resourceSpec(model.resourceSpec);
            this.builtInLifecycleConfigArn(model.builtInLifecycleConfigArn);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppType() {
            return this.appType;
        }

        public final void setAppType(String appType) {
            this.appType = appType;
        }

        @Override
        public final Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Override
        public final Builder appType(AppType appType) {
            this.appType(appType == null ? null : appType.toString());
            return this;
        }

        public final String getAppName() {
            return this.appName;
        }

        public final void setAppName(String appName) {
            this.appName = appName;
        }

        @Override
        public final Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getUserProfileName() {
            return this.userProfileName;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getRecoveryMode() {
            return this.recoveryMode;
        }

        public final void setRecoveryMode(Boolean recoveryMode) {
            this.recoveryMode = recoveryMode;
        }

        @Override
        public final Builder recoveryMode(Boolean recoveryMode) {
            this.recoveryMode = recoveryMode;
            return this;
        }

        public final Instant getLastHealthCheckTimestamp() {
            return this.lastHealthCheckTimestamp;
        }

        public final void setLastHealthCheckTimestamp(Instant lastHealthCheckTimestamp) {
            this.lastHealthCheckTimestamp = lastHealthCheckTimestamp;
        }

        @Override
        public final Builder lastHealthCheckTimestamp(Instant lastHealthCheckTimestamp) {
            this.lastHealthCheckTimestamp = lastHealthCheckTimestamp;
            return this;
        }

        public final Instant getLastUserActivityTimestamp() {
            return this.lastUserActivityTimestamp;
        }

        public final void setLastUserActivityTimestamp(Instant lastUserActivityTimestamp) {
            this.lastUserActivityTimestamp = lastUserActivityTimestamp;
        }

        @Override
        public final Builder lastUserActivityTimestamp(Instant lastUserActivityTimestamp) {
            this.lastUserActivityTimestamp = lastUserActivityTimestamp;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final ResourceSpec.Builder getResourceSpec() {
            return this.resourceSpec != null ? this.resourceSpec.toBuilder() : null;
        }

        public final void setResourceSpec(ResourceSpec.BuilderImpl resourceSpec) {
            this.resourceSpec = resourceSpec != null ? resourceSpec.build() : null;
        }

        @Override
        public final Builder resourceSpec(ResourceSpec resourceSpec) {
            this.resourceSpec = resourceSpec;
            return this;
        }

        public final String getBuiltInLifecycleConfigArn() {
            return this.builtInLifecycleConfigArn;
        }

        public final void setBuiltInLifecycleConfigArn(String builtInLifecycleConfigArn) {
            this.builtInLifecycleConfigArn = builtInLifecycleConfigArn;
        }

        @Override
        public final Builder builtInLifecycleConfigArn(String builtInLifecycleConfigArn) {
            this.builtInLifecycleConfigArn = builtInLifecycleConfigArn;
            return this;
        }

        @Override
        public DescribeAppResponse build() {
            return new DescribeAppResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAppResponse> {
        public Builder appArn(String var1);

        public Builder appType(String var1);

        public Builder appType(AppType var1);

        public Builder appName(String var1);

        public Builder domainId(String var1);

        public Builder userProfileName(String var1);

        public Builder spaceName(String var1);

        public Builder status(String var1);

        public Builder status(AppStatus var1);

        public Builder recoveryMode(Boolean var1);

        public Builder lastHealthCheckTimestamp(Instant var1);

        public Builder lastUserActivityTimestamp(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder resourceSpec(ResourceSpec var1);

        default public Builder resourceSpec(Consumer<ResourceSpec.Builder> resourceSpec) {
            return this.resourceSpec((ResourceSpec)((ResourceSpec.Builder)ResourceSpec.builder().applyMutation(resourceSpec)).build());
        }

        public Builder builtInLifecycleConfigArn(String var1);
    }
}

