/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.DeviceSelectionConfig;
import software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentStage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentStage> {
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StageName").getter(DeploymentStage.getter(DeploymentStage::stageName)).setter(DeploymentStage.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageName").build()}).build();
    private static final SdkField<DeviceSelectionConfig> DEVICE_SELECTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceSelectionConfig").getter(DeploymentStage.getter(DeploymentStage::deviceSelectionConfig)).setter(DeploymentStage.setter(Builder::deviceSelectionConfig)).constructor(DeviceSelectionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceSelectionConfig").build()}).build();
    private static final SdkField<EdgeDeploymentConfig> DEPLOYMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeploymentConfig").getter(DeploymentStage.getter(DeploymentStage::deploymentConfig)).setter(DeploymentStage.setter(Builder::deploymentConfig)).constructor(EdgeDeploymentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_NAME_FIELD, DEVICE_SELECTION_CONFIG_FIELD, DEPLOYMENT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeploymentStage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stageName;
    private final DeviceSelectionConfig deviceSelectionConfig;
    private final EdgeDeploymentConfig deploymentConfig;

    private DeploymentStage(BuilderImpl builder) {
        this.stageName = builder.stageName;
        this.deviceSelectionConfig = builder.deviceSelectionConfig;
        this.deploymentConfig = builder.deploymentConfig;
    }

    public final String stageName() {
        return this.stageName;
    }

    public final DeviceSelectionConfig deviceSelectionConfig() {
        return this.deviceSelectionConfig;
    }

    public final EdgeDeploymentConfig deploymentConfig() {
        return this.deploymentConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceSelectionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentStage)) {
            return false;
        }
        DeploymentStage other = (DeploymentStage)obj;
        return Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.deviceSelectionConfig(), other.deviceSelectionConfig()) && Objects.equals(this.deploymentConfig(), other.deploymentConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentStage").add("StageName", (Object)this.stageName()).add("DeviceSelectionConfig", (Object)this.deviceSelectionConfig()).add("DeploymentConfig", (Object)this.deploymentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "DeviceSelectionConfig": {
                return Optional.ofNullable(clazz.cast(this.deviceSelectionConfig()));
            }
            case "DeploymentConfig": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StageName", STAGE_NAME_FIELD);
        map.put("DeviceSelectionConfig", DEVICE_SELECTION_CONFIG_FIELD);
        map.put("DeploymentConfig", DEPLOYMENT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentStage, T> g) {
        return obj -> g.apply((DeploymentStage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stageName;
        private DeviceSelectionConfig deviceSelectionConfig;
        private EdgeDeploymentConfig deploymentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentStage model) {
            this.stageName(model.stageName);
            this.deviceSelectionConfig(model.deviceSelectionConfig);
            this.deploymentConfig(model.deploymentConfig);
        }

        public final String getStageName() {
            return this.stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final DeviceSelectionConfig.Builder getDeviceSelectionConfig() {
            return this.deviceSelectionConfig != null ? this.deviceSelectionConfig.toBuilder() : null;
        }

        public final void setDeviceSelectionConfig(DeviceSelectionConfig.BuilderImpl deviceSelectionConfig) {
            this.deviceSelectionConfig = deviceSelectionConfig != null ? deviceSelectionConfig.build() : null;
        }

        @Override
        public final Builder deviceSelectionConfig(DeviceSelectionConfig deviceSelectionConfig) {
            this.deviceSelectionConfig = deviceSelectionConfig;
            return this;
        }

        public final EdgeDeploymentConfig.Builder getDeploymentConfig() {
            return this.deploymentConfig != null ? this.deploymentConfig.toBuilder() : null;
        }

        public final void setDeploymentConfig(EdgeDeploymentConfig.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        @Override
        public final Builder deploymentConfig(EdgeDeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        public DeploymentStage build() {
            return new DeploymentStage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentStage> {
        public Builder stageName(String var1);

        public Builder deviceSelectionConfig(DeviceSelectionConfig var1);

        default public Builder deviceSelectionConfig(Consumer<DeviceSelectionConfig.Builder> deviceSelectionConfig) {
            return this.deviceSelectionConfig((DeviceSelectionConfig)((DeviceSelectionConfig.Builder)DeviceSelectionConfig.builder().applyMutation(deviceSelectionConfig)).build());
        }

        public Builder deploymentConfig(EdgeDeploymentConfig var1);

        default public Builder deploymentConfig(Consumer<EdgeDeploymentConfig.Builder> deploymentConfig) {
            return this.deploymentConfig((EdgeDeploymentConfig)((EdgeDeploymentConfig.Builder)EdgeDeploymentConfig.builder().applyMutation(deploymentConfig)).build());
        }
    }
}

