/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobObjective;
import software.amazon.awssdk.services.sagemaker.model.AutoMLProblemTypeResolvedAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoMLResolvedAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoMLResolvedAttributes> {
    private static final SdkField<AutoMLJobObjective> AUTO_ML_JOB_OBJECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoMLJobObjective").getter(AutoMLResolvedAttributes.getter(AutoMLResolvedAttributes::autoMLJobObjective)).setter(AutoMLResolvedAttributes.setter(Builder::autoMLJobObjective)).constructor(AutoMLJobObjective::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobObjective").build()}).build();
    private static final SdkField<AutoMLJobCompletionCriteria> COMPLETION_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CompletionCriteria").getter(AutoMLResolvedAttributes.getter(AutoMLResolvedAttributes::completionCriteria)).setter(AutoMLResolvedAttributes.setter(Builder::completionCriteria)).constructor(AutoMLJobCompletionCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionCriteria").build()}).build();
    private static final SdkField<AutoMLProblemTypeResolvedAttributes> AUTO_ML_PROBLEM_TYPE_RESOLVED_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoMLProblemTypeResolvedAttributes").getter(AutoMLResolvedAttributes.getter(AutoMLResolvedAttributes::autoMLProblemTypeResolvedAttributes)).setter(AutoMLResolvedAttributes.setter(Builder::autoMLProblemTypeResolvedAttributes)).constructor(AutoMLProblemTypeResolvedAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLProblemTypeResolvedAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_OBJECTIVE_FIELD, COMPLETION_CRITERIA_FIELD, AUTO_ML_PROBLEM_TYPE_RESOLVED_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoMLResolvedAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AutoMLJobObjective autoMLJobObjective;
    private final AutoMLJobCompletionCriteria completionCriteria;
    private final AutoMLProblemTypeResolvedAttributes autoMLProblemTypeResolvedAttributes;

    private AutoMLResolvedAttributes(BuilderImpl builder) {
        this.autoMLJobObjective = builder.autoMLJobObjective;
        this.completionCriteria = builder.completionCriteria;
        this.autoMLProblemTypeResolvedAttributes = builder.autoMLProblemTypeResolvedAttributes;
    }

    public final AutoMLJobObjective autoMLJobObjective() {
        return this.autoMLJobObjective;
    }

    public final AutoMLJobCompletionCriteria completionCriteria() {
        return this.completionCriteria;
    }

    public final AutoMLProblemTypeResolvedAttributes autoMLProblemTypeResolvedAttributes() {
        return this.autoMLProblemTypeResolvedAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobObjective());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLProblemTypeResolvedAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLResolvedAttributes)) {
            return false;
        }
        AutoMLResolvedAttributes other = (AutoMLResolvedAttributes)obj;
        return Objects.equals(this.autoMLJobObjective(), other.autoMLJobObjective()) && Objects.equals(this.completionCriteria(), other.completionCriteria()) && Objects.equals(this.autoMLProblemTypeResolvedAttributes(), other.autoMLProblemTypeResolvedAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"AutoMLResolvedAttributes").add("AutoMLJobObjective", (Object)this.autoMLJobObjective()).add("CompletionCriteria", (Object)this.completionCriteria()).add("AutoMLProblemTypeResolvedAttributes", (Object)this.autoMLProblemTypeResolvedAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoMLJobObjective": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobObjective()));
            }
            case "CompletionCriteria": {
                return Optional.ofNullable(clazz.cast(this.completionCriteria()));
            }
            case "AutoMLProblemTypeResolvedAttributes": {
                return Optional.ofNullable(clazz.cast(this.autoMLProblemTypeResolvedAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AutoMLJobObjective", AUTO_ML_JOB_OBJECTIVE_FIELD);
        map.put("CompletionCriteria", COMPLETION_CRITERIA_FIELD);
        map.put("AutoMLProblemTypeResolvedAttributes", AUTO_ML_PROBLEM_TYPE_RESOLVED_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoMLResolvedAttributes, T> g) {
        return obj -> g.apply((AutoMLResolvedAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutoMLJobObjective autoMLJobObjective;
        private AutoMLJobCompletionCriteria completionCriteria;
        private AutoMLProblemTypeResolvedAttributes autoMLProblemTypeResolvedAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLResolvedAttributes model) {
            this.autoMLJobObjective(model.autoMLJobObjective);
            this.completionCriteria(model.completionCriteria);
            this.autoMLProblemTypeResolvedAttributes(model.autoMLProblemTypeResolvedAttributes);
        }

        public final AutoMLJobObjective.Builder getAutoMLJobObjective() {
            return this.autoMLJobObjective != null ? this.autoMLJobObjective.toBuilder() : null;
        }

        public final void setAutoMLJobObjective(AutoMLJobObjective.BuilderImpl autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective != null ? autoMLJobObjective.build() : null;
        }

        @Override
        public final Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective;
            return this;
        }

        public final AutoMLJobCompletionCriteria.Builder getCompletionCriteria() {
            return this.completionCriteria != null ? this.completionCriteria.toBuilder() : null;
        }

        public final void setCompletionCriteria(AutoMLJobCompletionCriteria.BuilderImpl completionCriteria) {
            this.completionCriteria = completionCriteria != null ? completionCriteria.build() : null;
        }

        @Override
        public final Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria) {
            this.completionCriteria = completionCriteria;
            return this;
        }

        public final AutoMLProblemTypeResolvedAttributes.Builder getAutoMLProblemTypeResolvedAttributes() {
            return this.autoMLProblemTypeResolvedAttributes != null ? this.autoMLProblemTypeResolvedAttributes.toBuilder() : null;
        }

        public final void setAutoMLProblemTypeResolvedAttributes(AutoMLProblemTypeResolvedAttributes.BuilderImpl autoMLProblemTypeResolvedAttributes) {
            this.autoMLProblemTypeResolvedAttributes = autoMLProblemTypeResolvedAttributes != null ? autoMLProblemTypeResolvedAttributes.build() : null;
        }

        @Override
        public final Builder autoMLProblemTypeResolvedAttributes(AutoMLProblemTypeResolvedAttributes autoMLProblemTypeResolvedAttributes) {
            this.autoMLProblemTypeResolvedAttributes = autoMLProblemTypeResolvedAttributes;
            return this;
        }

        public AutoMLResolvedAttributes build() {
            return new AutoMLResolvedAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoMLResolvedAttributes> {
        public Builder autoMLJobObjective(AutoMLJobObjective var1);

        default public Builder autoMLJobObjective(Consumer<AutoMLJobObjective.Builder> autoMLJobObjective) {
            return this.autoMLJobObjective((AutoMLJobObjective)((AutoMLJobObjective.Builder)AutoMLJobObjective.builder().applyMutation(autoMLJobObjective)).build());
        }

        public Builder completionCriteria(AutoMLJobCompletionCriteria var1);

        default public Builder completionCriteria(Consumer<AutoMLJobCompletionCriteria.Builder> completionCriteria) {
            return this.completionCriteria((AutoMLJobCompletionCriteria)((AutoMLJobCompletionCriteria.Builder)AutoMLJobCompletionCriteria.builder().applyMutation(completionCriteria)).build());
        }

        public Builder autoMLProblemTypeResolvedAttributes(AutoMLProblemTypeResolvedAttributes var1);

        default public Builder autoMLProblemTypeResolvedAttributes(Consumer<AutoMLProblemTypeResolvedAttributes.Builder> autoMLProblemTypeResolvedAttributes) {
            return this.autoMLProblemTypeResolvedAttributes((AutoMLProblemTypeResolvedAttributes)((AutoMLProblemTypeResolvedAttributes.Builder)AutoMLProblemTypeResolvedAttributes.builder().applyMutation(autoMLProblemTypeResolvedAttributes)).build());
        }
    }
}

