/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateGenerationConfig;
import software.amazon.awssdk.services.sagemaker.model.AutoMLDataSplitConfig;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria;
import software.amazon.awssdk.services.sagemaker.model.AutoMLMode;
import software.amazon.awssdk.services.sagemaker.model.AutoMLSecurityConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoMLJobConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoMLJobConfig> {
    private static final SdkField<AutoMLJobCompletionCriteria> COMPLETION_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CompletionCriteria").getter(AutoMLJobConfig.getter(AutoMLJobConfig::completionCriteria)).setter(AutoMLJobConfig.setter(Builder::completionCriteria)).constructor(AutoMLJobCompletionCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionCriteria").build()}).build();
    private static final SdkField<AutoMLSecurityConfig> SECURITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityConfig").getter(AutoMLJobConfig.getter(AutoMLJobConfig::securityConfig)).setter(AutoMLJobConfig.setter(Builder::securityConfig)).constructor(AutoMLSecurityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfig").build()}).build();
    private static final SdkField<AutoMLCandidateGenerationConfig> CANDIDATE_GENERATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CandidateGenerationConfig").getter(AutoMLJobConfig.getter(AutoMLJobConfig::candidateGenerationConfig)).setter(AutoMLJobConfig.setter(Builder::candidateGenerationConfig)).constructor(AutoMLCandidateGenerationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateGenerationConfig").build()}).build();
    private static final SdkField<AutoMLDataSplitConfig> DATA_SPLIT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSplitConfig").getter(AutoMLJobConfig.getter(AutoMLJobConfig::dataSplitConfig)).setter(AutoMLJobConfig.setter(Builder::dataSplitConfig)).constructor(AutoMLDataSplitConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSplitConfig").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(AutoMLJobConfig.getter(AutoMLJobConfig::modeAsString)).setter(AutoMLJobConfig.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_CRITERIA_FIELD, SECURITY_CONFIG_FIELD, CANDIDATE_GENERATION_CONFIG_FIELD, DATA_SPLIT_CONFIG_FIELD, MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoMLJobConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AutoMLJobCompletionCriteria completionCriteria;
    private final AutoMLSecurityConfig securityConfig;
    private final AutoMLCandidateGenerationConfig candidateGenerationConfig;
    private final AutoMLDataSplitConfig dataSplitConfig;
    private final String mode;

    private AutoMLJobConfig(BuilderImpl builder) {
        this.completionCriteria = builder.completionCriteria;
        this.securityConfig = builder.securityConfig;
        this.candidateGenerationConfig = builder.candidateGenerationConfig;
        this.dataSplitConfig = builder.dataSplitConfig;
        this.mode = builder.mode;
    }

    public final AutoMLJobCompletionCriteria completionCriteria() {
        return this.completionCriteria;
    }

    public final AutoMLSecurityConfig securityConfig() {
        return this.securityConfig;
    }

    public final AutoMLCandidateGenerationConfig candidateGenerationConfig() {
        return this.candidateGenerationConfig;
    }

    public final AutoMLDataSplitConfig dataSplitConfig() {
        return this.dataSplitConfig;
    }

    public final AutoMLMode mode() {
        return AutoMLMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.completionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.candidateGenerationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSplitConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLJobConfig)) {
            return false;
        }
        AutoMLJobConfig other = (AutoMLJobConfig)obj;
        return Objects.equals(this.completionCriteria(), other.completionCriteria()) && Objects.equals(this.securityConfig(), other.securityConfig()) && Objects.equals(this.candidateGenerationConfig(), other.candidateGenerationConfig()) && Objects.equals(this.dataSplitConfig(), other.dataSplitConfig()) && Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AutoMLJobConfig").add("CompletionCriteria", (Object)this.completionCriteria()).add("SecurityConfig", (Object)this.securityConfig()).add("CandidateGenerationConfig", (Object)this.candidateGenerationConfig()).add("DataSplitConfig", (Object)this.dataSplitConfig()).add("Mode", (Object)this.modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompletionCriteria": {
                return Optional.ofNullable(clazz.cast(this.completionCriteria()));
            }
            case "SecurityConfig": {
                return Optional.ofNullable(clazz.cast(this.securityConfig()));
            }
            case "CandidateGenerationConfig": {
                return Optional.ofNullable(clazz.cast(this.candidateGenerationConfig()));
            }
            case "DataSplitConfig": {
                return Optional.ofNullable(clazz.cast(this.dataSplitConfig()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CompletionCriteria", COMPLETION_CRITERIA_FIELD);
        map.put("SecurityConfig", SECURITY_CONFIG_FIELD);
        map.put("CandidateGenerationConfig", CANDIDATE_GENERATION_CONFIG_FIELD);
        map.put("DataSplitConfig", DATA_SPLIT_CONFIG_FIELD);
        map.put("Mode", MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoMLJobConfig, T> g) {
        return obj -> g.apply((AutoMLJobConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutoMLJobCompletionCriteria completionCriteria;
        private AutoMLSecurityConfig securityConfig;
        private AutoMLCandidateGenerationConfig candidateGenerationConfig;
        private AutoMLDataSplitConfig dataSplitConfig;
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLJobConfig model) {
            this.completionCriteria(model.completionCriteria);
            this.securityConfig(model.securityConfig);
            this.candidateGenerationConfig(model.candidateGenerationConfig);
            this.dataSplitConfig(model.dataSplitConfig);
            this.mode(model.mode);
        }

        public final AutoMLJobCompletionCriteria.Builder getCompletionCriteria() {
            return this.completionCriteria != null ? this.completionCriteria.toBuilder() : null;
        }

        public final void setCompletionCriteria(AutoMLJobCompletionCriteria.BuilderImpl completionCriteria) {
            this.completionCriteria = completionCriteria != null ? completionCriteria.build() : null;
        }

        @Override
        public final Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria) {
            this.completionCriteria = completionCriteria;
            return this;
        }

        public final AutoMLSecurityConfig.Builder getSecurityConfig() {
            return this.securityConfig != null ? this.securityConfig.toBuilder() : null;
        }

        public final void setSecurityConfig(AutoMLSecurityConfig.BuilderImpl securityConfig) {
            this.securityConfig = securityConfig != null ? securityConfig.build() : null;
        }

        @Override
        public final Builder securityConfig(AutoMLSecurityConfig securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        public final AutoMLCandidateGenerationConfig.Builder getCandidateGenerationConfig() {
            return this.candidateGenerationConfig != null ? this.candidateGenerationConfig.toBuilder() : null;
        }

        public final void setCandidateGenerationConfig(AutoMLCandidateGenerationConfig.BuilderImpl candidateGenerationConfig) {
            this.candidateGenerationConfig = candidateGenerationConfig != null ? candidateGenerationConfig.build() : null;
        }

        @Override
        public final Builder candidateGenerationConfig(AutoMLCandidateGenerationConfig candidateGenerationConfig) {
            this.candidateGenerationConfig = candidateGenerationConfig;
            return this;
        }

        public final AutoMLDataSplitConfig.Builder getDataSplitConfig() {
            return this.dataSplitConfig != null ? this.dataSplitConfig.toBuilder() : null;
        }

        public final void setDataSplitConfig(AutoMLDataSplitConfig.BuilderImpl dataSplitConfig) {
            this.dataSplitConfig = dataSplitConfig != null ? dataSplitConfig.build() : null;
        }

        @Override
        public final Builder dataSplitConfig(AutoMLDataSplitConfig dataSplitConfig) {
            this.dataSplitConfig = dataSplitConfig;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(AutoMLMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public AutoMLJobConfig build() {
            return new AutoMLJobConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoMLJobConfig> {
        public Builder completionCriteria(AutoMLJobCompletionCriteria var1);

        default public Builder completionCriteria(Consumer<AutoMLJobCompletionCriteria.Builder> completionCriteria) {
            return this.completionCriteria((AutoMLJobCompletionCriteria)((AutoMLJobCompletionCriteria.Builder)AutoMLJobCompletionCriteria.builder().applyMutation(completionCriteria)).build());
        }

        public Builder securityConfig(AutoMLSecurityConfig var1);

        default public Builder securityConfig(Consumer<AutoMLSecurityConfig.Builder> securityConfig) {
            return this.securityConfig((AutoMLSecurityConfig)((AutoMLSecurityConfig.Builder)AutoMLSecurityConfig.builder().applyMutation(securityConfig)).build());
        }

        public Builder candidateGenerationConfig(AutoMLCandidateGenerationConfig var1);

        default public Builder candidateGenerationConfig(Consumer<AutoMLCandidateGenerationConfig.Builder> candidateGenerationConfig) {
            return this.candidateGenerationConfig((AutoMLCandidateGenerationConfig)((AutoMLCandidateGenerationConfig.Builder)AutoMLCandidateGenerationConfig.builder().applyMutation(candidateGenerationConfig)).build());
        }

        public Builder dataSplitConfig(AutoMLDataSplitConfig var1);

        default public Builder dataSplitConfig(Consumer<AutoMLDataSplitConfig.Builder> dataSplitConfig) {
            return this.dataSplitConfig((AutoMLDataSplitConfig)((AutoMLDataSplitConfig.Builder)AutoMLDataSplitConfig.builder().applyMutation(dataSplitConfig)).build());
        }

        public Builder mode(String var1);

        public Builder mode(AutoMLMode var1);
    }
}

