/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AssociationEdgeType;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociationSummary> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(AssociationSummary.getter(AssociationSummary::sourceArn)).setter(AssociationSummary.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationArn").getter(AssociationSummary.getter(AssociationSummary::destinationArn)).setter(AssociationSummary.setter(Builder::destinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationArn").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(AssociationSummary.getter(AssociationSummary::sourceType)).setter(AssociationSummary.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationType").getter(AssociationSummary.getter(AssociationSummary::destinationType)).setter(AssociationSummary.setter(Builder::destinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationType").build()}).build();
    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationType").getter(AssociationSummary.getter(AssociationSummary::associationTypeAsString)).setter(AssociationSummary.setter(Builder::associationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationType").build()}).build();
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceName").getter(AssociationSummary.getter(AssociationSummary::sourceName)).setter(AssociationSummary.setter(Builder::sourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceName").build()}).build();
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationName").getter(AssociationSummary.getter(AssociationSummary::destinationName)).setter(AssociationSummary.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(AssociationSummary.getter(AssociationSummary::creationTime)).setter(AssociationSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(AssociationSummary.getter(AssociationSummary::createdBy)).setter(AssociationSummary.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD, DESTINATION_ARN_FIELD, SOURCE_TYPE_FIELD, DESTINATION_TYPE_FIELD, ASSOCIATION_TYPE_FIELD, SOURCE_NAME_FIELD, DESTINATION_NAME_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceArn;
    private final String destinationArn;
    private final String sourceType;
    private final String destinationType;
    private final String associationType;
    private final String sourceName;
    private final String destinationName;
    private final Instant creationTime;
    private final UserContext createdBy;

    private AssociationSummary(BuilderImpl builder) {
        this.sourceArn = builder.sourceArn;
        this.destinationArn = builder.destinationArn;
        this.sourceType = builder.sourceType;
        this.destinationType = builder.destinationType;
        this.associationType = builder.associationType;
        this.sourceName = builder.sourceName;
        this.destinationName = builder.destinationName;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final String destinationArn() {
        return this.destinationArn;
    }

    public final String sourceType() {
        return this.sourceType;
    }

    public final String destinationType() {
        return this.destinationType;
    }

    public final AssociationEdgeType associationType() {
        return AssociationEdgeType.fromValue(this.associationType);
    }

    public final String associationTypeAsString() {
        return this.associationType;
    }

    public final String sourceName() {
        return this.sourceName;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final UserContext createdBy() {
        return this.createdBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationSummary)) {
            return false;
        }
        AssociationSummary other = (AssociationSummary)obj;
        return Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.destinationArn(), other.destinationArn()) && Objects.equals(this.sourceType(), other.sourceType()) && Objects.equals(this.destinationType(), other.destinationType()) && Objects.equals(this.associationTypeAsString(), other.associationTypeAsString()) && Objects.equals(this.sourceName(), other.sourceName()) && Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.createdBy(), other.createdBy());
    }

    public final String toString() {
        return ToString.builder((String)"AssociationSummary").add("SourceArn", (Object)this.sourceArn()).add("DestinationArn", (Object)this.destinationArn()).add("SourceType", (Object)this.sourceType()).add("DestinationType", (Object)this.destinationType()).add("AssociationType", (Object)this.associationTypeAsString()).add("SourceName", (Object)this.sourceName()).add("DestinationName", (Object)this.destinationName()).add("CreationTime", (Object)this.creationTime()).add("CreatedBy", (Object)this.createdBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "DestinationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationArn()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceType()));
            }
            case "DestinationType": {
                return Optional.ofNullable(clazz.cast(this.destinationType()));
            }
            case "AssociationType": {
                return Optional.ofNullable(clazz.cast(this.associationTypeAsString()));
            }
            case "SourceName": {
                return Optional.ofNullable(clazz.cast(this.sourceName()));
            }
            case "DestinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceArn", SOURCE_ARN_FIELD);
        map.put("DestinationArn", DESTINATION_ARN_FIELD);
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("DestinationType", DESTINATION_TYPE_FIELD);
        map.put("AssociationType", ASSOCIATION_TYPE_FIELD);
        map.put("SourceName", SOURCE_NAME_FIELD);
        map.put("DestinationName", DESTINATION_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociationSummary, T> g) {
        return obj -> g.apply((AssociationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceArn;
        private String destinationArn;
        private String sourceType;
        private String destinationType;
        private String associationType;
        private String sourceName;
        private String destinationName;
        private Instant creationTime;
        private UserContext createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationSummary model) {
            this.sourceArn(model.sourceArn);
            this.destinationArn(model.destinationArn);
            this.sourceType(model.sourceType);
            this.destinationType(model.destinationType);
            this.associationType(model.associationType);
            this.sourceName(model.sourceName);
            this.destinationName(model.destinationName);
            this.creationTime(model.creationTime);
            this.createdBy(model.createdBy);
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getDestinationArn() {
            return this.destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final String getDestinationType() {
            return this.destinationType;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        public final String getAssociationType() {
            return this.associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(AssociationEdgeType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public final String getSourceName() {
            return this.sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public AssociationSummary build() {
            return new AssociationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociationSummary> {
        public Builder sourceArn(String var1);

        public Builder destinationArn(String var1);

        public Builder sourceType(String var1);

        public Builder destinationType(String var1);

        public Builder associationType(String var1);

        public Builder associationType(AssociationEdgeType var1);

        public Builder sourceName(String var1);

        public Builder destinationName(String var1);

        public Builder creationTime(Instant var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }
    }
}

