/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjective;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyConfig;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType;
import software.amazon.awssdk.services.sagemaker.model.ParameterRanges;
import software.amazon.awssdk.services.sagemaker.model.ResourceLimits;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobEarlyStoppingType;
import software.amazon.awssdk.services.sagemaker.model.TuningJobCompletionCriteria;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HyperParameterTuningJobConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HyperParameterTuningJobConfig> {
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Strategy").getter(HyperParameterTuningJobConfig.getter(HyperParameterTuningJobConfig::strategyAsString)).setter(HyperParameterTuningJobConfig.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy").build()}).build();
    private static final SdkField<HyperParameterTuningJobStrategyConfig> STRATEGY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StrategyConfig").getter(HyperParameterTuningJobConfig.getter(HyperParameterTuningJobConfig::strategyConfig)).setter(HyperParameterTuningJobConfig.setter(Builder::strategyConfig)).constructor(HyperParameterTuningJobStrategyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrategyConfig").build()}).build();
    private static final SdkField<HyperParameterTuningJobObjective> HYPER_PARAMETER_TUNING_JOB_OBJECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HyperParameterTuningJobObjective").getter(HyperParameterTuningJobConfig.getter(HyperParameterTuningJobConfig::hyperParameterTuningJobObjective)).setter(HyperParameterTuningJobConfig.setter(Builder::hyperParameterTuningJobObjective)).constructor(HyperParameterTuningJobObjective::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobObjective").build()}).build();
    private static final SdkField<ResourceLimits> RESOURCE_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceLimits").getter(HyperParameterTuningJobConfig.getter(HyperParameterTuningJobConfig::resourceLimits)).setter(HyperParameterTuningJobConfig.setter(Builder::resourceLimits)).constructor(ResourceLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLimits").build()}).build();
    private static final SdkField<ParameterRanges> PARAMETER_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParameterRanges").getter(HyperParameterTuningJobConfig.getter(HyperParameterTuningJobConfig::parameterRanges)).setter(HyperParameterTuningJobConfig.setter(Builder::parameterRanges)).constructor(ParameterRanges::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterRanges").build()}).build();
    private static final SdkField<String> TRAINING_JOB_EARLY_STOPPING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingJobEarlyStoppingType").getter(HyperParameterTuningJobConfig.getter(HyperParameterTuningJobConfig::trainingJobEarlyStoppingTypeAsString)).setter(HyperParameterTuningJobConfig.setter(Builder::trainingJobEarlyStoppingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobEarlyStoppingType").build()}).build();
    private static final SdkField<TuningJobCompletionCriteria> TUNING_JOB_COMPLETION_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TuningJobCompletionCriteria").getter(HyperParameterTuningJobConfig.getter(HyperParameterTuningJobConfig::tuningJobCompletionCriteria)).setter(HyperParameterTuningJobConfig.setter(Builder::tuningJobCompletionCriteria)).constructor(TuningJobCompletionCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TuningJobCompletionCriteria").build()}).build();
    private static final SdkField<Integer> RANDOM_SEED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RandomSeed").getter(HyperParameterTuningJobConfig.getter(HyperParameterTuningJobConfig::randomSeed)).setter(HyperParameterTuningJobConfig.setter(Builder::randomSeed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RandomSeed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRATEGY_FIELD, STRATEGY_CONFIG_FIELD, HYPER_PARAMETER_TUNING_JOB_OBJECTIVE_FIELD, RESOURCE_LIMITS_FIELD, PARAMETER_RANGES_FIELD, TRAINING_JOB_EARLY_STOPPING_TYPE_FIELD, TUNING_JOB_COMPLETION_CRITERIA_FIELD, RANDOM_SEED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HyperParameterTuningJobConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String strategy;
    private final HyperParameterTuningJobStrategyConfig strategyConfig;
    private final HyperParameterTuningJobObjective hyperParameterTuningJobObjective;
    private final ResourceLimits resourceLimits;
    private final ParameterRanges parameterRanges;
    private final String trainingJobEarlyStoppingType;
    private final TuningJobCompletionCriteria tuningJobCompletionCriteria;
    private final Integer randomSeed;

    private HyperParameterTuningJobConfig(BuilderImpl builder) {
        this.strategy = builder.strategy;
        this.strategyConfig = builder.strategyConfig;
        this.hyperParameterTuningJobObjective = builder.hyperParameterTuningJobObjective;
        this.resourceLimits = builder.resourceLimits;
        this.parameterRanges = builder.parameterRanges;
        this.trainingJobEarlyStoppingType = builder.trainingJobEarlyStoppingType;
        this.tuningJobCompletionCriteria = builder.tuningJobCompletionCriteria;
        this.randomSeed = builder.randomSeed;
    }

    public final HyperParameterTuningJobStrategyType strategy() {
        return HyperParameterTuningJobStrategyType.fromValue(this.strategy);
    }

    public final String strategyAsString() {
        return this.strategy;
    }

    public final HyperParameterTuningJobStrategyConfig strategyConfig() {
        return this.strategyConfig;
    }

    public final HyperParameterTuningJobObjective hyperParameterTuningJobObjective() {
        return this.hyperParameterTuningJobObjective;
    }

    public final ResourceLimits resourceLimits() {
        return this.resourceLimits;
    }

    public final ParameterRanges parameterRanges() {
        return this.parameterRanges;
    }

    public final TrainingJobEarlyStoppingType trainingJobEarlyStoppingType() {
        return TrainingJobEarlyStoppingType.fromValue(this.trainingJobEarlyStoppingType);
    }

    public final String trainingJobEarlyStoppingTypeAsString() {
        return this.trainingJobEarlyStoppingType;
    }

    public final TuningJobCompletionCriteria tuningJobCompletionCriteria() {
        return this.tuningJobCompletionCriteria;
    }

    public final Integer randomSeed() {
        return this.randomSeed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobObjective());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceLimits());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterRanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobEarlyStoppingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tuningJobCompletionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.randomSeed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTuningJobConfig)) {
            return false;
        }
        HyperParameterTuningJobConfig other = (HyperParameterTuningJobConfig)obj;
        return Objects.equals(this.strategyAsString(), other.strategyAsString()) && Objects.equals(this.strategyConfig(), other.strategyConfig()) && Objects.equals(this.hyperParameterTuningJobObjective(), other.hyperParameterTuningJobObjective()) && Objects.equals(this.resourceLimits(), other.resourceLimits()) && Objects.equals(this.parameterRanges(), other.parameterRanges()) && Objects.equals(this.trainingJobEarlyStoppingTypeAsString(), other.trainingJobEarlyStoppingTypeAsString()) && Objects.equals(this.tuningJobCompletionCriteria(), other.tuningJobCompletionCriteria()) && Objects.equals(this.randomSeed(), other.randomSeed());
    }

    public final String toString() {
        return ToString.builder((String)"HyperParameterTuningJobConfig").add("Strategy", (Object)this.strategyAsString()).add("StrategyConfig", (Object)this.strategyConfig()).add("HyperParameterTuningJobObjective", (Object)this.hyperParameterTuningJobObjective()).add("ResourceLimits", (Object)this.resourceLimits()).add("ParameterRanges", (Object)this.parameterRanges()).add("TrainingJobEarlyStoppingType", (Object)this.trainingJobEarlyStoppingTypeAsString()).add("TuningJobCompletionCriteria", (Object)this.tuningJobCompletionCriteria()).add("RandomSeed", (Object)this.randomSeed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
            case "StrategyConfig": {
                return Optional.ofNullable(clazz.cast(this.strategyConfig()));
            }
            case "HyperParameterTuningJobObjective": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobObjective()));
            }
            case "ResourceLimits": {
                return Optional.ofNullable(clazz.cast(this.resourceLimits()));
            }
            case "ParameterRanges": {
                return Optional.ofNullable(clazz.cast(this.parameterRanges()));
            }
            case "TrainingJobEarlyStoppingType": {
                return Optional.ofNullable(clazz.cast(this.trainingJobEarlyStoppingTypeAsString()));
            }
            case "TuningJobCompletionCriteria": {
                return Optional.ofNullable(clazz.cast(this.tuningJobCompletionCriteria()));
            }
            case "RandomSeed": {
                return Optional.ofNullable(clazz.cast(this.randomSeed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Strategy", STRATEGY_FIELD);
        map.put("StrategyConfig", STRATEGY_CONFIG_FIELD);
        map.put("HyperParameterTuningJobObjective", HYPER_PARAMETER_TUNING_JOB_OBJECTIVE_FIELD);
        map.put("ResourceLimits", RESOURCE_LIMITS_FIELD);
        map.put("ParameterRanges", PARAMETER_RANGES_FIELD);
        map.put("TrainingJobEarlyStoppingType", TRAINING_JOB_EARLY_STOPPING_TYPE_FIELD);
        map.put("TuningJobCompletionCriteria", TUNING_JOB_COMPLETION_CRITERIA_FIELD);
        map.put("RandomSeed", RANDOM_SEED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterTuningJobConfig, T> g) {
        return obj -> g.apply((HyperParameterTuningJobConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String strategy;
        private HyperParameterTuningJobStrategyConfig strategyConfig;
        private HyperParameterTuningJobObjective hyperParameterTuningJobObjective;
        private ResourceLimits resourceLimits;
        private ParameterRanges parameterRanges;
        private String trainingJobEarlyStoppingType;
        private TuningJobCompletionCriteria tuningJobCompletionCriteria;
        private Integer randomSeed;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTuningJobConfig model) {
            this.strategy(model.strategy);
            this.strategyConfig(model.strategyConfig);
            this.hyperParameterTuningJobObjective(model.hyperParameterTuningJobObjective);
            this.resourceLimits(model.resourceLimits);
            this.parameterRanges(model.parameterRanges);
            this.trainingJobEarlyStoppingType(model.trainingJobEarlyStoppingType);
            this.tuningJobCompletionCriteria(model.tuningJobCompletionCriteria);
            this.randomSeed(model.randomSeed);
        }

        public final String getStrategy() {
            return this.strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(HyperParameterTuningJobStrategyType strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final HyperParameterTuningJobStrategyConfig.Builder getStrategyConfig() {
            return this.strategyConfig != null ? this.strategyConfig.toBuilder() : null;
        }

        public final void setStrategyConfig(HyperParameterTuningJobStrategyConfig.BuilderImpl strategyConfig) {
            this.strategyConfig = strategyConfig != null ? strategyConfig.build() : null;
        }

        @Override
        public final Builder strategyConfig(HyperParameterTuningJobStrategyConfig strategyConfig) {
            this.strategyConfig = strategyConfig;
            return this;
        }

        public final HyperParameterTuningJobObjective.Builder getHyperParameterTuningJobObjective() {
            return this.hyperParameterTuningJobObjective != null ? this.hyperParameterTuningJobObjective.toBuilder() : null;
        }

        public final void setHyperParameterTuningJobObjective(HyperParameterTuningJobObjective.BuilderImpl hyperParameterTuningJobObjective) {
            this.hyperParameterTuningJobObjective = hyperParameterTuningJobObjective != null ? hyperParameterTuningJobObjective.build() : null;
        }

        @Override
        public final Builder hyperParameterTuningJobObjective(HyperParameterTuningJobObjective hyperParameterTuningJobObjective) {
            this.hyperParameterTuningJobObjective = hyperParameterTuningJobObjective;
            return this;
        }

        public final ResourceLimits.Builder getResourceLimits() {
            return this.resourceLimits != null ? this.resourceLimits.toBuilder() : null;
        }

        public final void setResourceLimits(ResourceLimits.BuilderImpl resourceLimits) {
            this.resourceLimits = resourceLimits != null ? resourceLimits.build() : null;
        }

        @Override
        public final Builder resourceLimits(ResourceLimits resourceLimits) {
            this.resourceLimits = resourceLimits;
            return this;
        }

        public final ParameterRanges.Builder getParameterRanges() {
            return this.parameterRanges != null ? this.parameterRanges.toBuilder() : null;
        }

        public final void setParameterRanges(ParameterRanges.BuilderImpl parameterRanges) {
            this.parameterRanges = parameterRanges != null ? parameterRanges.build() : null;
        }

        @Override
        public final Builder parameterRanges(ParameterRanges parameterRanges) {
            this.parameterRanges = parameterRanges;
            return this;
        }

        public final String getTrainingJobEarlyStoppingType() {
            return this.trainingJobEarlyStoppingType;
        }

        public final void setTrainingJobEarlyStoppingType(String trainingJobEarlyStoppingType) {
            this.trainingJobEarlyStoppingType = trainingJobEarlyStoppingType;
        }

        @Override
        public final Builder trainingJobEarlyStoppingType(String trainingJobEarlyStoppingType) {
            this.trainingJobEarlyStoppingType = trainingJobEarlyStoppingType;
            return this;
        }

        @Override
        public final Builder trainingJobEarlyStoppingType(TrainingJobEarlyStoppingType trainingJobEarlyStoppingType) {
            this.trainingJobEarlyStoppingType(trainingJobEarlyStoppingType == null ? null : trainingJobEarlyStoppingType.toString());
            return this;
        }

        public final TuningJobCompletionCriteria.Builder getTuningJobCompletionCriteria() {
            return this.tuningJobCompletionCriteria != null ? this.tuningJobCompletionCriteria.toBuilder() : null;
        }

        public final void setTuningJobCompletionCriteria(TuningJobCompletionCriteria.BuilderImpl tuningJobCompletionCriteria) {
            this.tuningJobCompletionCriteria = tuningJobCompletionCriteria != null ? tuningJobCompletionCriteria.build() : null;
        }

        @Override
        public final Builder tuningJobCompletionCriteria(TuningJobCompletionCriteria tuningJobCompletionCriteria) {
            this.tuningJobCompletionCriteria = tuningJobCompletionCriteria;
            return this;
        }

        public final Integer getRandomSeed() {
            return this.randomSeed;
        }

        public final void setRandomSeed(Integer randomSeed) {
            this.randomSeed = randomSeed;
        }

        @Override
        public final Builder randomSeed(Integer randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public HyperParameterTuningJobConfig build() {
            return new HyperParameterTuningJobConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HyperParameterTuningJobConfig> {
        public Builder strategy(String var1);

        public Builder strategy(HyperParameterTuningJobStrategyType var1);

        public Builder strategyConfig(HyperParameterTuningJobStrategyConfig var1);

        default public Builder strategyConfig(Consumer<HyperParameterTuningJobStrategyConfig.Builder> strategyConfig) {
            return this.strategyConfig((HyperParameterTuningJobStrategyConfig)((HyperParameterTuningJobStrategyConfig.Builder)HyperParameterTuningJobStrategyConfig.builder().applyMutation(strategyConfig)).build());
        }

        public Builder hyperParameterTuningJobObjective(HyperParameterTuningJobObjective var1);

        default public Builder hyperParameterTuningJobObjective(Consumer<HyperParameterTuningJobObjective.Builder> hyperParameterTuningJobObjective) {
            return this.hyperParameterTuningJobObjective((HyperParameterTuningJobObjective)((HyperParameterTuningJobObjective.Builder)HyperParameterTuningJobObjective.builder().applyMutation(hyperParameterTuningJobObjective)).build());
        }

        public Builder resourceLimits(ResourceLimits var1);

        default public Builder resourceLimits(Consumer<ResourceLimits.Builder> resourceLimits) {
            return this.resourceLimits((ResourceLimits)((ResourceLimits.Builder)ResourceLimits.builder().applyMutation(resourceLimits)).build());
        }

        public Builder parameterRanges(ParameterRanges var1);

        default public Builder parameterRanges(Consumer<ParameterRanges.Builder> parameterRanges) {
            return this.parameterRanges((ParameterRanges)((ParameterRanges.Builder)ParameterRanges.builder().applyMutation(parameterRanges)).build());
        }

        public Builder trainingJobEarlyStoppingType(String var1);

        public Builder trainingJobEarlyStoppingType(TrainingJobEarlyStoppingType var1);

        public Builder tuningJobCompletionCriteria(TuningJobCompletionCriteria var1);

        default public Builder tuningJobCompletionCriteria(Consumer<TuningJobCompletionCriteria.Builder> tuningJobCompletionCriteria) {
            return this.tuningJobCompletionCriteria((TuningJobCompletionCriteria)((TuningJobCompletionCriteria.Builder)TuningJobCompletionCriteria.builder().applyMutation(tuningJobCompletionCriteria)).build());
        }

        public Builder randomSeed(Integer var1);
    }
}

