/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HubS3StorageConfig;
import software.amazon.awssdk.services.sagemaker.model.HubSearchKeywordListCopier;
import software.amazon.awssdk.services.sagemaker.model.HubStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHubResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeHubResponse> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubName").getter(DescribeHubResponse.getter(DescribeHubResponse::hubName)).setter(DescribeHubResponse.setter(Builder::hubName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()}).build();
    private static final SdkField<String> HUB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubArn").getter(DescribeHubResponse.getter(DescribeHubResponse::hubArn)).setter(DescribeHubResponse.setter(Builder::hubArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubArn").build()}).build();
    private static final SdkField<String> HUB_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubDisplayName").getter(DescribeHubResponse.getter(DescribeHubResponse::hubDisplayName)).setter(DescribeHubResponse.setter(Builder::hubDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDisplayName").build()}).build();
    private static final SdkField<String> HUB_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubDescription").getter(DescribeHubResponse.getter(DescribeHubResponse::hubDescription)).setter(DescribeHubResponse.setter(Builder::hubDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDescription").build()}).build();
    private static final SdkField<List<String>> HUB_SEARCH_KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HubSearchKeywords").getter(DescribeHubResponse.getter(DescribeHubResponse::hubSearchKeywords)).setter(DescribeHubResponse.setter(Builder::hubSearchKeywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubSearchKeywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HubS3StorageConfig> S3_STORAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3StorageConfig").getter(DescribeHubResponse.getter(DescribeHubResponse::s3StorageConfig)).setter(DescribeHubResponse.setter(Builder::s3StorageConfig)).constructor(HubS3StorageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3StorageConfig").build()}).build();
    private static final SdkField<String> HUB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubStatus").getter(DescribeHubResponse.getter(DescribeHubResponse::hubStatusAsString)).setter(DescribeHubResponse.setter(Builder::hubStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeHubResponse.getter(DescribeHubResponse::failureReason)).setter(DescribeHubResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeHubResponse.getter(DescribeHubResponse::creationTime)).setter(DescribeHubResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeHubResponse.getter(DescribeHubResponse::lastModifiedTime)).setter(DescribeHubResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD, HUB_ARN_FIELD, HUB_DISPLAY_NAME_FIELD, HUB_DESCRIPTION_FIELD, HUB_SEARCH_KEYWORDS_FIELD, S3_STORAGE_CONFIG_FIELD, HUB_STATUS_FIELD, FAILURE_REASON_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeHubResponse.memberNameToFieldInitializer();
    private final String hubName;
    private final String hubArn;
    private final String hubDisplayName;
    private final String hubDescription;
    private final List<String> hubSearchKeywords;
    private final HubS3StorageConfig s3StorageConfig;
    private final String hubStatus;
    private final String failureReason;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private DescribeHubResponse(BuilderImpl builder) {
        super(builder);
        this.hubName = builder.hubName;
        this.hubArn = builder.hubArn;
        this.hubDisplayName = builder.hubDisplayName;
        this.hubDescription = builder.hubDescription;
        this.hubSearchKeywords = builder.hubSearchKeywords;
        this.s3StorageConfig = builder.s3StorageConfig;
        this.hubStatus = builder.hubStatus;
        this.failureReason = builder.failureReason;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String hubName() {
        return this.hubName;
    }

    public final String hubArn() {
        return this.hubArn;
    }

    public final String hubDisplayName() {
        return this.hubDisplayName;
    }

    public final String hubDescription() {
        return this.hubDescription;
    }

    public final boolean hasHubSearchKeywords() {
        return this.hubSearchKeywords != null && !(this.hubSearchKeywords instanceof SdkAutoConstructList);
    }

    public final List<String> hubSearchKeywords() {
        return this.hubSearchKeywords;
    }

    public final HubS3StorageConfig s3StorageConfig() {
        return this.s3StorageConfig;
    }

    public final HubStatus hubStatus() {
        return HubStatus.fromValue(this.hubStatus);
    }

    public final String hubStatusAsString() {
        return this.hubStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hubName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHubSearchKeywords() ? this.hubSearchKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.s3StorageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHubResponse)) {
            return false;
        }
        DescribeHubResponse other = (DescribeHubResponse)((Object)obj);
        return Objects.equals(this.hubName(), other.hubName()) && Objects.equals(this.hubArn(), other.hubArn()) && Objects.equals(this.hubDisplayName(), other.hubDisplayName()) && Objects.equals(this.hubDescription(), other.hubDescription()) && this.hasHubSearchKeywords() == other.hasHubSearchKeywords() && Objects.equals(this.hubSearchKeywords(), other.hubSearchKeywords()) && Objects.equals(this.s3StorageConfig(), other.s3StorageConfig()) && Objects.equals(this.hubStatusAsString(), other.hubStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeHubResponse").add("HubName", (Object)this.hubName()).add("HubArn", (Object)this.hubArn()).add("HubDisplayName", (Object)this.hubDisplayName()).add("HubDescription", (Object)this.hubDescription()).add("HubSearchKeywords", this.hasHubSearchKeywords() ? this.hubSearchKeywords() : null).add("S3StorageConfig", (Object)this.s3StorageConfig()).add("HubStatus", (Object)this.hubStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubName": {
                return Optional.ofNullable(clazz.cast(this.hubName()));
            }
            case "HubArn": {
                return Optional.ofNullable(clazz.cast(this.hubArn()));
            }
            case "HubDisplayName": {
                return Optional.ofNullable(clazz.cast(this.hubDisplayName()));
            }
            case "HubDescription": {
                return Optional.ofNullable(clazz.cast(this.hubDescription()));
            }
            case "HubSearchKeywords": {
                return Optional.ofNullable(clazz.cast(this.hubSearchKeywords()));
            }
            case "S3StorageConfig": {
                return Optional.ofNullable(clazz.cast(this.s3StorageConfig()));
            }
            case "HubStatus": {
                return Optional.ofNullable(clazz.cast(this.hubStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HubName", HUB_NAME_FIELD);
        map.put("HubArn", HUB_ARN_FIELD);
        map.put("HubDisplayName", HUB_DISPLAY_NAME_FIELD);
        map.put("HubDescription", HUB_DESCRIPTION_FIELD);
        map.put("HubSearchKeywords", HUB_SEARCH_KEYWORDS_FIELD);
        map.put("S3StorageConfig", S3_STORAGE_CONFIG_FIELD);
        map.put("HubStatus", HUB_STATUS_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHubResponse, T> g) {
        return obj -> g.apply((DescribeHubResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String hubName;
        private String hubArn;
        private String hubDisplayName;
        private String hubDescription;
        private List<String> hubSearchKeywords = DefaultSdkAutoConstructList.getInstance();
        private HubS3StorageConfig s3StorageConfig;
        private String hubStatus;
        private String failureReason;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHubResponse model) {
            super(model);
            this.hubName(model.hubName);
            this.hubArn(model.hubArn);
            this.hubDisplayName(model.hubDisplayName);
            this.hubDescription(model.hubDescription);
            this.hubSearchKeywords(model.hubSearchKeywords);
            this.s3StorageConfig(model.s3StorageConfig);
            this.hubStatus(model.hubStatus);
            this.failureReason(model.failureReason);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getHubName() {
            return this.hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubArn() {
            return this.hubArn;
        }

        public final void setHubArn(String hubArn) {
            this.hubArn = hubArn;
        }

        @Override
        public final Builder hubArn(String hubArn) {
            this.hubArn = hubArn;
            return this;
        }

        public final String getHubDisplayName() {
            return this.hubDisplayName;
        }

        public final void setHubDisplayName(String hubDisplayName) {
            this.hubDisplayName = hubDisplayName;
        }

        @Override
        public final Builder hubDisplayName(String hubDisplayName) {
            this.hubDisplayName = hubDisplayName;
            return this;
        }

        public final String getHubDescription() {
            return this.hubDescription;
        }

        public final void setHubDescription(String hubDescription) {
            this.hubDescription = hubDescription;
        }

        @Override
        public final Builder hubDescription(String hubDescription) {
            this.hubDescription = hubDescription;
            return this;
        }

        public final Collection<String> getHubSearchKeywords() {
            if (this.hubSearchKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hubSearchKeywords;
        }

        public final void setHubSearchKeywords(Collection<String> hubSearchKeywords) {
            this.hubSearchKeywords = HubSearchKeywordListCopier.copy(hubSearchKeywords);
        }

        @Override
        public final Builder hubSearchKeywords(Collection<String> hubSearchKeywords) {
            this.hubSearchKeywords = HubSearchKeywordListCopier.copy(hubSearchKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubSearchKeywords(String ... hubSearchKeywords) {
            this.hubSearchKeywords(Arrays.asList(hubSearchKeywords));
            return this;
        }

        public final HubS3StorageConfig.Builder getS3StorageConfig() {
            return this.s3StorageConfig != null ? this.s3StorageConfig.toBuilder() : null;
        }

        public final void setS3StorageConfig(HubS3StorageConfig.BuilderImpl s3StorageConfig) {
            this.s3StorageConfig = s3StorageConfig != null ? s3StorageConfig.build() : null;
        }

        @Override
        public final Builder s3StorageConfig(HubS3StorageConfig s3StorageConfig) {
            this.s3StorageConfig = s3StorageConfig;
            return this;
        }

        public final String getHubStatus() {
            return this.hubStatus;
        }

        public final void setHubStatus(String hubStatus) {
            this.hubStatus = hubStatus;
        }

        @Override
        public final Builder hubStatus(String hubStatus) {
            this.hubStatus = hubStatus;
            return this;
        }

        @Override
        public final Builder hubStatus(HubStatus hubStatus) {
            this.hubStatus(hubStatus == null ? null : hubStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public DescribeHubResponse build() {
            return new DescribeHubResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHubResponse> {
        public Builder hubName(String var1);

        public Builder hubArn(String var1);

        public Builder hubDisplayName(String var1);

        public Builder hubDescription(String var1);

        public Builder hubSearchKeywords(Collection<String> var1);

        public Builder hubSearchKeywords(String ... var1);

        public Builder s3StorageConfig(HubS3StorageConfig var1);

        default public Builder s3StorageConfig(Consumer<HubS3StorageConfig.Builder> s3StorageConfig) {
            return this.s3StorageConfig((HubS3StorageConfig)((HubS3StorageConfig.Builder)HubS3StorageConfig.builder().applyMutation(s3StorageConfig)).build());
        }

        public Builder hubStatus(String var1);

        public Builder hubStatus(HubStatus var1);

        public Builder failureReason(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

