/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmStatus;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmStatusDetails;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmValidationSpecification;
import software.amazon.awssdk.services.sagemaker.model.InferenceSpecification;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.TrainingSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAlgorithmResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeAlgorithmResponse> {
    private static final SdkField<String> ALGORITHM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmName").getter(DescribeAlgorithmResponse.getter(DescribeAlgorithmResponse::algorithmName)).setter(DescribeAlgorithmResponse.setter(Builder::algorithmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmName").build()}).build();
    private static final SdkField<String> ALGORITHM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmArn").getter(DescribeAlgorithmResponse.getter(DescribeAlgorithmResponse::algorithmArn)).setter(DescribeAlgorithmResponse.setter(Builder::algorithmArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmArn").build()}).build();
    private static final SdkField<String> ALGORITHM_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmDescription").getter(DescribeAlgorithmResponse.getter(DescribeAlgorithmResponse::algorithmDescription)).setter(DescribeAlgorithmResponse.setter(Builder::algorithmDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmDescription").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeAlgorithmResponse.getter(DescribeAlgorithmResponse::creationTime)).setter(DescribeAlgorithmResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<TrainingSpecification> TRAINING_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrainingSpecification").getter(DescribeAlgorithmResponse.getter(DescribeAlgorithmResponse::trainingSpecification)).setter(DescribeAlgorithmResponse.setter(Builder::trainingSpecification)).constructor(TrainingSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingSpecification").build()}).build();
    private static final SdkField<InferenceSpecification> INFERENCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InferenceSpecification").getter(DescribeAlgorithmResponse.getter(DescribeAlgorithmResponse::inferenceSpecification)).setter(DescribeAlgorithmResponse.setter(Builder::inferenceSpecification)).constructor(InferenceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecification").build()}).build();
    private static final SdkField<AlgorithmValidationSpecification> VALIDATION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValidationSpecification").getter(DescribeAlgorithmResponse.getter(DescribeAlgorithmResponse::validationSpecification)).setter(DescribeAlgorithmResponse.setter(Builder::validationSpecification)).constructor(AlgorithmValidationSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationSpecification").build()}).build();
    private static final SdkField<String> ALGORITHM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmStatus").getter(DescribeAlgorithmResponse.getter(DescribeAlgorithmResponse::algorithmStatusAsString)).setter(DescribeAlgorithmResponse.setter(Builder::algorithmStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmStatus").build()}).build();
    private static final SdkField<AlgorithmStatusDetails> ALGORITHM_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AlgorithmStatusDetails").getter(DescribeAlgorithmResponse.getter(DescribeAlgorithmResponse::algorithmStatusDetails)).setter(DescribeAlgorithmResponse.setter(Builder::algorithmStatusDetails)).constructor(AlgorithmStatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmStatusDetails").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(DescribeAlgorithmResponse.getter(DescribeAlgorithmResponse::productId)).setter(DescribeAlgorithmResponse.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<Boolean> CERTIFY_FOR_MARKETPLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CertifyForMarketplace").getter(DescribeAlgorithmResponse.getter(DescribeAlgorithmResponse::certifyForMarketplace)).setter(DescribeAlgorithmResponse.setter(Builder::certifyForMarketplace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertifyForMarketplace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_NAME_FIELD, ALGORITHM_ARN_FIELD, ALGORITHM_DESCRIPTION_FIELD, CREATION_TIME_FIELD, TRAINING_SPECIFICATION_FIELD, INFERENCE_SPECIFICATION_FIELD, VALIDATION_SPECIFICATION_FIELD, ALGORITHM_STATUS_FIELD, ALGORITHM_STATUS_DETAILS_FIELD, PRODUCT_ID_FIELD, CERTIFY_FOR_MARKETPLACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAlgorithmResponse.memberNameToFieldInitializer();
    private final String algorithmName;
    private final String algorithmArn;
    private final String algorithmDescription;
    private final Instant creationTime;
    private final TrainingSpecification trainingSpecification;
    private final InferenceSpecification inferenceSpecification;
    private final AlgorithmValidationSpecification validationSpecification;
    private final String algorithmStatus;
    private final AlgorithmStatusDetails algorithmStatusDetails;
    private final String productId;
    private final Boolean certifyForMarketplace;

    private DescribeAlgorithmResponse(BuilderImpl builder) {
        super(builder);
        this.algorithmName = builder.algorithmName;
        this.algorithmArn = builder.algorithmArn;
        this.algorithmDescription = builder.algorithmDescription;
        this.creationTime = builder.creationTime;
        this.trainingSpecification = builder.trainingSpecification;
        this.inferenceSpecification = builder.inferenceSpecification;
        this.validationSpecification = builder.validationSpecification;
        this.algorithmStatus = builder.algorithmStatus;
        this.algorithmStatusDetails = builder.algorithmStatusDetails;
        this.productId = builder.productId;
        this.certifyForMarketplace = builder.certifyForMarketplace;
    }

    public final String algorithmName() {
        return this.algorithmName;
    }

    public final String algorithmArn() {
        return this.algorithmArn;
    }

    public final String algorithmDescription() {
        return this.algorithmDescription;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final TrainingSpecification trainingSpecification() {
        return this.trainingSpecification;
    }

    public final InferenceSpecification inferenceSpecification() {
        return this.inferenceSpecification;
    }

    public final AlgorithmValidationSpecification validationSpecification() {
        return this.validationSpecification;
    }

    public final AlgorithmStatus algorithmStatus() {
        return AlgorithmStatus.fromValue(this.algorithmStatus);
    }

    public final String algorithmStatusAsString() {
        return this.algorithmStatus;
    }

    public final AlgorithmStatusDetails algorithmStatusDetails() {
        return this.algorithmStatusDetails;
    }

    public final String productId() {
        return this.productId;
    }

    public final Boolean certifyForMarketplace() {
        return this.certifyForMarketplace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.certifyForMarketplace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlgorithmResponse)) {
            return false;
        }
        DescribeAlgorithmResponse other = (DescribeAlgorithmResponse)((Object)obj);
        return Objects.equals(this.algorithmName(), other.algorithmName()) && Objects.equals(this.algorithmArn(), other.algorithmArn()) && Objects.equals(this.algorithmDescription(), other.algorithmDescription()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.trainingSpecification(), other.trainingSpecification()) && Objects.equals(this.inferenceSpecification(), other.inferenceSpecification()) && Objects.equals(this.validationSpecification(), other.validationSpecification()) && Objects.equals(this.algorithmStatusAsString(), other.algorithmStatusAsString()) && Objects.equals(this.algorithmStatusDetails(), other.algorithmStatusDetails()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.certifyForMarketplace(), other.certifyForMarketplace());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAlgorithmResponse").add("AlgorithmName", (Object)this.algorithmName()).add("AlgorithmArn", (Object)this.algorithmArn()).add("AlgorithmDescription", (Object)this.algorithmDescription()).add("CreationTime", (Object)this.creationTime()).add("TrainingSpecification", (Object)this.trainingSpecification()).add("InferenceSpecification", (Object)this.inferenceSpecification()).add("ValidationSpecification", (Object)this.validationSpecification()).add("AlgorithmStatus", (Object)this.algorithmStatusAsString()).add("AlgorithmStatusDetails", (Object)this.algorithmStatusDetails()).add("ProductId", (Object)this.productId()).add("CertifyForMarketplace", (Object)this.certifyForMarketplace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlgorithmName": {
                return Optional.ofNullable(clazz.cast(this.algorithmName()));
            }
            case "AlgorithmArn": {
                return Optional.ofNullable(clazz.cast(this.algorithmArn()));
            }
            case "AlgorithmDescription": {
                return Optional.ofNullable(clazz.cast(this.algorithmDescription()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TrainingSpecification": {
                return Optional.ofNullable(clazz.cast(this.trainingSpecification()));
            }
            case "InferenceSpecification": {
                return Optional.ofNullable(clazz.cast(this.inferenceSpecification()));
            }
            case "ValidationSpecification": {
                return Optional.ofNullable(clazz.cast(this.validationSpecification()));
            }
            case "AlgorithmStatus": {
                return Optional.ofNullable(clazz.cast(this.algorithmStatusAsString()));
            }
            case "AlgorithmStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.algorithmStatusDetails()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "CertifyForMarketplace": {
                return Optional.ofNullable(clazz.cast(this.certifyForMarketplace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AlgorithmName", ALGORITHM_NAME_FIELD);
        map.put("AlgorithmArn", ALGORITHM_ARN_FIELD);
        map.put("AlgorithmDescription", ALGORITHM_DESCRIPTION_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("TrainingSpecification", TRAINING_SPECIFICATION_FIELD);
        map.put("InferenceSpecification", INFERENCE_SPECIFICATION_FIELD);
        map.put("ValidationSpecification", VALIDATION_SPECIFICATION_FIELD);
        map.put("AlgorithmStatus", ALGORITHM_STATUS_FIELD);
        map.put("AlgorithmStatusDetails", ALGORITHM_STATUS_DETAILS_FIELD);
        map.put("ProductId", PRODUCT_ID_FIELD);
        map.put("CertifyForMarketplace", CERTIFY_FOR_MARKETPLACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlgorithmResponse, T> g) {
        return obj -> g.apply((DescribeAlgorithmResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String algorithmName;
        private String algorithmArn;
        private String algorithmDescription;
        private Instant creationTime;
        private TrainingSpecification trainingSpecification;
        private InferenceSpecification inferenceSpecification;
        private AlgorithmValidationSpecification validationSpecification;
        private String algorithmStatus;
        private AlgorithmStatusDetails algorithmStatusDetails;
        private String productId;
        private Boolean certifyForMarketplace;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlgorithmResponse model) {
            super(model);
            this.algorithmName(model.algorithmName);
            this.algorithmArn(model.algorithmArn);
            this.algorithmDescription(model.algorithmDescription);
            this.creationTime(model.creationTime);
            this.trainingSpecification(model.trainingSpecification);
            this.inferenceSpecification(model.inferenceSpecification);
            this.validationSpecification(model.validationSpecification);
            this.algorithmStatus(model.algorithmStatus);
            this.algorithmStatusDetails(model.algorithmStatusDetails);
            this.productId(model.productId);
            this.certifyForMarketplace(model.certifyForMarketplace);
        }

        public final String getAlgorithmName() {
            return this.algorithmName;
        }

        public final void setAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        @Override
        public final Builder algorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        public final String getAlgorithmArn() {
            return this.algorithmArn;
        }

        public final void setAlgorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
        }

        @Override
        public final Builder algorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
            return this;
        }

        public final String getAlgorithmDescription() {
            return this.algorithmDescription;
        }

        public final void setAlgorithmDescription(String algorithmDescription) {
            this.algorithmDescription = algorithmDescription;
        }

        @Override
        public final Builder algorithmDescription(String algorithmDescription) {
            this.algorithmDescription = algorithmDescription;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final TrainingSpecification.Builder getTrainingSpecification() {
            return this.trainingSpecification != null ? this.trainingSpecification.toBuilder() : null;
        }

        public final void setTrainingSpecification(TrainingSpecification.BuilderImpl trainingSpecification) {
            this.trainingSpecification = trainingSpecification != null ? trainingSpecification.build() : null;
        }

        @Override
        public final Builder trainingSpecification(TrainingSpecification trainingSpecification) {
            this.trainingSpecification = trainingSpecification;
            return this;
        }

        public final InferenceSpecification.Builder getInferenceSpecification() {
            return this.inferenceSpecification != null ? this.inferenceSpecification.toBuilder() : null;
        }

        public final void setInferenceSpecification(InferenceSpecification.BuilderImpl inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification != null ? inferenceSpecification.build() : null;
        }

        @Override
        public final Builder inferenceSpecification(InferenceSpecification inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        public final AlgorithmValidationSpecification.Builder getValidationSpecification() {
            return this.validationSpecification != null ? this.validationSpecification.toBuilder() : null;
        }

        public final void setValidationSpecification(AlgorithmValidationSpecification.BuilderImpl validationSpecification) {
            this.validationSpecification = validationSpecification != null ? validationSpecification.build() : null;
        }

        @Override
        public final Builder validationSpecification(AlgorithmValidationSpecification validationSpecification) {
            this.validationSpecification = validationSpecification;
            return this;
        }

        public final String getAlgorithmStatus() {
            return this.algorithmStatus;
        }

        public final void setAlgorithmStatus(String algorithmStatus) {
            this.algorithmStatus = algorithmStatus;
        }

        @Override
        public final Builder algorithmStatus(String algorithmStatus) {
            this.algorithmStatus = algorithmStatus;
            return this;
        }

        @Override
        public final Builder algorithmStatus(AlgorithmStatus algorithmStatus) {
            this.algorithmStatus(algorithmStatus == null ? null : algorithmStatus.toString());
            return this;
        }

        public final AlgorithmStatusDetails.Builder getAlgorithmStatusDetails() {
            return this.algorithmStatusDetails != null ? this.algorithmStatusDetails.toBuilder() : null;
        }

        public final void setAlgorithmStatusDetails(AlgorithmStatusDetails.BuilderImpl algorithmStatusDetails) {
            this.algorithmStatusDetails = algorithmStatusDetails != null ? algorithmStatusDetails.build() : null;
        }

        @Override
        public final Builder algorithmStatusDetails(AlgorithmStatusDetails algorithmStatusDetails) {
            this.algorithmStatusDetails = algorithmStatusDetails;
            return this;
        }

        public final String getProductId() {
            return this.productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final Boolean getCertifyForMarketplace() {
            return this.certifyForMarketplace;
        }

        public final void setCertifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
        }

        @Override
        public final Builder certifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
            return this;
        }

        @Override
        public DescribeAlgorithmResponse build() {
            return new DescribeAlgorithmResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAlgorithmResponse> {
        public Builder algorithmName(String var1);

        public Builder algorithmArn(String var1);

        public Builder algorithmDescription(String var1);

        public Builder creationTime(Instant var1);

        public Builder trainingSpecification(TrainingSpecification var1);

        default public Builder trainingSpecification(Consumer<TrainingSpecification.Builder> trainingSpecification) {
            return this.trainingSpecification((TrainingSpecification)((TrainingSpecification.Builder)TrainingSpecification.builder().applyMutation(trainingSpecification)).build());
        }

        public Builder inferenceSpecification(InferenceSpecification var1);

        default public Builder inferenceSpecification(Consumer<InferenceSpecification.Builder> inferenceSpecification) {
            return this.inferenceSpecification((InferenceSpecification)((InferenceSpecification.Builder)InferenceSpecification.builder().applyMutation(inferenceSpecification)).build());
        }

        public Builder validationSpecification(AlgorithmValidationSpecification var1);

        default public Builder validationSpecification(Consumer<AlgorithmValidationSpecification.Builder> validationSpecification) {
            return this.validationSpecification((AlgorithmValidationSpecification)((AlgorithmValidationSpecification.Builder)AlgorithmValidationSpecification.builder().applyMutation(validationSpecification)).build());
        }

        public Builder algorithmStatus(String var1);

        public Builder algorithmStatus(AlgorithmStatus var1);

        public Builder algorithmStatusDetails(AlgorithmStatusDetails var1);

        default public Builder algorithmStatusDetails(Consumer<AlgorithmStatusDetails.Builder> algorithmStatusDetails) {
            return this.algorithmStatusDetails((AlgorithmStatusDetails)((AlgorithmStatusDetails.Builder)AlgorithmStatusDetails.builder().applyMutation(algorithmStatusDetails)).build());
        }

        public Builder productId(String var1);

        public Builder certifyForMarketplace(Boolean var1);
    }
}

