/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.JobType;
import software.amazon.awssdk.services.sagemaker.model.Processor;
import software.amazon.awssdk.services.sagemaker.model.SageMakerImageVersionAliasesCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.VendorGuidance;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateImageVersionRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateImageVersionRequest> {
    private static final SdkField<String> BASE_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseImage").getter(CreateImageVersionRequest.getter(CreateImageVersionRequest::baseImage)).setter(CreateImageVersionRequest.setter(Builder::baseImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseImage").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateImageVersionRequest.getter(CreateImageVersionRequest::clientToken)).setter(CreateImageVersionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageName").getter(CreateImageVersionRequest.getter(CreateImageVersionRequest::imageName)).setter(CreateImageVersionRequest.setter(Builder::imageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()}).build();
    private static final SdkField<List<String>> ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aliases").getter(CreateImageVersionRequest.getter(CreateImageVersionRequest::aliases)).setter(CreateImageVersionRequest.setter(Builder::aliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VENDOR_GUIDANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VendorGuidance").getter(CreateImageVersionRequest.getter(CreateImageVersionRequest::vendorGuidanceAsString)).setter(CreateImageVersionRequest.setter(Builder::vendorGuidance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorGuidance").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobType").getter(CreateImageVersionRequest.getter(CreateImageVersionRequest::jobTypeAsString)).setter(CreateImageVersionRequest.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final SdkField<String> ML_FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MLFramework").getter(CreateImageVersionRequest.getter(CreateImageVersionRequest::mlFramework)).setter(CreateImageVersionRequest.setter(Builder::mlFramework)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLFramework").build()}).build();
    private static final SdkField<String> PROGRAMMING_LANG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgrammingLang").getter(CreateImageVersionRequest.getter(CreateImageVersionRequest::programmingLang)).setter(CreateImageVersionRequest.setter(Builder::programmingLang)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgrammingLang").build()}).build();
    private static final SdkField<String> PROCESSOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Processor").getter(CreateImageVersionRequest.getter(CreateImageVersionRequest::processorAsString)).setter(CreateImageVersionRequest.setter(Builder::processor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processor").build()}).build();
    private static final SdkField<Boolean> HOROVOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Horovod").getter(CreateImageVersionRequest.getter(CreateImageVersionRequest::horovod)).setter(CreateImageVersionRequest.setter(Builder::horovod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Horovod").build()}).build();
    private static final SdkField<String> RELEASE_NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReleaseNotes").getter(CreateImageVersionRequest.getter(CreateImageVersionRequest::releaseNotes)).setter(CreateImageVersionRequest.setter(Builder::releaseNotes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseNotes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_IMAGE_FIELD, CLIENT_TOKEN_FIELD, IMAGE_NAME_FIELD, ALIASES_FIELD, VENDOR_GUIDANCE_FIELD, JOB_TYPE_FIELD, ML_FRAMEWORK_FIELD, PROGRAMMING_LANG_FIELD, PROCESSOR_FIELD, HOROVOD_FIELD, RELEASE_NOTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateImageVersionRequest.memberNameToFieldInitializer();
    private final String baseImage;
    private final String clientToken;
    private final String imageName;
    private final List<String> aliases;
    private final String vendorGuidance;
    private final String jobType;
    private final String mlFramework;
    private final String programmingLang;
    private final String processor;
    private final Boolean horovod;
    private final String releaseNotes;

    private CreateImageVersionRequest(BuilderImpl builder) {
        super(builder);
        this.baseImage = builder.baseImage;
        this.clientToken = builder.clientToken;
        this.imageName = builder.imageName;
        this.aliases = builder.aliases;
        this.vendorGuidance = builder.vendorGuidance;
        this.jobType = builder.jobType;
        this.mlFramework = builder.mlFramework;
        this.programmingLang = builder.programmingLang;
        this.processor = builder.processor;
        this.horovod = builder.horovod;
        this.releaseNotes = builder.releaseNotes;
    }

    public final String baseImage() {
        return this.baseImage;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String imageName() {
        return this.imageName;
    }

    public final boolean hasAliases() {
        return this.aliases != null && !(this.aliases instanceof SdkAutoConstructList);
    }

    public final List<String> aliases() {
        return this.aliases;
    }

    public final VendorGuidance vendorGuidance() {
        return VendorGuidance.fromValue(this.vendorGuidance);
    }

    public final String vendorGuidanceAsString() {
        return this.vendorGuidance;
    }

    public final JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final String mlFramework() {
        return this.mlFramework;
    }

    public final String programmingLang() {
        return this.programmingLang;
    }

    public final Processor processor() {
        return Processor.fromValue(this.processor);
    }

    public final String processorAsString() {
        return this.processor;
    }

    public final Boolean horovod() {
        return this.horovod;
    }

    public final String releaseNotes() {
        return this.releaseNotes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.baseImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAliases() ? this.aliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorGuidanceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlFramework());
        hashCode = 31 * hashCode + Objects.hashCode(this.programmingLang());
        hashCode = 31 * hashCode + Objects.hashCode(this.processorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.horovod());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseNotes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageVersionRequest)) {
            return false;
        }
        CreateImageVersionRequest other = (CreateImageVersionRequest)((Object)obj);
        return Objects.equals(this.baseImage(), other.baseImage()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.imageName(), other.imageName()) && this.hasAliases() == other.hasAliases() && Objects.equals(this.aliases(), other.aliases()) && Objects.equals(this.vendorGuidanceAsString(), other.vendorGuidanceAsString()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.mlFramework(), other.mlFramework()) && Objects.equals(this.programmingLang(), other.programmingLang()) && Objects.equals(this.processorAsString(), other.processorAsString()) && Objects.equals(this.horovod(), other.horovod()) && Objects.equals(this.releaseNotes(), other.releaseNotes());
    }

    public final String toString() {
        return ToString.builder((String)"CreateImageVersionRequest").add("BaseImage", (Object)this.baseImage()).add("ClientToken", (Object)this.clientToken()).add("ImageName", (Object)this.imageName()).add("Aliases", this.hasAliases() ? this.aliases() : null).add("VendorGuidance", (Object)this.vendorGuidanceAsString()).add("JobType", (Object)this.jobTypeAsString()).add("MLFramework", (Object)this.mlFramework()).add("ProgrammingLang", (Object)this.programmingLang()).add("Processor", (Object)this.processorAsString()).add("Horovod", (Object)this.horovod()).add("ReleaseNotes", (Object)this.releaseNotes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseImage": {
                return Optional.ofNullable(clazz.cast(this.baseImage()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ImageName": {
                return Optional.ofNullable(clazz.cast(this.imageName()));
            }
            case "Aliases": {
                return Optional.ofNullable(clazz.cast(this.aliases()));
            }
            case "VendorGuidance": {
                return Optional.ofNullable(clazz.cast(this.vendorGuidanceAsString()));
            }
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "MLFramework": {
                return Optional.ofNullable(clazz.cast(this.mlFramework()));
            }
            case "ProgrammingLang": {
                return Optional.ofNullable(clazz.cast(this.programmingLang()));
            }
            case "Processor": {
                return Optional.ofNullable(clazz.cast(this.processorAsString()));
            }
            case "Horovod": {
                return Optional.ofNullable(clazz.cast(this.horovod()));
            }
            case "ReleaseNotes": {
                return Optional.ofNullable(clazz.cast(this.releaseNotes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BaseImage", BASE_IMAGE_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ImageName", IMAGE_NAME_FIELD);
        map.put("Aliases", ALIASES_FIELD);
        map.put("VendorGuidance", VENDOR_GUIDANCE_FIELD);
        map.put("JobType", JOB_TYPE_FIELD);
        map.put("MLFramework", ML_FRAMEWORK_FIELD);
        map.put("ProgrammingLang", PROGRAMMING_LANG_FIELD);
        map.put("Processor", PROCESSOR_FIELD);
        map.put("Horovod", HOROVOD_FIELD);
        map.put("ReleaseNotes", RELEASE_NOTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateImageVersionRequest, T> g) {
        return obj -> g.apply((CreateImageVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String baseImage;
        private String clientToken;
        private String imageName;
        private List<String> aliases = DefaultSdkAutoConstructList.getInstance();
        private String vendorGuidance;
        private String jobType;
        private String mlFramework;
        private String programmingLang;
        private String processor;
        private Boolean horovod;
        private String releaseNotes;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageVersionRequest model) {
            super(model);
            this.baseImage(model.baseImage);
            this.clientToken(model.clientToken);
            this.imageName(model.imageName);
            this.aliases(model.aliases);
            this.vendorGuidance(model.vendorGuidance);
            this.jobType(model.jobType);
            this.mlFramework(model.mlFramework);
            this.programmingLang(model.programmingLang);
            this.processor(model.processor);
            this.horovod(model.horovod);
            this.releaseNotes(model.releaseNotes);
        }

        public final String getBaseImage() {
            return this.baseImage;
        }

        public final void setBaseImage(String baseImage) {
            this.baseImage = baseImage;
        }

        @Override
        public final Builder baseImage(String baseImage) {
            this.baseImage = baseImage;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getImageName() {
            return this.imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final Collection<String> getAliases() {
            if (this.aliases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aliases;
        }

        public final void setAliases(Collection<String> aliases) {
            this.aliases = SageMakerImageVersionAliasesCopier.copy(aliases);
        }

        @Override
        public final Builder aliases(Collection<String> aliases) {
            this.aliases = SageMakerImageVersionAliasesCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(String ... aliases) {
            this.aliases(Arrays.asList(aliases));
            return this;
        }

        public final String getVendorGuidance() {
            return this.vendorGuidance;
        }

        public final void setVendorGuidance(String vendorGuidance) {
            this.vendorGuidance = vendorGuidance;
        }

        @Override
        public final Builder vendorGuidance(String vendorGuidance) {
            this.vendorGuidance = vendorGuidance;
            return this;
        }

        @Override
        public final Builder vendorGuidance(VendorGuidance vendorGuidance) {
            this.vendorGuidance(vendorGuidance == null ? null : vendorGuidance.toString());
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getMlFramework() {
            return this.mlFramework;
        }

        public final void setMlFramework(String mlFramework) {
            this.mlFramework = mlFramework;
        }

        @Override
        public final Builder mlFramework(String mlFramework) {
            this.mlFramework = mlFramework;
            return this;
        }

        public final String getProgrammingLang() {
            return this.programmingLang;
        }

        public final void setProgrammingLang(String programmingLang) {
            this.programmingLang = programmingLang;
        }

        @Override
        public final Builder programmingLang(String programmingLang) {
            this.programmingLang = programmingLang;
            return this;
        }

        public final String getProcessor() {
            return this.processor;
        }

        public final void setProcessor(String processor) {
            this.processor = processor;
        }

        @Override
        public final Builder processor(String processor) {
            this.processor = processor;
            return this;
        }

        @Override
        public final Builder processor(Processor processor) {
            this.processor(processor == null ? null : processor.toString());
            return this;
        }

        public final Boolean getHorovod() {
            return this.horovod;
        }

        public final void setHorovod(Boolean horovod) {
            this.horovod = horovod;
        }

        @Override
        public final Builder horovod(Boolean horovod) {
            this.horovod = horovod;
            return this;
        }

        public final String getReleaseNotes() {
            return this.releaseNotes;
        }

        public final void setReleaseNotes(String releaseNotes) {
            this.releaseNotes = releaseNotes;
        }

        @Override
        public final Builder releaseNotes(String releaseNotes) {
            this.releaseNotes = releaseNotes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImageVersionRequest build() {
            return new CreateImageVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateImageVersionRequest> {
        public Builder baseImage(String var1);

        public Builder clientToken(String var1);

        public Builder imageName(String var1);

        public Builder aliases(Collection<String> var1);

        public Builder aliases(String ... var1);

        public Builder vendorGuidance(String var1);

        public Builder vendorGuidance(VendorGuidance var1);

        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder mlFramework(String var1);

        public Builder programmingLang(String var1);

        public Builder processor(String var1);

        public Builder processor(Processor var1);

        public Builder horovod(Boolean var1);

        public Builder releaseNotes(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

