/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmValidationSpecification;
import software.amazon.awssdk.services.sagemaker.model.InferenceSpecification;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.TrainingSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAlgorithmRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateAlgorithmRequest> {
    private static final SdkField<String> ALGORITHM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmName").getter(CreateAlgorithmRequest.getter(CreateAlgorithmRequest::algorithmName)).setter(CreateAlgorithmRequest.setter(Builder::algorithmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmName").build()}).build();
    private static final SdkField<String> ALGORITHM_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmDescription").getter(CreateAlgorithmRequest.getter(CreateAlgorithmRequest::algorithmDescription)).setter(CreateAlgorithmRequest.setter(Builder::algorithmDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmDescription").build()}).build();
    private static final SdkField<TrainingSpecification> TRAINING_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrainingSpecification").getter(CreateAlgorithmRequest.getter(CreateAlgorithmRequest::trainingSpecification)).setter(CreateAlgorithmRequest.setter(Builder::trainingSpecification)).constructor(TrainingSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingSpecification").build()}).build();
    private static final SdkField<InferenceSpecification> INFERENCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InferenceSpecification").getter(CreateAlgorithmRequest.getter(CreateAlgorithmRequest::inferenceSpecification)).setter(CreateAlgorithmRequest.setter(Builder::inferenceSpecification)).constructor(InferenceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecification").build()}).build();
    private static final SdkField<AlgorithmValidationSpecification> VALIDATION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValidationSpecification").getter(CreateAlgorithmRequest.getter(CreateAlgorithmRequest::validationSpecification)).setter(CreateAlgorithmRequest.setter(Builder::validationSpecification)).constructor(AlgorithmValidationSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationSpecification").build()}).build();
    private static final SdkField<Boolean> CERTIFY_FOR_MARKETPLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CertifyForMarketplace").getter(CreateAlgorithmRequest.getter(CreateAlgorithmRequest::certifyForMarketplace)).setter(CreateAlgorithmRequest.setter(Builder::certifyForMarketplace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertifyForMarketplace").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateAlgorithmRequest.getter(CreateAlgorithmRequest::tags)).setter(CreateAlgorithmRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_NAME_FIELD, ALGORITHM_DESCRIPTION_FIELD, TRAINING_SPECIFICATION_FIELD, INFERENCE_SPECIFICATION_FIELD, VALIDATION_SPECIFICATION_FIELD, CERTIFY_FOR_MARKETPLACE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAlgorithmRequest.memberNameToFieldInitializer();
    private final String algorithmName;
    private final String algorithmDescription;
    private final TrainingSpecification trainingSpecification;
    private final InferenceSpecification inferenceSpecification;
    private final AlgorithmValidationSpecification validationSpecification;
    private final Boolean certifyForMarketplace;
    private final List<Tag> tags;

    private CreateAlgorithmRequest(BuilderImpl builder) {
        super(builder);
        this.algorithmName = builder.algorithmName;
        this.algorithmDescription = builder.algorithmDescription;
        this.trainingSpecification = builder.trainingSpecification;
        this.inferenceSpecification = builder.inferenceSpecification;
        this.validationSpecification = builder.validationSpecification;
        this.certifyForMarketplace = builder.certifyForMarketplace;
        this.tags = builder.tags;
    }

    public final String algorithmName() {
        return this.algorithmName;
    }

    public final String algorithmDescription() {
        return this.algorithmDescription;
    }

    public final TrainingSpecification trainingSpecification() {
        return this.trainingSpecification;
    }

    public final InferenceSpecification inferenceSpecification() {
        return this.inferenceSpecification;
    }

    public final AlgorithmValidationSpecification validationSpecification() {
        return this.validationSpecification;
    }

    public final Boolean certifyForMarketplace() {
        return this.certifyForMarketplace;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.certifyForMarketplace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAlgorithmRequest)) {
            return false;
        }
        CreateAlgorithmRequest other = (CreateAlgorithmRequest)((Object)obj);
        return Objects.equals(this.algorithmName(), other.algorithmName()) && Objects.equals(this.algorithmDescription(), other.algorithmDescription()) && Objects.equals(this.trainingSpecification(), other.trainingSpecification()) && Objects.equals(this.inferenceSpecification(), other.inferenceSpecification()) && Objects.equals(this.validationSpecification(), other.validationSpecification()) && Objects.equals(this.certifyForMarketplace(), other.certifyForMarketplace()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAlgorithmRequest").add("AlgorithmName", (Object)this.algorithmName()).add("AlgorithmDescription", (Object)this.algorithmDescription()).add("TrainingSpecification", (Object)this.trainingSpecification()).add("InferenceSpecification", (Object)this.inferenceSpecification()).add("ValidationSpecification", (Object)this.validationSpecification()).add("CertifyForMarketplace", (Object)this.certifyForMarketplace()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlgorithmName": {
                return Optional.ofNullable(clazz.cast(this.algorithmName()));
            }
            case "AlgorithmDescription": {
                return Optional.ofNullable(clazz.cast(this.algorithmDescription()));
            }
            case "TrainingSpecification": {
                return Optional.ofNullable(clazz.cast(this.trainingSpecification()));
            }
            case "InferenceSpecification": {
                return Optional.ofNullable(clazz.cast(this.inferenceSpecification()));
            }
            case "ValidationSpecification": {
                return Optional.ofNullable(clazz.cast(this.validationSpecification()));
            }
            case "CertifyForMarketplace": {
                return Optional.ofNullable(clazz.cast(this.certifyForMarketplace()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AlgorithmName", ALGORITHM_NAME_FIELD);
        map.put("AlgorithmDescription", ALGORITHM_DESCRIPTION_FIELD);
        map.put("TrainingSpecification", TRAINING_SPECIFICATION_FIELD);
        map.put("InferenceSpecification", INFERENCE_SPECIFICATION_FIELD);
        map.put("ValidationSpecification", VALIDATION_SPECIFICATION_FIELD);
        map.put("CertifyForMarketplace", CERTIFY_FOR_MARKETPLACE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAlgorithmRequest, T> g) {
        return obj -> g.apply((CreateAlgorithmRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String algorithmName;
        private String algorithmDescription;
        private TrainingSpecification trainingSpecification;
        private InferenceSpecification inferenceSpecification;
        private AlgorithmValidationSpecification validationSpecification;
        private Boolean certifyForMarketplace;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAlgorithmRequest model) {
            super(model);
            this.algorithmName(model.algorithmName);
            this.algorithmDescription(model.algorithmDescription);
            this.trainingSpecification(model.trainingSpecification);
            this.inferenceSpecification(model.inferenceSpecification);
            this.validationSpecification(model.validationSpecification);
            this.certifyForMarketplace(model.certifyForMarketplace);
            this.tags(model.tags);
        }

        public final String getAlgorithmName() {
            return this.algorithmName;
        }

        public final void setAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        @Override
        public final Builder algorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        public final String getAlgorithmDescription() {
            return this.algorithmDescription;
        }

        public final void setAlgorithmDescription(String algorithmDescription) {
            this.algorithmDescription = algorithmDescription;
        }

        @Override
        public final Builder algorithmDescription(String algorithmDescription) {
            this.algorithmDescription = algorithmDescription;
            return this;
        }

        public final TrainingSpecification.Builder getTrainingSpecification() {
            return this.trainingSpecification != null ? this.trainingSpecification.toBuilder() : null;
        }

        public final void setTrainingSpecification(TrainingSpecification.BuilderImpl trainingSpecification) {
            this.trainingSpecification = trainingSpecification != null ? trainingSpecification.build() : null;
        }

        @Override
        public final Builder trainingSpecification(TrainingSpecification trainingSpecification) {
            this.trainingSpecification = trainingSpecification;
            return this;
        }

        public final InferenceSpecification.Builder getInferenceSpecification() {
            return this.inferenceSpecification != null ? this.inferenceSpecification.toBuilder() : null;
        }

        public final void setInferenceSpecification(InferenceSpecification.BuilderImpl inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification != null ? inferenceSpecification.build() : null;
        }

        @Override
        public final Builder inferenceSpecification(InferenceSpecification inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        public final AlgorithmValidationSpecification.Builder getValidationSpecification() {
            return this.validationSpecification != null ? this.validationSpecification.toBuilder() : null;
        }

        public final void setValidationSpecification(AlgorithmValidationSpecification.BuilderImpl validationSpecification) {
            this.validationSpecification = validationSpecification != null ? validationSpecification.build() : null;
        }

        @Override
        public final Builder validationSpecification(AlgorithmValidationSpecification validationSpecification) {
            this.validationSpecification = validationSpecification;
            return this;
        }

        public final Boolean getCertifyForMarketplace() {
            return this.certifyForMarketplace;
        }

        public final void setCertifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
        }

        @Override
        public final Builder certifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAlgorithmRequest build() {
            return new CreateAlgorithmRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAlgorithmRequest> {
        public Builder algorithmName(String var1);

        public Builder algorithmDescription(String var1);

        public Builder trainingSpecification(TrainingSpecification var1);

        default public Builder trainingSpecification(Consumer<TrainingSpecification.Builder> trainingSpecification) {
            return this.trainingSpecification((TrainingSpecification)((TrainingSpecification.Builder)TrainingSpecification.builder().applyMutation(trainingSpecification)).build());
        }

        public Builder inferenceSpecification(InferenceSpecification var1);

        default public Builder inferenceSpecification(Consumer<InferenceSpecification.Builder> inferenceSpecification) {
            return this.inferenceSpecification((InferenceSpecification)((InferenceSpecification.Builder)InferenceSpecification.builder().applyMutation(inferenceSpecification)).build());
        }

        public Builder validationSpecification(AlgorithmValidationSpecification var1);

        default public Builder validationSpecification(Consumer<AlgorithmValidationSpecification.Builder> validationSpecification) {
            return this.validationSpecification((AlgorithmValidationSpecification)((AlgorithmValidationSpecification.Builder)AlgorithmValidationSpecification.builder().applyMutation(validationSpecification)).build());
        }

        public Builder certifyForMarketplace(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

