/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AssumableRoleArnsCopier;
import software.amazon.awssdk.services.sagemaker.model.ExecutionRoleArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmrSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmrSettings> {
    private static final SdkField<List<String>> ASSUMABLE_ROLE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssumableRoleArns").getter(EmrSettings.getter(EmrSettings::assumableRoleArns)).setter(EmrSettings.setter(Builder::assumableRoleArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssumableRoleArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXECUTION_ROLE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExecutionRoleArns").getter(EmrSettings.getter(EmrSettings::executionRoleArns)).setter(EmrSettings.setter(Builder::executionRoleArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSUMABLE_ROLE_ARNS_FIELD, EXECUTION_ROLE_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EmrSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> assumableRoleArns;
    private final List<String> executionRoleArns;

    private EmrSettings(BuilderImpl builder) {
        this.assumableRoleArns = builder.assumableRoleArns;
        this.executionRoleArns = builder.executionRoleArns;
    }

    public final boolean hasAssumableRoleArns() {
        return this.assumableRoleArns != null && !(this.assumableRoleArns instanceof SdkAutoConstructList);
    }

    public final List<String> assumableRoleArns() {
        return this.assumableRoleArns;
    }

    public final boolean hasExecutionRoleArns() {
        return this.executionRoleArns != null && !(this.executionRoleArns instanceof SdkAutoConstructList);
    }

    public final List<String> executionRoleArns() {
        return this.executionRoleArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssumableRoleArns() ? this.assumableRoleArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutionRoleArns() ? this.executionRoleArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmrSettings)) {
            return false;
        }
        EmrSettings other = (EmrSettings)obj;
        return this.hasAssumableRoleArns() == other.hasAssumableRoleArns() && Objects.equals(this.assumableRoleArns(), other.assumableRoleArns()) && this.hasExecutionRoleArns() == other.hasExecutionRoleArns() && Objects.equals(this.executionRoleArns(), other.executionRoleArns());
    }

    public final String toString() {
        return ToString.builder((String)"EmrSettings").add("AssumableRoleArns", this.hasAssumableRoleArns() ? this.assumableRoleArns() : null).add("ExecutionRoleArns", this.hasExecutionRoleArns() ? this.executionRoleArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssumableRoleArns": {
                return Optional.ofNullable(clazz.cast(this.assumableRoleArns()));
            }
            case "ExecutionRoleArns": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("AssumableRoleArns", ASSUMABLE_ROLE_ARNS_FIELD);
        map.put("ExecutionRoleArns", EXECUTION_ROLE_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmrSettings, T> g) {
        return obj -> g.apply((EmrSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> assumableRoleArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> executionRoleArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmrSettings model) {
            this.assumableRoleArns(model.assumableRoleArns);
            this.executionRoleArns(model.executionRoleArns);
        }

        public final Collection<String> getAssumableRoleArns() {
            if (this.assumableRoleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assumableRoleArns;
        }

        public final void setAssumableRoleArns(Collection<String> assumableRoleArns) {
            this.assumableRoleArns = AssumableRoleArnsCopier.copy(assumableRoleArns);
        }

        @Override
        public final Builder assumableRoleArns(Collection<String> assumableRoleArns) {
            this.assumableRoleArns = AssumableRoleArnsCopier.copy(assumableRoleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assumableRoleArns(String ... assumableRoleArns) {
            this.assumableRoleArns(Arrays.asList(assumableRoleArns));
            return this;
        }

        public final Collection<String> getExecutionRoleArns() {
            if (this.executionRoleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.executionRoleArns;
        }

        public final void setExecutionRoleArns(Collection<String> executionRoleArns) {
            this.executionRoleArns = ExecutionRoleArnsCopier.copy(executionRoleArns);
        }

        @Override
        public final Builder executionRoleArns(Collection<String> executionRoleArns) {
            this.executionRoleArns = ExecutionRoleArnsCopier.copy(executionRoleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionRoleArns(String ... executionRoleArns) {
            this.executionRoleArns(Arrays.asList(executionRoleArns));
            return this;
        }

        public EmrSettings build() {
            return new EmrSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmrSettings> {
        public Builder assumableRoleArns(Collection<String> var1);

        public Builder assumableRoleArns(String ... var1);

        public Builder executionRoleArns(Collection<String> var1);

        public Builder executionRoleArns(String ... var1);
    }
}

