/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ComputeQuotaSummary;
import software.amazon.awssdk.services.sagemaker.model.ComputeQuotaSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListComputeQuotasResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListComputeQuotasResponse> {
    private static final SdkField<List<ComputeQuotaSummary>> COMPUTE_QUOTA_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ComputeQuotaSummaries").getter(ListComputeQuotasResponse.getter(ListComputeQuotasResponse::computeQuotaSummaries)).setter(ListComputeQuotasResponse.setter(Builder::computeQuotaSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComputeQuotaSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListComputeQuotasResponse.getter(ListComputeQuotasResponse::nextToken)).setter(ListComputeQuotasResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_QUOTA_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListComputeQuotasResponse.memberNameToFieldInitializer();
    private final List<ComputeQuotaSummary> computeQuotaSummaries;
    private final String nextToken;

    private ListComputeQuotasResponse(BuilderImpl builder) {
        super(builder);
        this.computeQuotaSummaries = builder.computeQuotaSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasComputeQuotaSummaries() {
        return this.computeQuotaSummaries != null && !(this.computeQuotaSummaries instanceof SdkAutoConstructList);
    }

    public final List<ComputeQuotaSummary> computeQuotaSummaries() {
        return this.computeQuotaSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputeQuotaSummaries() ? this.computeQuotaSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComputeQuotasResponse)) {
            return false;
        }
        ListComputeQuotasResponse other = (ListComputeQuotasResponse)((Object)obj);
        return this.hasComputeQuotaSummaries() == other.hasComputeQuotaSummaries() && Objects.equals(this.computeQuotaSummaries(), other.computeQuotaSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListComputeQuotasResponse").add("ComputeQuotaSummaries", this.hasComputeQuotaSummaries() ? this.computeQuotaSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComputeQuotaSummaries": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ComputeQuotaSummaries", COMPUTE_QUOTA_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListComputeQuotasResponse, T> g) {
        return obj -> g.apply((ListComputeQuotasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<ComputeQuotaSummary> computeQuotaSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComputeQuotasResponse model) {
            super(model);
            this.computeQuotaSummaries(model.computeQuotaSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ComputeQuotaSummary.Builder> getComputeQuotaSummaries() {
            List<ComputeQuotaSummary.Builder> result = ComputeQuotaSummaryListCopier.copyToBuilder(this.computeQuotaSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputeQuotaSummaries(Collection<ComputeQuotaSummary.BuilderImpl> computeQuotaSummaries) {
            this.computeQuotaSummaries = ComputeQuotaSummaryListCopier.copyFromBuilder(computeQuotaSummaries);
        }

        @Override
        public final Builder computeQuotaSummaries(Collection<ComputeQuotaSummary> computeQuotaSummaries) {
            this.computeQuotaSummaries = ComputeQuotaSummaryListCopier.copy(computeQuotaSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeQuotaSummaries(ComputeQuotaSummary ... computeQuotaSummaries) {
            this.computeQuotaSummaries(Arrays.asList(computeQuotaSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeQuotaSummaries(Consumer<ComputeQuotaSummary.Builder> ... computeQuotaSummaries) {
            this.computeQuotaSummaries(Stream.of(computeQuotaSummaries).map(c -> (ComputeQuotaSummary)((ComputeQuotaSummary.Builder)ComputeQuotaSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListComputeQuotasResponse build() {
            return new ListComputeQuotasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListComputeQuotasResponse> {
        public Builder computeQuotaSummaries(Collection<ComputeQuotaSummary> var1);

        public Builder computeQuotaSummaries(ComputeQuotaSummary ... var1);

        public Builder computeQuotaSummaries(Consumer<ComputeQuotaSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

