/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceRecommendation;
import software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceRecommendationsCopier;
import software.amazon.awssdk.services.sagemaker.model.RecommendationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentRecommendation> {
    private static final SdkField<String> RECOMMENDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationStatus").getter(DeploymentRecommendation.getter(DeploymentRecommendation::recommendationStatusAsString)).setter(DeploymentRecommendation.setter(Builder::recommendationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationStatus").build()}).build();
    private static final SdkField<List<RealTimeInferenceRecommendation>> REAL_TIME_INFERENCE_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RealTimeInferenceRecommendations").getter(DeploymentRecommendation.getter(DeploymentRecommendation::realTimeInferenceRecommendations)).setter(DeploymentRecommendation.setter(Builder::realTimeInferenceRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealTimeInferenceRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RealTimeInferenceRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_STATUS_FIELD, REAL_TIME_INFERENCE_RECOMMENDATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeploymentRecommendation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String recommendationStatus;
    private final List<RealTimeInferenceRecommendation> realTimeInferenceRecommendations;

    private DeploymentRecommendation(BuilderImpl builder) {
        this.recommendationStatus = builder.recommendationStatus;
        this.realTimeInferenceRecommendations = builder.realTimeInferenceRecommendations;
    }

    public final RecommendationStatus recommendationStatus() {
        return RecommendationStatus.fromValue(this.recommendationStatus);
    }

    public final String recommendationStatusAsString() {
        return this.recommendationStatus;
    }

    public final boolean hasRealTimeInferenceRecommendations() {
        return this.realTimeInferenceRecommendations != null && !(this.realTimeInferenceRecommendations instanceof SdkAutoConstructList);
    }

    public final List<RealTimeInferenceRecommendation> realTimeInferenceRecommendations() {
        return this.realTimeInferenceRecommendations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRealTimeInferenceRecommendations() ? this.realTimeInferenceRecommendations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentRecommendation)) {
            return false;
        }
        DeploymentRecommendation other = (DeploymentRecommendation)obj;
        return Objects.equals(this.recommendationStatusAsString(), other.recommendationStatusAsString()) && this.hasRealTimeInferenceRecommendations() == other.hasRealTimeInferenceRecommendations() && Objects.equals(this.realTimeInferenceRecommendations(), other.realTimeInferenceRecommendations());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentRecommendation").add("RecommendationStatus", (Object)this.recommendationStatusAsString()).add("RealTimeInferenceRecommendations", this.hasRealTimeInferenceRecommendations() ? this.realTimeInferenceRecommendations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecommendationStatus": {
                return Optional.ofNullable(clazz.cast(this.recommendationStatusAsString()));
            }
            case "RealTimeInferenceRecommendations": {
                return Optional.ofNullable(clazz.cast(this.realTimeInferenceRecommendations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RecommendationStatus", RECOMMENDATION_STATUS_FIELD);
        map.put("RealTimeInferenceRecommendations", REAL_TIME_INFERENCE_RECOMMENDATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentRecommendation, T> g) {
        return obj -> g.apply((DeploymentRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recommendationStatus;
        private List<RealTimeInferenceRecommendation> realTimeInferenceRecommendations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentRecommendation model) {
            this.recommendationStatus(model.recommendationStatus);
            this.realTimeInferenceRecommendations(model.realTimeInferenceRecommendations);
        }

        public final String getRecommendationStatus() {
            return this.recommendationStatus;
        }

        public final void setRecommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
        }

        @Override
        public final Builder recommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
            return this;
        }

        @Override
        public final Builder recommendationStatus(RecommendationStatus recommendationStatus) {
            this.recommendationStatus(recommendationStatus == null ? null : recommendationStatus.toString());
            return this;
        }

        public final List<RealTimeInferenceRecommendation.Builder> getRealTimeInferenceRecommendations() {
            List<RealTimeInferenceRecommendation.Builder> result = RealTimeInferenceRecommendationsCopier.copyToBuilder(this.realTimeInferenceRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRealTimeInferenceRecommendations(Collection<RealTimeInferenceRecommendation.BuilderImpl> realTimeInferenceRecommendations) {
            this.realTimeInferenceRecommendations = RealTimeInferenceRecommendationsCopier.copyFromBuilder(realTimeInferenceRecommendations);
        }

        @Override
        public final Builder realTimeInferenceRecommendations(Collection<RealTimeInferenceRecommendation> realTimeInferenceRecommendations) {
            this.realTimeInferenceRecommendations = RealTimeInferenceRecommendationsCopier.copy(realTimeInferenceRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder realTimeInferenceRecommendations(RealTimeInferenceRecommendation ... realTimeInferenceRecommendations) {
            this.realTimeInferenceRecommendations(Arrays.asList(realTimeInferenceRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder realTimeInferenceRecommendations(Consumer<RealTimeInferenceRecommendation.Builder> ... realTimeInferenceRecommendations) {
            this.realTimeInferenceRecommendations(Stream.of(realTimeInferenceRecommendations).map(c -> (RealTimeInferenceRecommendation)((RealTimeInferenceRecommendation.Builder)RealTimeInferenceRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DeploymentRecommendation build() {
            return new DeploymentRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentRecommendation> {
        public Builder recommendationStatus(String var1);

        public Builder recommendationStatus(RecommendationStatus var1);

        public Builder realTimeInferenceRecommendations(Collection<RealTimeInferenceRecommendation> var1);

        public Builder realTimeInferenceRecommendations(RealTimeInferenceRecommendation ... var1);

        public Builder realTimeInferenceRecommendations(Consumer<RealTimeInferenceRecommendation.Builder> ... var1);
    }
}

