/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataSourceName {
    SALESFORCE_GENIE("SalesforceGenie"),
    SNOWFLAKE("Snowflake"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataSourceName> VALUE_MAP;
    private final String value;

    private DataSourceName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSourceName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSourceName> knownValues() {
        EnumSet<DataSourceName> knownValues = EnumSet.allOf(DataSourceName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataSourceName.class, DataSourceName::toString);
    }
}

