/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CapacityReservationPreference;
import software.amazon.awssdk.services.sagemaker.model.Ec2CapacityReservation;
import software.amazon.awssdk.services.sagemaker.model.Ec2CapacityReservationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductionVariantCapacityReservationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductionVariantCapacityReservationSummary> {
    private static final SdkField<String> ML_RESERVATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MlReservationArn").getter(ProductionVariantCapacityReservationSummary.getter(ProductionVariantCapacityReservationSummary::mlReservationArn)).setter(ProductionVariantCapacityReservationSummary.setter(Builder::mlReservationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlReservationArn").build()}).build();
    private static final SdkField<String> CAPACITY_RESERVATION_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationPreference").getter(ProductionVariantCapacityReservationSummary.getter(ProductionVariantCapacityReservationSummary::capacityReservationPreferenceAsString)).setter(ProductionVariantCapacityReservationSummary.setter(Builder::capacityReservationPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationPreference").build()}).build();
    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalInstanceCount").getter(ProductionVariantCapacityReservationSummary.getter(ProductionVariantCapacityReservationSummary::totalInstanceCount)).setter(ProductionVariantCapacityReservationSummary.setter(Builder::totalInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount").build()}).build();
    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableInstanceCount").getter(ProductionVariantCapacityReservationSummary.getter(ProductionVariantCapacityReservationSummary::availableInstanceCount)).setter(ProductionVariantCapacityReservationSummary.setter(Builder::availableInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount").build()}).build();
    private static final SdkField<Integer> USED_BY_CURRENT_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UsedByCurrentEndpoint").getter(ProductionVariantCapacityReservationSummary.getter(ProductionVariantCapacityReservationSummary::usedByCurrentEndpoint)).setter(ProductionVariantCapacityReservationSummary.setter(Builder::usedByCurrentEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsedByCurrentEndpoint").build()}).build();
    private static final SdkField<List<Ec2CapacityReservation>> EC2_CAPACITY_RESERVATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ec2CapacityReservations").getter(ProductionVariantCapacityReservationSummary.getter(ProductionVariantCapacityReservationSummary::ec2CapacityReservations)).setter(ProductionVariantCapacityReservationSummary.setter(Builder::ec2CapacityReservations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2CapacityReservations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ec2CapacityReservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_RESERVATION_ARN_FIELD, CAPACITY_RESERVATION_PREFERENCE_FIELD, TOTAL_INSTANCE_COUNT_FIELD, AVAILABLE_INSTANCE_COUNT_FIELD, USED_BY_CURRENT_ENDPOINT_FIELD, EC2_CAPACITY_RESERVATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProductionVariantCapacityReservationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mlReservationArn;
    private final String capacityReservationPreference;
    private final Integer totalInstanceCount;
    private final Integer availableInstanceCount;
    private final Integer usedByCurrentEndpoint;
    private final List<Ec2CapacityReservation> ec2CapacityReservations;

    private ProductionVariantCapacityReservationSummary(BuilderImpl builder) {
        this.mlReservationArn = builder.mlReservationArn;
        this.capacityReservationPreference = builder.capacityReservationPreference;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.usedByCurrentEndpoint = builder.usedByCurrentEndpoint;
        this.ec2CapacityReservations = builder.ec2CapacityReservations;
    }

    public final String mlReservationArn() {
        return this.mlReservationArn;
    }

    public final CapacityReservationPreference capacityReservationPreference() {
        return CapacityReservationPreference.fromValue(this.capacityReservationPreference);
    }

    public final String capacityReservationPreferenceAsString() {
        return this.capacityReservationPreference;
    }

    public final Integer totalInstanceCount() {
        return this.totalInstanceCount;
    }

    public final Integer availableInstanceCount() {
        return this.availableInstanceCount;
    }

    public final Integer usedByCurrentEndpoint() {
        return this.usedByCurrentEndpoint;
    }

    public final boolean hasEc2CapacityReservations() {
        return this.ec2CapacityReservations != null && !(this.ec2CapacityReservations instanceof SdkAutoConstructList);
    }

    public final List<Ec2CapacityReservation> ec2CapacityReservations() {
        return this.ec2CapacityReservations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mlReservationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.usedByCurrentEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2CapacityReservations() ? this.ec2CapacityReservations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariantCapacityReservationSummary)) {
            return false;
        }
        ProductionVariantCapacityReservationSummary other = (ProductionVariantCapacityReservationSummary)obj;
        return Objects.equals(this.mlReservationArn(), other.mlReservationArn()) && Objects.equals(this.capacityReservationPreferenceAsString(), other.capacityReservationPreferenceAsString()) && Objects.equals(this.totalInstanceCount(), other.totalInstanceCount()) && Objects.equals(this.availableInstanceCount(), other.availableInstanceCount()) && Objects.equals(this.usedByCurrentEndpoint(), other.usedByCurrentEndpoint()) && this.hasEc2CapacityReservations() == other.hasEc2CapacityReservations() && Objects.equals(this.ec2CapacityReservations(), other.ec2CapacityReservations());
    }

    public final String toString() {
        return ToString.builder((String)"ProductionVariantCapacityReservationSummary").add("MlReservationArn", (Object)this.mlReservationArn()).add("CapacityReservationPreference", (Object)this.capacityReservationPreferenceAsString()).add("TotalInstanceCount", (Object)this.totalInstanceCount()).add("AvailableInstanceCount", (Object)this.availableInstanceCount()).add("UsedByCurrentEndpoint", (Object)this.usedByCurrentEndpoint()).add("Ec2CapacityReservations", this.hasEc2CapacityReservations() ? this.ec2CapacityReservations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MlReservationArn": {
                return Optional.ofNullable(clazz.cast(this.mlReservationArn()));
            }
            case "CapacityReservationPreference": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationPreferenceAsString()));
            }
            case "TotalInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.totalInstanceCount()));
            }
            case "AvailableInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.availableInstanceCount()));
            }
            case "UsedByCurrentEndpoint": {
                return Optional.ofNullable(clazz.cast(this.usedByCurrentEndpoint()));
            }
            case "Ec2CapacityReservations": {
                return Optional.ofNullable(clazz.cast(this.ec2CapacityReservations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MlReservationArn", ML_RESERVATION_ARN_FIELD);
        map.put("CapacityReservationPreference", CAPACITY_RESERVATION_PREFERENCE_FIELD);
        map.put("TotalInstanceCount", TOTAL_INSTANCE_COUNT_FIELD);
        map.put("AvailableInstanceCount", AVAILABLE_INSTANCE_COUNT_FIELD);
        map.put("UsedByCurrentEndpoint", USED_BY_CURRENT_ENDPOINT_FIELD);
        map.put("Ec2CapacityReservations", EC2_CAPACITY_RESERVATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProductionVariantCapacityReservationSummary, T> g) {
        return obj -> g.apply((ProductionVariantCapacityReservationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mlReservationArn;
        private String capacityReservationPreference;
        private Integer totalInstanceCount;
        private Integer availableInstanceCount;
        private Integer usedByCurrentEndpoint;
        private List<Ec2CapacityReservation> ec2CapacityReservations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariantCapacityReservationSummary model) {
            this.mlReservationArn(model.mlReservationArn);
            this.capacityReservationPreference(model.capacityReservationPreference);
            this.totalInstanceCount(model.totalInstanceCount);
            this.availableInstanceCount(model.availableInstanceCount);
            this.usedByCurrentEndpoint(model.usedByCurrentEndpoint);
            this.ec2CapacityReservations(model.ec2CapacityReservations);
        }

        public final String getMlReservationArn() {
            return this.mlReservationArn;
        }

        public final void setMlReservationArn(String mlReservationArn) {
            this.mlReservationArn = mlReservationArn;
        }

        @Override
        public final Builder mlReservationArn(String mlReservationArn) {
            this.mlReservationArn = mlReservationArn;
            return this;
        }

        public final String getCapacityReservationPreference() {
            return this.capacityReservationPreference;
        }

        public final void setCapacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
        }

        @Override
        public final Builder capacityReservationPreference(String capacityReservationPreference) {
            this.capacityReservationPreference = capacityReservationPreference;
            return this;
        }

        @Override
        public final Builder capacityReservationPreference(CapacityReservationPreference capacityReservationPreference) {
            this.capacityReservationPreference(capacityReservationPreference == null ? null : capacityReservationPreference.toString());
            return this;
        }

        public final Integer getTotalInstanceCount() {
            return this.totalInstanceCount;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final Integer getAvailableInstanceCount() {
            return this.availableInstanceCount;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final Integer getUsedByCurrentEndpoint() {
            return this.usedByCurrentEndpoint;
        }

        public final void setUsedByCurrentEndpoint(Integer usedByCurrentEndpoint) {
            this.usedByCurrentEndpoint = usedByCurrentEndpoint;
        }

        @Override
        public final Builder usedByCurrentEndpoint(Integer usedByCurrentEndpoint) {
            this.usedByCurrentEndpoint = usedByCurrentEndpoint;
            return this;
        }

        public final List<Ec2CapacityReservation.Builder> getEc2CapacityReservations() {
            List<Ec2CapacityReservation.Builder> result = Ec2CapacityReservationsListCopier.copyToBuilder(this.ec2CapacityReservations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2CapacityReservations(Collection<Ec2CapacityReservation.BuilderImpl> ec2CapacityReservations) {
            this.ec2CapacityReservations = Ec2CapacityReservationsListCopier.copyFromBuilder(ec2CapacityReservations);
        }

        @Override
        public final Builder ec2CapacityReservations(Collection<Ec2CapacityReservation> ec2CapacityReservations) {
            this.ec2CapacityReservations = Ec2CapacityReservationsListCopier.copy(ec2CapacityReservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2CapacityReservations(Ec2CapacityReservation ... ec2CapacityReservations) {
            this.ec2CapacityReservations(Arrays.asList(ec2CapacityReservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2CapacityReservations(Consumer<Ec2CapacityReservation.Builder> ... ec2CapacityReservations) {
            this.ec2CapacityReservations(Stream.of(ec2CapacityReservations).map(c -> (Ec2CapacityReservation)((Ec2CapacityReservation.Builder)Ec2CapacityReservation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ProductionVariantCapacityReservationSummary build() {
            return new ProductionVariantCapacityReservationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductionVariantCapacityReservationSummary> {
        public Builder mlReservationArn(String var1);

        public Builder capacityReservationPreference(String var1);

        public Builder capacityReservationPreference(CapacityReservationPreference var1);

        public Builder totalInstanceCount(Integer var1);

        public Builder availableInstanceCount(Integer var1);

        public Builder usedByCurrentEndpoint(Integer var1);

        public Builder ec2CapacityReservations(Collection<Ec2CapacityReservation> var1);

        public Builder ec2CapacityReservations(Ec2CapacityReservation ... var1);

        public Builder ec2CapacityReservations(Consumer<Ec2CapacityReservation.Builder> ... var1);
    }
}

