/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ec2CapacityReservation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ec2CapacityReservation> {
    private static final SdkField<String> EC2_CAPACITY_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2CapacityReservationId").getter(Ec2CapacityReservation.getter(Ec2CapacityReservation::ec2CapacityReservationId)).setter(Ec2CapacityReservation.setter(Builder::ec2CapacityReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2CapacityReservationId").build()}).build();
    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalInstanceCount").getter(Ec2CapacityReservation.getter(Ec2CapacityReservation::totalInstanceCount)).setter(Ec2CapacityReservation.setter(Builder::totalInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount").build()}).build();
    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableInstanceCount").getter(Ec2CapacityReservation.getter(Ec2CapacityReservation::availableInstanceCount)).setter(Ec2CapacityReservation.setter(Builder::availableInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount").build()}).build();
    private static final SdkField<Integer> USED_BY_CURRENT_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UsedByCurrentEndpoint").getter(Ec2CapacityReservation.getter(Ec2CapacityReservation::usedByCurrentEndpoint)).setter(Ec2CapacityReservation.setter(Builder::usedByCurrentEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsedByCurrentEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_CAPACITY_RESERVATION_ID_FIELD, TOTAL_INSTANCE_COUNT_FIELD, AVAILABLE_INSTANCE_COUNT_FIELD, USED_BY_CURRENT_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Ec2CapacityReservation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ec2CapacityReservationId;
    private final Integer totalInstanceCount;
    private final Integer availableInstanceCount;
    private final Integer usedByCurrentEndpoint;

    private Ec2CapacityReservation(BuilderImpl builder) {
        this.ec2CapacityReservationId = builder.ec2CapacityReservationId;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.usedByCurrentEndpoint = builder.usedByCurrentEndpoint;
    }

    public final String ec2CapacityReservationId() {
        return this.ec2CapacityReservationId;
    }

    public final Integer totalInstanceCount() {
        return this.totalInstanceCount;
    }

    public final Integer availableInstanceCount() {
        return this.availableInstanceCount;
    }

    public final Integer usedByCurrentEndpoint() {
        return this.usedByCurrentEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2CapacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.usedByCurrentEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2CapacityReservation)) {
            return false;
        }
        Ec2CapacityReservation other = (Ec2CapacityReservation)obj;
        return Objects.equals(this.ec2CapacityReservationId(), other.ec2CapacityReservationId()) && Objects.equals(this.totalInstanceCount(), other.totalInstanceCount()) && Objects.equals(this.availableInstanceCount(), other.availableInstanceCount()) && Objects.equals(this.usedByCurrentEndpoint(), other.usedByCurrentEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"Ec2CapacityReservation").add("Ec2CapacityReservationId", (Object)this.ec2CapacityReservationId()).add("TotalInstanceCount", (Object)this.totalInstanceCount()).add("AvailableInstanceCount", (Object)this.availableInstanceCount()).add("UsedByCurrentEndpoint", (Object)this.usedByCurrentEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ec2CapacityReservationId": {
                return Optional.ofNullable(clazz.cast(this.ec2CapacityReservationId()));
            }
            case "TotalInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.totalInstanceCount()));
            }
            case "AvailableInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.availableInstanceCount()));
            }
            case "UsedByCurrentEndpoint": {
                return Optional.ofNullable(clazz.cast(this.usedByCurrentEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Ec2CapacityReservationId", EC2_CAPACITY_RESERVATION_ID_FIELD);
        map.put("TotalInstanceCount", TOTAL_INSTANCE_COUNT_FIELD);
        map.put("AvailableInstanceCount", AVAILABLE_INSTANCE_COUNT_FIELD);
        map.put("UsedByCurrentEndpoint", USED_BY_CURRENT_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ec2CapacityReservation, T> g) {
        return obj -> g.apply((Ec2CapacityReservation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ec2CapacityReservationId;
        private Integer totalInstanceCount;
        private Integer availableInstanceCount;
        private Integer usedByCurrentEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2CapacityReservation model) {
            this.ec2CapacityReservationId(model.ec2CapacityReservationId);
            this.totalInstanceCount(model.totalInstanceCount);
            this.availableInstanceCount(model.availableInstanceCount);
            this.usedByCurrentEndpoint(model.usedByCurrentEndpoint);
        }

        public final String getEc2CapacityReservationId() {
            return this.ec2CapacityReservationId;
        }

        public final void setEc2CapacityReservationId(String ec2CapacityReservationId) {
            this.ec2CapacityReservationId = ec2CapacityReservationId;
        }

        @Override
        public final Builder ec2CapacityReservationId(String ec2CapacityReservationId) {
            this.ec2CapacityReservationId = ec2CapacityReservationId;
            return this;
        }

        public final Integer getTotalInstanceCount() {
            return this.totalInstanceCount;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final Integer getAvailableInstanceCount() {
            return this.availableInstanceCount;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final Integer getUsedByCurrentEndpoint() {
            return this.usedByCurrentEndpoint;
        }

        public final void setUsedByCurrentEndpoint(Integer usedByCurrentEndpoint) {
            this.usedByCurrentEndpoint = usedByCurrentEndpoint;
        }

        @Override
        public final Builder usedByCurrentEndpoint(Integer usedByCurrentEndpoint) {
            this.usedByCurrentEndpoint = usedByCurrentEndpoint;
            return this;
        }

        public Ec2CapacityReservation build() {
            return new Ec2CapacityReservation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ec2CapacityReservation> {
        public Builder ec2CapacityReservationId(String var1);

        public Builder totalInstanceCount(Integer var1);

        public Builder availableInstanceCount(Integer var1);

        public Builder usedByCurrentEndpoint(Integer var1);
    }
}

