/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.MonitoringExecutionSummary;
import software.amazon.awssdk.services.sagemaker.model.MonitoringScheduleConfig;
import software.amazon.awssdk.services.sagemaker.model.MonitoringType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.ScheduleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMonitoringScheduleResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeMonitoringScheduleResponse> {
    private static final SdkField<String> MONITORING_SCHEDULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringScheduleArn").getter(DescribeMonitoringScheduleResponse.getter(DescribeMonitoringScheduleResponse::monitoringScheduleArn)).setter(DescribeMonitoringScheduleResponse.setter(Builder::monitoringScheduleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleArn").build()}).build();
    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringScheduleName").getter(DescribeMonitoringScheduleResponse.getter(DescribeMonitoringScheduleResponse::monitoringScheduleName)).setter(DescribeMonitoringScheduleResponse.setter(Builder::monitoringScheduleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build()}).build();
    private static final SdkField<String> MONITORING_SCHEDULE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringScheduleStatus").getter(DescribeMonitoringScheduleResponse.getter(DescribeMonitoringScheduleResponse::monitoringScheduleStatusAsString)).setter(DescribeMonitoringScheduleResponse.setter(Builder::monitoringScheduleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleStatus").build()}).build();
    private static final SdkField<String> MONITORING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringType").getter(DescribeMonitoringScheduleResponse.getter(DescribeMonitoringScheduleResponse::monitoringTypeAsString)).setter(DescribeMonitoringScheduleResponse.setter(Builder::monitoringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringType").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeMonitoringScheduleResponse.getter(DescribeMonitoringScheduleResponse::failureReason)).setter(DescribeMonitoringScheduleResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeMonitoringScheduleResponse.getter(DescribeMonitoringScheduleResponse::creationTime)).setter(DescribeMonitoringScheduleResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeMonitoringScheduleResponse.getter(DescribeMonitoringScheduleResponse::lastModifiedTime)).setter(DescribeMonitoringScheduleResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<MonitoringScheduleConfig> MONITORING_SCHEDULE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MonitoringScheduleConfig").getter(DescribeMonitoringScheduleResponse.getter(DescribeMonitoringScheduleResponse::monitoringScheduleConfig)).setter(DescribeMonitoringScheduleResponse.setter(Builder::monitoringScheduleConfig)).constructor(MonitoringScheduleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleConfig").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(DescribeMonitoringScheduleResponse.getter(DescribeMonitoringScheduleResponse::endpointName)).setter(DescribeMonitoringScheduleResponse.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<MonitoringExecutionSummary> LAST_MONITORING_EXECUTION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastMonitoringExecutionSummary").getter(DescribeMonitoringScheduleResponse.getter(DescribeMonitoringScheduleResponse::lastMonitoringExecutionSummary)).setter(DescribeMonitoringScheduleResponse.setter(Builder::lastMonitoringExecutionSummary)).constructor(MonitoringExecutionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastMonitoringExecutionSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_SCHEDULE_ARN_FIELD, MONITORING_SCHEDULE_NAME_FIELD, MONITORING_SCHEDULE_STATUS_FIELD, MONITORING_TYPE_FIELD, FAILURE_REASON_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, MONITORING_SCHEDULE_CONFIG_FIELD, ENDPOINT_NAME_FIELD, LAST_MONITORING_EXECUTION_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMonitoringScheduleResponse.memberNameToFieldInitializer();
    private final String monitoringScheduleArn;
    private final String monitoringScheduleName;
    private final String monitoringScheduleStatus;
    private final String monitoringType;
    private final String failureReason;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final MonitoringScheduleConfig monitoringScheduleConfig;
    private final String endpointName;
    private final MonitoringExecutionSummary lastMonitoringExecutionSummary;

    private DescribeMonitoringScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.monitoringScheduleArn = builder.monitoringScheduleArn;
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.monitoringScheduleStatus = builder.monitoringScheduleStatus;
        this.monitoringType = builder.monitoringType;
        this.failureReason = builder.failureReason;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.monitoringScheduleConfig = builder.monitoringScheduleConfig;
        this.endpointName = builder.endpointName;
        this.lastMonitoringExecutionSummary = builder.lastMonitoringExecutionSummary;
    }

    public final String monitoringScheduleArn() {
        return this.monitoringScheduleArn;
    }

    public final String monitoringScheduleName() {
        return this.monitoringScheduleName;
    }

    public final ScheduleStatus monitoringScheduleStatus() {
        return ScheduleStatus.fromValue(this.monitoringScheduleStatus);
    }

    public final String monitoringScheduleStatusAsString() {
        return this.monitoringScheduleStatus;
    }

    public final MonitoringType monitoringType() {
        return MonitoringType.fromValue(this.monitoringType);
    }

    public final String monitoringTypeAsString() {
        return this.monitoringType;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final MonitoringScheduleConfig monitoringScheduleConfig() {
        return this.monitoringScheduleConfig;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final MonitoringExecutionSummary lastMonitoringExecutionSummary() {
        return this.lastMonitoringExecutionSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringScheduleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringScheduleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringScheduleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastMonitoringExecutionSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMonitoringScheduleResponse)) {
            return false;
        }
        DescribeMonitoringScheduleResponse other = (DescribeMonitoringScheduleResponse)((Object)obj);
        return Objects.equals(this.monitoringScheduleArn(), other.monitoringScheduleArn()) && Objects.equals(this.monitoringScheduleName(), other.monitoringScheduleName()) && Objects.equals(this.monitoringScheduleStatusAsString(), other.monitoringScheduleStatusAsString()) && Objects.equals(this.monitoringTypeAsString(), other.monitoringTypeAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.monitoringScheduleConfig(), other.monitoringScheduleConfig()) && Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.lastMonitoringExecutionSummary(), other.lastMonitoringExecutionSummary());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMonitoringScheduleResponse").add("MonitoringScheduleArn", (Object)this.monitoringScheduleArn()).add("MonitoringScheduleName", (Object)this.monitoringScheduleName()).add("MonitoringScheduleStatus", (Object)this.monitoringScheduleStatusAsString()).add("MonitoringType", (Object)this.monitoringTypeAsString()).add("FailureReason", (Object)this.failureReason()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("MonitoringScheduleConfig", (Object)this.monitoringScheduleConfig()).add("EndpointName", (Object)this.endpointName()).add("LastMonitoringExecutionSummary", (Object)this.lastMonitoringExecutionSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoringScheduleArn": {
                return Optional.ofNullable(clazz.cast(this.monitoringScheduleArn()));
            }
            case "MonitoringScheduleName": {
                return Optional.ofNullable(clazz.cast(this.monitoringScheduleName()));
            }
            case "MonitoringScheduleStatus": {
                return Optional.ofNullable(clazz.cast(this.monitoringScheduleStatusAsString()));
            }
            case "MonitoringType": {
                return Optional.ofNullable(clazz.cast(this.monitoringTypeAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "MonitoringScheduleConfig": {
                return Optional.ofNullable(clazz.cast(this.monitoringScheduleConfig()));
            }
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "LastMonitoringExecutionSummary": {
                return Optional.ofNullable(clazz.cast(this.lastMonitoringExecutionSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MonitoringScheduleArn", MONITORING_SCHEDULE_ARN_FIELD);
        map.put("MonitoringScheduleName", MONITORING_SCHEDULE_NAME_FIELD);
        map.put("MonitoringScheduleStatus", MONITORING_SCHEDULE_STATUS_FIELD);
        map.put("MonitoringType", MONITORING_TYPE_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("MonitoringScheduleConfig", MONITORING_SCHEDULE_CONFIG_FIELD);
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("LastMonitoringExecutionSummary", LAST_MONITORING_EXECUTION_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMonitoringScheduleResponse, T> g) {
        return obj -> g.apply((DescribeMonitoringScheduleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String monitoringScheduleArn;
        private String monitoringScheduleName;
        private String monitoringScheduleStatus;
        private String monitoringType;
        private String failureReason;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private MonitoringScheduleConfig monitoringScheduleConfig;
        private String endpointName;
        private MonitoringExecutionSummary lastMonitoringExecutionSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMonitoringScheduleResponse model) {
            super(model);
            this.monitoringScheduleArn(model.monitoringScheduleArn);
            this.monitoringScheduleName(model.monitoringScheduleName);
            this.monitoringScheduleStatus(model.monitoringScheduleStatus);
            this.monitoringType(model.monitoringType);
            this.failureReason(model.failureReason);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.monitoringScheduleConfig(model.monitoringScheduleConfig);
            this.endpointName(model.endpointName);
            this.lastMonitoringExecutionSummary(model.lastMonitoringExecutionSummary);
        }

        public final String getMonitoringScheduleArn() {
            return this.monitoringScheduleArn;
        }

        public final void setMonitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
        }

        @Override
        public final Builder monitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
            return this;
        }

        public final String getMonitoringScheduleName() {
            return this.monitoringScheduleName;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final String getMonitoringScheduleStatus() {
            return this.monitoringScheduleStatus;
        }

        public final void setMonitoringScheduleStatus(String monitoringScheduleStatus) {
            this.monitoringScheduleStatus = monitoringScheduleStatus;
        }

        @Override
        public final Builder monitoringScheduleStatus(String monitoringScheduleStatus) {
            this.monitoringScheduleStatus = monitoringScheduleStatus;
            return this;
        }

        @Override
        public final Builder monitoringScheduleStatus(ScheduleStatus monitoringScheduleStatus) {
            this.monitoringScheduleStatus(monitoringScheduleStatus == null ? null : monitoringScheduleStatus.toString());
            return this;
        }

        public final String getMonitoringType() {
            return this.monitoringType;
        }

        public final void setMonitoringType(String monitoringType) {
            this.monitoringType = monitoringType;
        }

        @Override
        public final Builder monitoringType(String monitoringType) {
            this.monitoringType = monitoringType;
            return this;
        }

        @Override
        public final Builder monitoringType(MonitoringType monitoringType) {
            this.monitoringType(monitoringType == null ? null : monitoringType.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final MonitoringScheduleConfig.Builder getMonitoringScheduleConfig() {
            return this.monitoringScheduleConfig != null ? this.monitoringScheduleConfig.toBuilder() : null;
        }

        public final void setMonitoringScheduleConfig(MonitoringScheduleConfig.BuilderImpl monitoringScheduleConfig) {
            this.monitoringScheduleConfig = monitoringScheduleConfig != null ? monitoringScheduleConfig.build() : null;
        }

        @Override
        public final Builder monitoringScheduleConfig(MonitoringScheduleConfig monitoringScheduleConfig) {
            this.monitoringScheduleConfig = monitoringScheduleConfig;
            return this;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final MonitoringExecutionSummary.Builder getLastMonitoringExecutionSummary() {
            return this.lastMonitoringExecutionSummary != null ? this.lastMonitoringExecutionSummary.toBuilder() : null;
        }

        public final void setLastMonitoringExecutionSummary(MonitoringExecutionSummary.BuilderImpl lastMonitoringExecutionSummary) {
            this.lastMonitoringExecutionSummary = lastMonitoringExecutionSummary != null ? lastMonitoringExecutionSummary.build() : null;
        }

        @Override
        public final Builder lastMonitoringExecutionSummary(MonitoringExecutionSummary lastMonitoringExecutionSummary) {
            this.lastMonitoringExecutionSummary = lastMonitoringExecutionSummary;
            return this;
        }

        @Override
        public DescribeMonitoringScheduleResponse build() {
            return new DescribeMonitoringScheduleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMonitoringScheduleResponse> {
        public Builder monitoringScheduleArn(String var1);

        public Builder monitoringScheduleName(String var1);

        public Builder monitoringScheduleStatus(String var1);

        public Builder monitoringScheduleStatus(ScheduleStatus var1);

        public Builder monitoringType(String var1);

        public Builder monitoringType(MonitoringType var1);

        public Builder failureReason(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder monitoringScheduleConfig(MonitoringScheduleConfig var1);

        default public Builder monitoringScheduleConfig(Consumer<MonitoringScheduleConfig.Builder> monitoringScheduleConfig) {
            return this.monitoringScheduleConfig((MonitoringScheduleConfig)((MonitoringScheduleConfig.Builder)MonitoringScheduleConfig.builder().applyMutation(monitoringScheduleConfig)).build());
        }

        public Builder endpointName(String var1);

        public Builder lastMonitoringExecutionSummary(MonitoringExecutionSummary var1);

        default public Builder lastMonitoringExecutionSummary(Consumer<MonitoringExecutionSummary.Builder> lastMonitoringExecutionSummary) {
            return this.lastMonitoringExecutionSummary((MonitoringExecutionSummary)((MonitoringExecutionSummary.Builder)MonitoringExecutionSummary.builder().applyMutation(lastMonitoringExecutionSummary)).build());
        }
    }
}

