/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ComputeQuotaResourceConfig;
import software.amazon.awssdk.services.sagemaker.model.ComputeQuotaResourceConfigListCopier;
import software.amazon.awssdk.services.sagemaker.model.PreemptTeamTasks;
import software.amazon.awssdk.services.sagemaker.model.ResourceSharingConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputeQuotaConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputeQuotaConfig> {
    private static final SdkField<List<ComputeQuotaResourceConfig>> COMPUTE_QUOTA_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ComputeQuotaResources").getter(ComputeQuotaConfig.getter(ComputeQuotaConfig::computeQuotaResources)).setter(ComputeQuotaConfig.setter(Builder::computeQuotaResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComputeQuotaResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ResourceSharingConfig> RESOURCE_SHARING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceSharingConfig").getter(ComputeQuotaConfig.getter(ComputeQuotaConfig::resourceSharingConfig)).setter(ComputeQuotaConfig.setter(Builder::resourceSharingConfig)).constructor(ResourceSharingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSharingConfig").build()}).build();
    private static final SdkField<String> PREEMPT_TEAM_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreemptTeamTasks").getter(ComputeQuotaConfig.getter(ComputeQuotaConfig::preemptTeamTasksAsString)).setter(ComputeQuotaConfig.setter(Builder::preemptTeamTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreemptTeamTasks").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_QUOTA_RESOURCES_FIELD, RESOURCE_SHARING_CONFIG_FIELD, PREEMPT_TEAM_TASKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComputeQuotaConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ComputeQuotaResourceConfig> computeQuotaResources;
    private final ResourceSharingConfig resourceSharingConfig;
    private final String preemptTeamTasks;

    private ComputeQuotaConfig(BuilderImpl builder) {
        this.computeQuotaResources = builder.computeQuotaResources;
        this.resourceSharingConfig = builder.resourceSharingConfig;
        this.preemptTeamTasks = builder.preemptTeamTasks;
    }

    public final boolean hasComputeQuotaResources() {
        return this.computeQuotaResources != null && !(this.computeQuotaResources instanceof SdkAutoConstructList);
    }

    public final List<ComputeQuotaResourceConfig> computeQuotaResources() {
        return this.computeQuotaResources;
    }

    public final ResourceSharingConfig resourceSharingConfig() {
        return this.resourceSharingConfig;
    }

    public final PreemptTeamTasks preemptTeamTasks() {
        return PreemptTeamTasks.fromValue(this.preemptTeamTasks);
    }

    public final String preemptTeamTasksAsString() {
        return this.preemptTeamTasks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputeQuotaResources() ? this.computeQuotaResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSharingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.preemptTeamTasksAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeQuotaConfig)) {
            return false;
        }
        ComputeQuotaConfig other = (ComputeQuotaConfig)obj;
        return this.hasComputeQuotaResources() == other.hasComputeQuotaResources() && Objects.equals(this.computeQuotaResources(), other.computeQuotaResources()) && Objects.equals(this.resourceSharingConfig(), other.resourceSharingConfig()) && Objects.equals(this.preemptTeamTasksAsString(), other.preemptTeamTasksAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ComputeQuotaConfig").add("ComputeQuotaResources", this.hasComputeQuotaResources() ? this.computeQuotaResources() : null).add("ResourceSharingConfig", (Object)this.resourceSharingConfig()).add("PreemptTeamTasks", (Object)this.preemptTeamTasksAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComputeQuotaResources": {
                return Optional.ofNullable(clazz.cast(this.computeQuotaResources()));
            }
            case "ResourceSharingConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceSharingConfig()));
            }
            case "PreemptTeamTasks": {
                return Optional.ofNullable(clazz.cast(this.preemptTeamTasksAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ComputeQuotaResources", COMPUTE_QUOTA_RESOURCES_FIELD);
        map.put("ResourceSharingConfig", RESOURCE_SHARING_CONFIG_FIELD);
        map.put("PreemptTeamTasks", PREEMPT_TEAM_TASKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeQuotaConfig, T> g) {
        return obj -> g.apply((ComputeQuotaConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ComputeQuotaResourceConfig> computeQuotaResources = DefaultSdkAutoConstructList.getInstance();
        private ResourceSharingConfig resourceSharingConfig;
        private String preemptTeamTasks;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeQuotaConfig model) {
            this.computeQuotaResources(model.computeQuotaResources);
            this.resourceSharingConfig(model.resourceSharingConfig);
            this.preemptTeamTasks(model.preemptTeamTasks);
        }

        public final List<ComputeQuotaResourceConfig.Builder> getComputeQuotaResources() {
            List<ComputeQuotaResourceConfig.Builder> result = ComputeQuotaResourceConfigListCopier.copyToBuilder(this.computeQuotaResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputeQuotaResources(Collection<ComputeQuotaResourceConfig.BuilderImpl> computeQuotaResources) {
            this.computeQuotaResources = ComputeQuotaResourceConfigListCopier.copyFromBuilder(computeQuotaResources);
        }

        @Override
        public final Builder computeQuotaResources(Collection<ComputeQuotaResourceConfig> computeQuotaResources) {
            this.computeQuotaResources = ComputeQuotaResourceConfigListCopier.copy(computeQuotaResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeQuotaResources(ComputeQuotaResourceConfig ... computeQuotaResources) {
            this.computeQuotaResources(Arrays.asList(computeQuotaResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeQuotaResources(Consumer<ComputeQuotaResourceConfig.Builder> ... computeQuotaResources) {
            this.computeQuotaResources(Stream.of(computeQuotaResources).map(c -> (ComputeQuotaResourceConfig)((ComputeQuotaResourceConfig.Builder)ComputeQuotaResourceConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ResourceSharingConfig.Builder getResourceSharingConfig() {
            return this.resourceSharingConfig != null ? this.resourceSharingConfig.toBuilder() : null;
        }

        public final void setResourceSharingConfig(ResourceSharingConfig.BuilderImpl resourceSharingConfig) {
            this.resourceSharingConfig = resourceSharingConfig != null ? resourceSharingConfig.build() : null;
        }

        @Override
        public final Builder resourceSharingConfig(ResourceSharingConfig resourceSharingConfig) {
            this.resourceSharingConfig = resourceSharingConfig;
            return this;
        }

        public final String getPreemptTeamTasks() {
            return this.preemptTeamTasks;
        }

        public final void setPreemptTeamTasks(String preemptTeamTasks) {
            this.preemptTeamTasks = preemptTeamTasks;
        }

        @Override
        public final Builder preemptTeamTasks(String preemptTeamTasks) {
            this.preemptTeamTasks = preemptTeamTasks;
            return this;
        }

        @Override
        public final Builder preemptTeamTasks(PreemptTeamTasks preemptTeamTasks) {
            this.preemptTeamTasks(preemptTeamTasks == null ? null : preemptTeamTasks.toString());
            return this;
        }

        public ComputeQuotaConfig build() {
            return new ComputeQuotaConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputeQuotaConfig> {
        public Builder computeQuotaResources(Collection<ComputeQuotaResourceConfig> var1);

        public Builder computeQuotaResources(ComputeQuotaResourceConfig ... var1);

        public Builder computeQuotaResources(Consumer<ComputeQuotaResourceConfig.Builder> ... var1);

        public Builder resourceSharingConfig(ResourceSharingConfig var1);

        default public Builder resourceSharingConfig(Consumer<ResourceSharingConfig.Builder> resourceSharingConfig) {
            return this.resourceSharingConfig((ResourceSharingConfig)((ResourceSharingConfig.Builder)ResourceSharingConfig.builder().applyMutation(resourceSharingConfig)).build());
        }

        public Builder preemptTeamTasks(String var1);

        public Builder preemptTeamTasks(PreemptTeamTasks var1);
    }
}

