/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClusterInstanceStatus {
    RUNNING("Running"),
    FAILURE("Failure"),
    PENDING("Pending"),
    SHUTTING_DOWN("ShuttingDown"),
    SYSTEM_UPDATING("SystemUpdating"),
    DEEP_HEALTH_CHECK_IN_PROGRESS("DeepHealthCheckInProgress"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClusterInstanceStatus> VALUE_MAP;
    private final String value;

    private ClusterInstanceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClusterInstanceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClusterInstanceStatus> knownValues() {
        EnumSet<ClusterInstanceStatus> knownValues = EnumSet.allOf(ClusterInstanceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClusterInstanceStatus.class, ClusterInstanceStatus::toString);
    }
}

