/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.LineageType;
import software.amazon.awssdk.services.sagemaker.model.QueryLineageTypesCopier;
import software.amazon.awssdk.services.sagemaker.model.QueryPropertiesCopier;
import software.amazon.awssdk.services.sagemaker.model.QueryTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryFilters> {
    private static final SdkField<List<String>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Types").getter(QueryFilters.getter(QueryFilters::types)).setter(QueryFilters.setter(Builder::types)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LINEAGE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LineageTypes").getter(QueryFilters.getter(QueryFilters::lineageTypesAsStrings)).setter(QueryFilters.setter(Builder::lineageTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineageTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedBefore").getter(QueryFilters.getter(QueryFilters::createdBefore)).setter(QueryFilters.setter(Builder::createdBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").build()}).build();
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAfter").getter(QueryFilters.getter(QueryFilters::createdAfter)).setter(QueryFilters.setter(Builder::createdAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").build()}).build();
    private static final SdkField<Instant> MODIFIED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedBefore").getter(QueryFilters.getter(QueryFilters::modifiedBefore)).setter(QueryFilters.setter(Builder::modifiedBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedBefore").build()}).build();
    private static final SdkField<Instant> MODIFIED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedAfter").getter(QueryFilters.getter(QueryFilters::modifiedAfter)).setter(QueryFilters.setter(Builder::modifiedAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAfter").build()}).build();
    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Properties").getter(QueryFilters.getter(QueryFilters::properties)).setter(QueryFilters.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPES_FIELD, LINEAGE_TYPES_FIELD, CREATED_BEFORE_FIELD, CREATED_AFTER_FIELD, MODIFIED_BEFORE_FIELD, MODIFIED_AFTER_FIELD, PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> types;
    private final List<String> lineageTypes;
    private final Instant createdBefore;
    private final Instant createdAfter;
    private final Instant modifiedBefore;
    private final Instant modifiedAfter;
    private final Map<String, String> properties;

    private QueryFilters(BuilderImpl builder) {
        this.types = builder.types;
        this.lineageTypes = builder.lineageTypes;
        this.createdBefore = builder.createdBefore;
        this.createdAfter = builder.createdAfter;
        this.modifiedBefore = builder.modifiedBefore;
        this.modifiedAfter = builder.modifiedAfter;
        this.properties = builder.properties;
    }

    public final boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public final List<String> types() {
        return this.types;
    }

    public final List<LineageType> lineageTypes() {
        return QueryLineageTypesCopier.copyStringToEnum(this.lineageTypes);
    }

    public final boolean hasLineageTypes() {
        return this.lineageTypes != null && !(this.lineageTypes instanceof SdkAutoConstructList);
    }

    public final List<String> lineageTypesAsStrings() {
        return this.lineageTypes;
    }

    public final Instant createdBefore() {
        return this.createdBefore;
    }

    public final Instant createdAfter() {
        return this.createdAfter;
    }

    public final Instant modifiedBefore() {
        return this.modifiedBefore;
    }

    public final Instant modifiedAfter() {
        return this.modifiedAfter;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.types() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLineageTypes() ? this.lineageTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryFilters)) {
            return false;
        }
        QueryFilters other = (QueryFilters)obj;
        return this.hasTypes() == other.hasTypes() && Objects.equals(this.types(), other.types()) && this.hasLineageTypes() == other.hasLineageTypes() && Objects.equals(this.lineageTypesAsStrings(), other.lineageTypesAsStrings()) && Objects.equals(this.createdBefore(), other.createdBefore()) && Objects.equals(this.createdAfter(), other.createdAfter()) && Objects.equals(this.modifiedBefore(), other.modifiedBefore()) && Objects.equals(this.modifiedAfter(), other.modifiedAfter()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"QueryFilters").add("Types", this.hasTypes() ? this.types() : null).add("LineageTypes", this.hasLineageTypes() ? this.lineageTypesAsStrings() : null).add("CreatedBefore", (Object)this.createdBefore()).add("CreatedAfter", (Object)this.createdAfter()).add("ModifiedBefore", (Object)this.modifiedBefore()).add("ModifiedAfter", (Object)this.modifiedAfter()).add("Properties", this.hasProperties() ? this.properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Types": {
                return Optional.ofNullable(clazz.cast(this.types()));
            }
            case "LineageTypes": {
                return Optional.ofNullable(clazz.cast(this.lineageTypesAsStrings()));
            }
            case "CreatedBefore": {
                return Optional.ofNullable(clazz.cast(this.createdBefore()));
            }
            case "CreatedAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAfter()));
            }
            case "ModifiedBefore": {
                return Optional.ofNullable(clazz.cast(this.modifiedBefore()));
            }
            case "ModifiedAfter": {
                return Optional.ofNullable(clazz.cast(this.modifiedAfter()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Types", TYPES_FIELD);
        map.put("LineageTypes", LINEAGE_TYPES_FIELD);
        map.put("CreatedBefore", CREATED_BEFORE_FIELD);
        map.put("CreatedAfter", CREATED_AFTER_FIELD);
        map.put("ModifiedBefore", MODIFIED_BEFORE_FIELD);
        map.put("ModifiedAfter", MODIFIED_AFTER_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryFilters, T> g) {
        return obj -> g.apply((QueryFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> types = DefaultSdkAutoConstructList.getInstance();
        private List<String> lineageTypes = DefaultSdkAutoConstructList.getInstance();
        private Instant createdBefore;
        private Instant createdAfter;
        private Instant modifiedBefore;
        private Instant modifiedAfter;
        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryFilters model) {
            this.types(model.types);
            this.lineageTypesWithStrings(model.lineageTypes);
            this.createdBefore(model.createdBefore);
            this.createdAfter(model.createdAfter);
            this.modifiedBefore(model.modifiedBefore);
            this.modifiedAfter(model.modifiedAfter);
            this.properties(model.properties);
        }

        public final Collection<String> getTypes() {
            if (this.types instanceof SdkAutoConstructList) {
                return null;
            }
            return this.types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = QueryTypesCopier.copy(types);
        }

        @Override
        public final Builder types(Collection<String> types) {
            this.types = QueryTypesCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(String ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        public final Collection<String> getLineageTypes() {
            if (this.lineageTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lineageTypes;
        }

        public final void setLineageTypes(Collection<String> lineageTypes) {
            this.lineageTypes = QueryLineageTypesCopier.copy(lineageTypes);
        }

        @Override
        public final Builder lineageTypesWithStrings(Collection<String> lineageTypes) {
            this.lineageTypes = QueryLineageTypesCopier.copy(lineageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineageTypesWithStrings(String ... lineageTypes) {
            this.lineageTypesWithStrings(Arrays.asList(lineageTypes));
            return this;
        }

        @Override
        public final Builder lineageTypes(Collection<LineageType> lineageTypes) {
            this.lineageTypes = QueryLineageTypesCopier.copyEnumToString(lineageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineageTypes(LineageType ... lineageTypes) {
            this.lineageTypes(Arrays.asList(lineageTypes));
            return this;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final Instant getModifiedBefore() {
            return this.modifiedBefore;
        }

        public final void setModifiedBefore(Instant modifiedBefore) {
            this.modifiedBefore = modifiedBefore;
        }

        @Override
        public final Builder modifiedBefore(Instant modifiedBefore) {
            this.modifiedBefore = modifiedBefore;
            return this;
        }

        public final Instant getModifiedAfter() {
            return this.modifiedAfter;
        }

        public final void setModifiedAfter(Instant modifiedAfter) {
            this.modifiedAfter = modifiedAfter;
        }

        @Override
        public final Builder modifiedAfter(Instant modifiedAfter) {
            this.modifiedAfter = modifiedAfter;
            return this;
        }

        public final Map<String, String> getProperties() {
            if (this.properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = QueryPropertiesCopier.copy(properties);
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = QueryPropertiesCopier.copy(properties);
            return this;
        }

        public QueryFilters build() {
            return new QueryFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryFilters> {
        public Builder types(Collection<String> var1);

        public Builder types(String ... var1);

        public Builder lineageTypesWithStrings(Collection<String> var1);

        public Builder lineageTypesWithStrings(String ... var1);

        public Builder lineageTypes(Collection<LineageType> var1);

        public Builder lineageTypes(LineageType ... var1);

        public Builder createdBefore(Instant var1);

        public Builder createdAfter(Instant var1);

        public Builder modifiedBefore(Instant var1);

        public Builder modifiedAfter(Instant var1);

        public Builder properties(Map<String, String> var1);
    }
}

