/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.TrainingPlanFilter;
import software.amazon.awssdk.services.sagemaker.model.TrainingPlanFiltersCopier;
import software.amazon.awssdk.services.sagemaker.model.TrainingPlanSortBy;
import software.amazon.awssdk.services.sagemaker.model.TrainingPlanSortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrainingPlansRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListTrainingPlansRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTrainingPlansRequest.getter(ListTrainingPlansRequest::nextToken)).setter(ListTrainingPlansRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListTrainingPlansRequest.getter(ListTrainingPlansRequest::maxResults)).setter(ListTrainingPlansRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<Instant> START_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTimeAfter").getter(ListTrainingPlansRequest.getter(ListTrainingPlansRequest::startTimeAfter)).setter(ListTrainingPlansRequest.setter(Builder::startTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeAfter").build()}).build();
    private static final SdkField<Instant> START_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTimeBefore").getter(ListTrainingPlansRequest.getter(ListTrainingPlansRequest::startTimeBefore)).setter(ListTrainingPlansRequest.setter(Builder::startTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeBefore").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(ListTrainingPlansRequest.getter(ListTrainingPlansRequest::sortByAsString)).setter(ListTrainingPlansRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListTrainingPlansRequest.getter(ListTrainingPlansRequest::sortOrderAsString)).setter(ListTrainingPlansRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<List<TrainingPlanFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(ListTrainingPlansRequest.getter(ListTrainingPlansRequest::filters)).setter(ListTrainingPlansRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrainingPlanFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, START_TIME_AFTER_FIELD, START_TIME_BEFORE_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTrainingPlansRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer maxResults;
    private final Instant startTimeAfter;
    private final Instant startTimeBefore;
    private final String sortBy;
    private final String sortOrder;
    private final List<TrainingPlanFilter> filters;

    private ListTrainingPlansRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.startTimeAfter = builder.startTimeAfter;
        this.startTimeBefore = builder.startTimeBefore;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.filters = builder.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Instant startTimeAfter() {
        return this.startTimeAfter;
    }

    public final Instant startTimeBefore() {
        return this.startTimeBefore;
    }

    public final TrainingPlanSortBy sortBy() {
        return TrainingPlanSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final TrainingPlanSortOrder sortOrder() {
        return TrainingPlanSortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<TrainingPlanFilter> filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrainingPlansRequest)) {
            return false;
        }
        ListTrainingPlansRequest other = (ListTrainingPlansRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.startTimeAfter(), other.startTimeAfter()) && Objects.equals(this.startTimeBefore(), other.startTimeBefore()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrainingPlansRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("StartTimeAfter", (Object)this.startTimeAfter()).add("StartTimeBefore", (Object)this.startTimeBefore()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("Filters", this.hasFilters() ? this.filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "StartTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.startTimeAfter()));
            }
            case "StartTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.startTimeBefore()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("StartTimeAfter", START_TIME_AFTER_FIELD);
        map.put("StartTimeBefore", START_TIME_BEFORE_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        map.put("Filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrainingPlansRequest, T> g) {
        return obj -> g.apply((ListTrainingPlansRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private Instant startTimeAfter;
        private Instant startTimeBefore;
        private String sortBy;
        private String sortOrder;
        private List<TrainingPlanFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrainingPlansRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.startTimeAfter(model.startTimeAfter);
            this.startTimeBefore(model.startTimeBefore);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.filters(model.filters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getStartTimeAfter() {
            return this.startTimeAfter;
        }

        public final void setStartTimeAfter(Instant startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
        }

        @Override
        public final Builder startTimeAfter(Instant startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
            return this;
        }

        public final Instant getStartTimeBefore() {
            return this.startTimeBefore;
        }

        public final void setStartTimeBefore(Instant startTimeBefore) {
            this.startTimeBefore = startTimeBefore;
        }

        @Override
        public final Builder startTimeBefore(Instant startTimeBefore) {
            this.startTimeBefore = startTimeBefore;
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(TrainingPlanSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(TrainingPlanSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final List<TrainingPlanFilter.Builder> getFilters() {
            List<TrainingPlanFilter.Builder> result = TrainingPlanFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<TrainingPlanFilter.BuilderImpl> filters) {
            this.filters = TrainingPlanFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<TrainingPlanFilter> filters) {
            this.filters = TrainingPlanFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(TrainingPlanFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<TrainingPlanFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (TrainingPlanFilter)((TrainingPlanFilter.Builder)TrainingPlanFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTrainingPlansRequest build() {
            return new ListTrainingPlansRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrainingPlansRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder startTimeAfter(Instant var1);

        public Builder startTimeBefore(Instant var1);

        public Builder sortBy(String var1);

        public Builder sortBy(TrainingPlanSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(TrainingPlanSortOrder var1);

        public Builder filters(Collection<TrainingPlanFilter> var1);

        public Builder filters(TrainingPlanFilter ... var1);

        public Builder filters(Consumer<TrainingPlanFilter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

