/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HubContentType {
    MODEL("Model"),
    NOTEBOOK("Notebook"),
    MODEL_REFERENCE("ModelReference"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HubContentType> VALUE_MAP;
    private final String value;

    private HubContentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HubContentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HubContentType> knownValues() {
        EnumSet<HubContentType> knownValues = EnumSet.allOf(HubContentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HubContentType.class, HubContentType::toString);
    }
}

