/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelExplainabilityAppSpecification;
import software.amazon.awssdk.services.sagemaker.model.ModelExplainabilityBaselineConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelExplainabilityJobInput;
import software.amazon.awssdk.services.sagemaker.model.MonitoringNetworkConfig;
import software.amazon.awssdk.services.sagemaker.model.MonitoringOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.MonitoringResources;
import software.amazon.awssdk.services.sagemaker.model.MonitoringStoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeModelExplainabilityJobDefinitionResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeModelExplainabilityJobDefinitionResponse> {
    private static final SdkField<String> JOB_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobDefinitionArn").getter(DescribeModelExplainabilityJobDefinitionResponse.getter(DescribeModelExplainabilityJobDefinitionResponse::jobDefinitionArn)).setter(DescribeModelExplainabilityJobDefinitionResponse.setter(Builder::jobDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionArn").build()}).build();
    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobDefinitionName").getter(DescribeModelExplainabilityJobDefinitionResponse.getter(DescribeModelExplainabilityJobDefinitionResponse::jobDefinitionName)).setter(DescribeModelExplainabilityJobDefinitionResponse.setter(Builder::jobDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeModelExplainabilityJobDefinitionResponse.getter(DescribeModelExplainabilityJobDefinitionResponse::creationTime)).setter(DescribeModelExplainabilityJobDefinitionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<ModelExplainabilityBaselineConfig> MODEL_EXPLAINABILITY_BASELINE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelExplainabilityBaselineConfig").getter(DescribeModelExplainabilityJobDefinitionResponse.getter(DescribeModelExplainabilityJobDefinitionResponse::modelExplainabilityBaselineConfig)).setter(DescribeModelExplainabilityJobDefinitionResponse.setter(Builder::modelExplainabilityBaselineConfig)).constructor(ModelExplainabilityBaselineConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelExplainabilityBaselineConfig").build()}).build();
    private static final SdkField<ModelExplainabilityAppSpecification> MODEL_EXPLAINABILITY_APP_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelExplainabilityAppSpecification").getter(DescribeModelExplainabilityJobDefinitionResponse.getter(DescribeModelExplainabilityJobDefinitionResponse::modelExplainabilityAppSpecification)).setter(DescribeModelExplainabilityJobDefinitionResponse.setter(Builder::modelExplainabilityAppSpecification)).constructor(ModelExplainabilityAppSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelExplainabilityAppSpecification").build()}).build();
    private static final SdkField<ModelExplainabilityJobInput> MODEL_EXPLAINABILITY_JOB_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelExplainabilityJobInput").getter(DescribeModelExplainabilityJobDefinitionResponse.getter(DescribeModelExplainabilityJobDefinitionResponse::modelExplainabilityJobInput)).setter(DescribeModelExplainabilityJobDefinitionResponse.setter(Builder::modelExplainabilityJobInput)).constructor(ModelExplainabilityJobInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelExplainabilityJobInput").build()}).build();
    private static final SdkField<MonitoringOutputConfig> MODEL_EXPLAINABILITY_JOB_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelExplainabilityJobOutputConfig").getter(DescribeModelExplainabilityJobDefinitionResponse.getter(DescribeModelExplainabilityJobDefinitionResponse::modelExplainabilityJobOutputConfig)).setter(DescribeModelExplainabilityJobDefinitionResponse.setter(Builder::modelExplainabilityJobOutputConfig)).constructor(MonitoringOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelExplainabilityJobOutputConfig").build()}).build();
    private static final SdkField<MonitoringResources> JOB_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobResources").getter(DescribeModelExplainabilityJobDefinitionResponse.getter(DescribeModelExplainabilityJobDefinitionResponse::jobResources)).setter(DescribeModelExplainabilityJobDefinitionResponse.setter(Builder::jobResources)).constructor(MonitoringResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobResources").build()}).build();
    private static final SdkField<MonitoringNetworkConfig> NETWORK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfig").getter(DescribeModelExplainabilityJobDefinitionResponse.getter(DescribeModelExplainabilityJobDefinitionResponse::networkConfig)).setter(DescribeModelExplainabilityJobDefinitionResponse.setter(Builder::networkConfig)).constructor(MonitoringNetworkConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeModelExplainabilityJobDefinitionResponse.getter(DescribeModelExplainabilityJobDefinitionResponse::roleArn)).setter(DescribeModelExplainabilityJobDefinitionResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<MonitoringStoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingCondition").getter(DescribeModelExplainabilityJobDefinitionResponse.getter(DescribeModelExplainabilityJobDefinitionResponse::stoppingCondition)).setter(DescribeModelExplainabilityJobDefinitionResponse.setter(Builder::stoppingCondition)).constructor(MonitoringStoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_ARN_FIELD, JOB_DEFINITION_NAME_FIELD, CREATION_TIME_FIELD, MODEL_EXPLAINABILITY_BASELINE_CONFIG_FIELD, MODEL_EXPLAINABILITY_APP_SPECIFICATION_FIELD, MODEL_EXPLAINABILITY_JOB_INPUT_FIELD, MODEL_EXPLAINABILITY_JOB_OUTPUT_CONFIG_FIELD, JOB_RESOURCES_FIELD, NETWORK_CONFIG_FIELD, ROLE_ARN_FIELD, STOPPING_CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeModelExplainabilityJobDefinitionResponse.memberNameToFieldInitializer();
    private final String jobDefinitionArn;
    private final String jobDefinitionName;
    private final Instant creationTime;
    private final ModelExplainabilityBaselineConfig modelExplainabilityBaselineConfig;
    private final ModelExplainabilityAppSpecification modelExplainabilityAppSpecification;
    private final ModelExplainabilityJobInput modelExplainabilityJobInput;
    private final MonitoringOutputConfig modelExplainabilityJobOutputConfig;
    private final MonitoringResources jobResources;
    private final MonitoringNetworkConfig networkConfig;
    private final String roleArn;
    private final MonitoringStoppingCondition stoppingCondition;

    private DescribeModelExplainabilityJobDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionArn = builder.jobDefinitionArn;
        this.jobDefinitionName = builder.jobDefinitionName;
        this.creationTime = builder.creationTime;
        this.modelExplainabilityBaselineConfig = builder.modelExplainabilityBaselineConfig;
        this.modelExplainabilityAppSpecification = builder.modelExplainabilityAppSpecification;
        this.modelExplainabilityJobInput = builder.modelExplainabilityJobInput;
        this.modelExplainabilityJobOutputConfig = builder.modelExplainabilityJobOutputConfig;
        this.jobResources = builder.jobResources;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
        this.stoppingCondition = builder.stoppingCondition;
    }

    public final String jobDefinitionArn() {
        return this.jobDefinitionArn;
    }

    public final String jobDefinitionName() {
        return this.jobDefinitionName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final ModelExplainabilityBaselineConfig modelExplainabilityBaselineConfig() {
        return this.modelExplainabilityBaselineConfig;
    }

    public final ModelExplainabilityAppSpecification modelExplainabilityAppSpecification() {
        return this.modelExplainabilityAppSpecification;
    }

    public final ModelExplainabilityJobInput modelExplainabilityJobInput() {
        return this.modelExplainabilityJobInput;
    }

    public final MonitoringOutputConfig modelExplainabilityJobOutputConfig() {
        return this.modelExplainabilityJobOutputConfig;
    }

    public final MonitoringResources jobResources() {
        return this.jobResources;
    }

    public final MonitoringNetworkConfig networkConfig() {
        return this.networkConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final MonitoringStoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelExplainabilityBaselineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelExplainabilityAppSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelExplainabilityJobInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelExplainabilityJobOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelExplainabilityJobDefinitionResponse)) {
            return false;
        }
        DescribeModelExplainabilityJobDefinitionResponse other = (DescribeModelExplainabilityJobDefinitionResponse)((Object)obj);
        return Objects.equals(this.jobDefinitionArn(), other.jobDefinitionArn()) && Objects.equals(this.jobDefinitionName(), other.jobDefinitionName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.modelExplainabilityBaselineConfig(), other.modelExplainabilityBaselineConfig()) && Objects.equals(this.modelExplainabilityAppSpecification(), other.modelExplainabilityAppSpecification()) && Objects.equals(this.modelExplainabilityJobInput(), other.modelExplainabilityJobInput()) && Objects.equals(this.modelExplainabilityJobOutputConfig(), other.modelExplainabilityJobOutputConfig()) && Objects.equals(this.jobResources(), other.jobResources()) && Objects.equals(this.networkConfig(), other.networkConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeModelExplainabilityJobDefinitionResponse").add("JobDefinitionArn", (Object)this.jobDefinitionArn()).add("JobDefinitionName", (Object)this.jobDefinitionName()).add("CreationTime", (Object)this.creationTime()).add("ModelExplainabilityBaselineConfig", (Object)this.modelExplainabilityBaselineConfig()).add("ModelExplainabilityAppSpecification", (Object)this.modelExplainabilityAppSpecification()).add("ModelExplainabilityJobInput", (Object)this.modelExplainabilityJobInput()).add("ModelExplainabilityJobOutputConfig", (Object)this.modelExplainabilityJobOutputConfig()).add("JobResources", (Object)this.jobResources()).add("NetworkConfig", (Object)this.networkConfig()).add("RoleArn", (Object)this.roleArn()).add("StoppingCondition", (Object)this.stoppingCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionArn()));
            }
            case "JobDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ModelExplainabilityBaselineConfig": {
                return Optional.ofNullable(clazz.cast(this.modelExplainabilityBaselineConfig()));
            }
            case "ModelExplainabilityAppSpecification": {
                return Optional.ofNullable(clazz.cast(this.modelExplainabilityAppSpecification()));
            }
            case "ModelExplainabilityJobInput": {
                return Optional.ofNullable(clazz.cast(this.modelExplainabilityJobInput()));
            }
            case "ModelExplainabilityJobOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.modelExplainabilityJobOutputConfig()));
            }
            case "JobResources": {
                return Optional.ofNullable(clazz.cast(this.jobResources()));
            }
            case "NetworkConfig": {
                return Optional.ofNullable(clazz.cast(this.networkConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobDefinitionArn", JOB_DEFINITION_ARN_FIELD);
        map.put("JobDefinitionName", JOB_DEFINITION_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ModelExplainabilityBaselineConfig", MODEL_EXPLAINABILITY_BASELINE_CONFIG_FIELD);
        map.put("ModelExplainabilityAppSpecification", MODEL_EXPLAINABILITY_APP_SPECIFICATION_FIELD);
        map.put("ModelExplainabilityJobInput", MODEL_EXPLAINABILITY_JOB_INPUT_FIELD);
        map.put("ModelExplainabilityJobOutputConfig", MODEL_EXPLAINABILITY_JOB_OUTPUT_CONFIG_FIELD);
        map.put("JobResources", JOB_RESOURCES_FIELD);
        map.put("NetworkConfig", NETWORK_CONFIG_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("StoppingCondition", STOPPING_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelExplainabilityJobDefinitionResponse, T> g) {
        return obj -> g.apply((DescribeModelExplainabilityJobDefinitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String jobDefinitionArn;
        private String jobDefinitionName;
        private Instant creationTime;
        private ModelExplainabilityBaselineConfig modelExplainabilityBaselineConfig;
        private ModelExplainabilityAppSpecification modelExplainabilityAppSpecification;
        private ModelExplainabilityJobInput modelExplainabilityJobInput;
        private MonitoringOutputConfig modelExplainabilityJobOutputConfig;
        private MonitoringResources jobResources;
        private MonitoringNetworkConfig networkConfig;
        private String roleArn;
        private MonitoringStoppingCondition stoppingCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelExplainabilityJobDefinitionResponse model) {
            super(model);
            this.jobDefinitionArn(model.jobDefinitionArn);
            this.jobDefinitionName(model.jobDefinitionName);
            this.creationTime(model.creationTime);
            this.modelExplainabilityBaselineConfig(model.modelExplainabilityBaselineConfig);
            this.modelExplainabilityAppSpecification(model.modelExplainabilityAppSpecification);
            this.modelExplainabilityJobInput(model.modelExplainabilityJobInput);
            this.modelExplainabilityJobOutputConfig(model.modelExplainabilityJobOutputConfig);
            this.jobResources(model.jobResources);
            this.networkConfig(model.networkConfig);
            this.roleArn(model.roleArn);
            this.stoppingCondition(model.stoppingCondition);
        }

        public final String getJobDefinitionArn() {
            return this.jobDefinitionArn;
        }

        public final void setJobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
        }

        @Override
        public final Builder jobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        public final String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ModelExplainabilityBaselineConfig.Builder getModelExplainabilityBaselineConfig() {
            return this.modelExplainabilityBaselineConfig != null ? this.modelExplainabilityBaselineConfig.toBuilder() : null;
        }

        public final void setModelExplainabilityBaselineConfig(ModelExplainabilityBaselineConfig.BuilderImpl modelExplainabilityBaselineConfig) {
            this.modelExplainabilityBaselineConfig = modelExplainabilityBaselineConfig != null ? modelExplainabilityBaselineConfig.build() : null;
        }

        @Override
        public final Builder modelExplainabilityBaselineConfig(ModelExplainabilityBaselineConfig modelExplainabilityBaselineConfig) {
            this.modelExplainabilityBaselineConfig = modelExplainabilityBaselineConfig;
            return this;
        }

        public final ModelExplainabilityAppSpecification.Builder getModelExplainabilityAppSpecification() {
            return this.modelExplainabilityAppSpecification != null ? this.modelExplainabilityAppSpecification.toBuilder() : null;
        }

        public final void setModelExplainabilityAppSpecification(ModelExplainabilityAppSpecification.BuilderImpl modelExplainabilityAppSpecification) {
            this.modelExplainabilityAppSpecification = modelExplainabilityAppSpecification != null ? modelExplainabilityAppSpecification.build() : null;
        }

        @Override
        public final Builder modelExplainabilityAppSpecification(ModelExplainabilityAppSpecification modelExplainabilityAppSpecification) {
            this.modelExplainabilityAppSpecification = modelExplainabilityAppSpecification;
            return this;
        }

        public final ModelExplainabilityJobInput.Builder getModelExplainabilityJobInput() {
            return this.modelExplainabilityJobInput != null ? this.modelExplainabilityJobInput.toBuilder() : null;
        }

        public final void setModelExplainabilityJobInput(ModelExplainabilityJobInput.BuilderImpl modelExplainabilityJobInput) {
            this.modelExplainabilityJobInput = modelExplainabilityJobInput != null ? modelExplainabilityJobInput.build() : null;
        }

        @Override
        public final Builder modelExplainabilityJobInput(ModelExplainabilityJobInput modelExplainabilityJobInput) {
            this.modelExplainabilityJobInput = modelExplainabilityJobInput;
            return this;
        }

        public final MonitoringOutputConfig.Builder getModelExplainabilityJobOutputConfig() {
            return this.modelExplainabilityJobOutputConfig != null ? this.modelExplainabilityJobOutputConfig.toBuilder() : null;
        }

        public final void setModelExplainabilityJobOutputConfig(MonitoringOutputConfig.BuilderImpl modelExplainabilityJobOutputConfig) {
            this.modelExplainabilityJobOutputConfig = modelExplainabilityJobOutputConfig != null ? modelExplainabilityJobOutputConfig.build() : null;
        }

        @Override
        public final Builder modelExplainabilityJobOutputConfig(MonitoringOutputConfig modelExplainabilityJobOutputConfig) {
            this.modelExplainabilityJobOutputConfig = modelExplainabilityJobOutputConfig;
            return this;
        }

        public final MonitoringResources.Builder getJobResources() {
            return this.jobResources != null ? this.jobResources.toBuilder() : null;
        }

        public final void setJobResources(MonitoringResources.BuilderImpl jobResources) {
            this.jobResources = jobResources != null ? jobResources.build() : null;
        }

        @Override
        public final Builder jobResources(MonitoringResources jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        public final MonitoringNetworkConfig.Builder getNetworkConfig() {
            return this.networkConfig != null ? this.networkConfig.toBuilder() : null;
        }

        public final void setNetworkConfig(MonitoringNetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        @Override
        public final Builder networkConfig(MonitoringNetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final MonitoringStoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(MonitoringStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        @Override
        public DescribeModelExplainabilityJobDefinitionResponse build() {
            return new DescribeModelExplainabilityJobDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeModelExplainabilityJobDefinitionResponse> {
        public Builder jobDefinitionArn(String var1);

        public Builder jobDefinitionName(String var1);

        public Builder creationTime(Instant var1);

        public Builder modelExplainabilityBaselineConfig(ModelExplainabilityBaselineConfig var1);

        default public Builder modelExplainabilityBaselineConfig(Consumer<ModelExplainabilityBaselineConfig.Builder> modelExplainabilityBaselineConfig) {
            return this.modelExplainabilityBaselineConfig((ModelExplainabilityBaselineConfig)((ModelExplainabilityBaselineConfig.Builder)ModelExplainabilityBaselineConfig.builder().applyMutation(modelExplainabilityBaselineConfig)).build());
        }

        public Builder modelExplainabilityAppSpecification(ModelExplainabilityAppSpecification var1);

        default public Builder modelExplainabilityAppSpecification(Consumer<ModelExplainabilityAppSpecification.Builder> modelExplainabilityAppSpecification) {
            return this.modelExplainabilityAppSpecification((ModelExplainabilityAppSpecification)((ModelExplainabilityAppSpecification.Builder)ModelExplainabilityAppSpecification.builder().applyMutation(modelExplainabilityAppSpecification)).build());
        }

        public Builder modelExplainabilityJobInput(ModelExplainabilityJobInput var1);

        default public Builder modelExplainabilityJobInput(Consumer<ModelExplainabilityJobInput.Builder> modelExplainabilityJobInput) {
            return this.modelExplainabilityJobInput((ModelExplainabilityJobInput)((ModelExplainabilityJobInput.Builder)ModelExplainabilityJobInput.builder().applyMutation(modelExplainabilityJobInput)).build());
        }

        public Builder modelExplainabilityJobOutputConfig(MonitoringOutputConfig var1);

        default public Builder modelExplainabilityJobOutputConfig(Consumer<MonitoringOutputConfig.Builder> modelExplainabilityJobOutputConfig) {
            return this.modelExplainabilityJobOutputConfig((MonitoringOutputConfig)((MonitoringOutputConfig.Builder)MonitoringOutputConfig.builder().applyMutation(modelExplainabilityJobOutputConfig)).build());
        }

        public Builder jobResources(MonitoringResources var1);

        default public Builder jobResources(Consumer<MonitoringResources.Builder> jobResources) {
            return this.jobResources((MonitoringResources)((MonitoringResources.Builder)MonitoringResources.builder().applyMutation(jobResources)).build());
        }

        public Builder networkConfig(MonitoringNetworkConfig var1);

        default public Builder networkConfig(Consumer<MonitoringNetworkConfig.Builder> networkConfig) {
            return this.networkConfig((MonitoringNetworkConfig)((MonitoringNetworkConfig.Builder)MonitoringNetworkConfig.builder().applyMutation(networkConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder stoppingCondition(MonitoringStoppingCondition var1);

        default public Builder stoppingCondition(Consumer<MonitoringStoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((MonitoringStoppingCondition)((MonitoringStoppingCondition.Builder)MonitoringStoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }
    }
}

