/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DeploymentStage;
import software.amazon.awssdk.services.sagemaker.model.DeploymentStagesCopier;
import software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentModelConfig;
import software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentModelConfigsCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEdgeDeploymentPlanRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateEdgeDeploymentPlanRequest> {
    private static final SdkField<String> EDGE_DEPLOYMENT_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgeDeploymentPlanName").getter(CreateEdgeDeploymentPlanRequest.getter(CreateEdgeDeploymentPlanRequest::edgeDeploymentPlanName)).setter(CreateEdgeDeploymentPlanRequest.setter(Builder::edgeDeploymentPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPlanName").build()}).build();
    private static final SdkField<List<EdgeDeploymentModelConfig>> MODEL_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelConfigs").getter(CreateEdgeDeploymentPlanRequest.getter(CreateEdgeDeploymentPlanRequest::modelConfigs)).setter(CreateEdgeDeploymentPlanRequest.setter(Builder::modelConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EdgeDeploymentModelConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceFleetName").getter(CreateEdgeDeploymentPlanRequest.getter(CreateEdgeDeploymentPlanRequest::deviceFleetName)).setter(CreateEdgeDeploymentPlanRequest.setter(Builder::deviceFleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()}).build();
    private static final SdkField<List<DeploymentStage>> STAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Stages").getter(CreateEdgeDeploymentPlanRequest.getter(CreateEdgeDeploymentPlanRequest::stages)).setter(CreateEdgeDeploymentPlanRequest.setter(Builder::stages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeploymentStage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateEdgeDeploymentPlanRequest.getter(CreateEdgeDeploymentPlanRequest::tags)).setter(CreateEdgeDeploymentPlanRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_DEPLOYMENT_PLAN_NAME_FIELD, MODEL_CONFIGS_FIELD, DEVICE_FLEET_NAME_FIELD, STAGES_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEdgeDeploymentPlanRequest.memberNameToFieldInitializer();
    private final String edgeDeploymentPlanName;
    private final List<EdgeDeploymentModelConfig> modelConfigs;
    private final String deviceFleetName;
    private final List<DeploymentStage> stages;
    private final List<Tag> tags;

    private CreateEdgeDeploymentPlanRequest(BuilderImpl builder) {
        super(builder);
        this.edgeDeploymentPlanName = builder.edgeDeploymentPlanName;
        this.modelConfigs = builder.modelConfigs;
        this.deviceFleetName = builder.deviceFleetName;
        this.stages = builder.stages;
        this.tags = builder.tags;
    }

    public final String edgeDeploymentPlanName() {
        return this.edgeDeploymentPlanName;
    }

    public final boolean hasModelConfigs() {
        return this.modelConfigs != null && !(this.modelConfigs instanceof SdkAutoConstructList);
    }

    public final List<EdgeDeploymentModelConfig> modelConfigs() {
        return this.modelConfigs;
    }

    public final String deviceFleetName() {
        return this.deviceFleetName;
    }

    public final boolean hasStages() {
        return this.stages != null && !(this.stages instanceof SdkAutoConstructList);
    }

    public final List<DeploymentStage> stages() {
        return this.stages;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeDeploymentPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelConfigs() ? this.modelConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStages() ? this.stages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEdgeDeploymentPlanRequest)) {
            return false;
        }
        CreateEdgeDeploymentPlanRequest other = (CreateEdgeDeploymentPlanRequest)((Object)obj);
        return Objects.equals(this.edgeDeploymentPlanName(), other.edgeDeploymentPlanName()) && this.hasModelConfigs() == other.hasModelConfigs() && Objects.equals(this.modelConfigs(), other.modelConfigs()) && Objects.equals(this.deviceFleetName(), other.deviceFleetName()) && this.hasStages() == other.hasStages() && Objects.equals(this.stages(), other.stages()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEdgeDeploymentPlanRequest").add("EdgeDeploymentPlanName", (Object)this.edgeDeploymentPlanName()).add("ModelConfigs", this.hasModelConfigs() ? this.modelConfigs() : null).add("DeviceFleetName", (Object)this.deviceFleetName()).add("Stages", this.hasStages() ? this.stages() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EdgeDeploymentPlanName": {
                return Optional.ofNullable(clazz.cast(this.edgeDeploymentPlanName()));
            }
            case "ModelConfigs": {
                return Optional.ofNullable(clazz.cast(this.modelConfigs()));
            }
            case "DeviceFleetName": {
                return Optional.ofNullable(clazz.cast(this.deviceFleetName()));
            }
            case "Stages": {
                return Optional.ofNullable(clazz.cast(this.stages()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EdgeDeploymentPlanName", EDGE_DEPLOYMENT_PLAN_NAME_FIELD);
        map.put("ModelConfigs", MODEL_CONFIGS_FIELD);
        map.put("DeviceFleetName", DEVICE_FLEET_NAME_FIELD);
        map.put("Stages", STAGES_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEdgeDeploymentPlanRequest, T> g) {
        return obj -> g.apply((CreateEdgeDeploymentPlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String edgeDeploymentPlanName;
        private List<EdgeDeploymentModelConfig> modelConfigs = DefaultSdkAutoConstructList.getInstance();
        private String deviceFleetName;
        private List<DeploymentStage> stages = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEdgeDeploymentPlanRequest model) {
            super(model);
            this.edgeDeploymentPlanName(model.edgeDeploymentPlanName);
            this.modelConfigs(model.modelConfigs);
            this.deviceFleetName(model.deviceFleetName);
            this.stages(model.stages);
            this.tags(model.tags);
        }

        public final String getEdgeDeploymentPlanName() {
            return this.edgeDeploymentPlanName;
        }

        public final void setEdgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
        }

        @Override
        public final Builder edgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
            return this;
        }

        public final List<EdgeDeploymentModelConfig.Builder> getModelConfigs() {
            List<EdgeDeploymentModelConfig.Builder> result = EdgeDeploymentModelConfigsCopier.copyToBuilder(this.modelConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelConfigs(Collection<EdgeDeploymentModelConfig.BuilderImpl> modelConfigs) {
            this.modelConfigs = EdgeDeploymentModelConfigsCopier.copyFromBuilder(modelConfigs);
        }

        @Override
        public final Builder modelConfigs(Collection<EdgeDeploymentModelConfig> modelConfigs) {
            this.modelConfigs = EdgeDeploymentModelConfigsCopier.copy(modelConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelConfigs(EdgeDeploymentModelConfig ... modelConfigs) {
            this.modelConfigs(Arrays.asList(modelConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelConfigs(Consumer<EdgeDeploymentModelConfig.Builder> ... modelConfigs) {
            this.modelConfigs(Stream.of(modelConfigs).map(c -> (EdgeDeploymentModelConfig)((EdgeDeploymentModelConfig.Builder)EdgeDeploymentModelConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDeviceFleetName() {
            return this.deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final List<DeploymentStage.Builder> getStages() {
            List<DeploymentStage.Builder> result = DeploymentStagesCopier.copyToBuilder(this.stages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStages(Collection<DeploymentStage.BuilderImpl> stages) {
            this.stages = DeploymentStagesCopier.copyFromBuilder(stages);
        }

        @Override
        public final Builder stages(Collection<DeploymentStage> stages) {
            this.stages = DeploymentStagesCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(DeploymentStage ... stages) {
            this.stages(Arrays.asList(stages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(Consumer<DeploymentStage.Builder> ... stages) {
            this.stages(Stream.of(stages).map(c -> (DeploymentStage)((DeploymentStage.Builder)DeploymentStage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEdgeDeploymentPlanRequest build() {
            return new CreateEdgeDeploymentPlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEdgeDeploymentPlanRequest> {
        public Builder edgeDeploymentPlanName(String var1);

        public Builder modelConfigs(Collection<EdgeDeploymentModelConfig> var1);

        public Builder modelConfigs(EdgeDeploymentModelConfig ... var1);

        public Builder modelConfigs(Consumer<EdgeDeploymentModelConfig.Builder> ... var1);

        public Builder deviceFleetName(String var1);

        public Builder stages(Collection<DeploymentStage> var1);

        public Builder stages(DeploymentStage ... var1);

        public Builder stages(Consumer<DeploymentStage.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

