/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.JobType;
import software.amazon.awssdk.services.sagemaker.model.Processor;
import software.amazon.awssdk.services.sagemaker.model.SageMakerImageVersionAliasesCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.VendorGuidance;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateImageVersionRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateImageVersionRequest> {
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageName").getter(UpdateImageVersionRequest.getter(UpdateImageVersionRequest::imageName)).setter(UpdateImageVersionRequest.setter(Builder::imageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(UpdateImageVersionRequest.getter(UpdateImageVersionRequest::alias)).setter(UpdateImageVersionRequest.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<Integer> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Version").getter(UpdateImageVersionRequest.getter(UpdateImageVersionRequest::version)).setter(UpdateImageVersionRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<List<String>> ALIASES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AliasesToAdd").getter(UpdateImageVersionRequest.getter(UpdateImageVersionRequest::aliasesToAdd)).setter(UpdateImageVersionRequest.setter(Builder::aliasesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALIASES_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AliasesToDelete").getter(UpdateImageVersionRequest.getter(UpdateImageVersionRequest::aliasesToDelete)).setter(UpdateImageVersionRequest.setter(Builder::aliasesToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasesToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VENDOR_GUIDANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VendorGuidance").getter(UpdateImageVersionRequest.getter(UpdateImageVersionRequest::vendorGuidanceAsString)).setter(UpdateImageVersionRequest.setter(Builder::vendorGuidance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorGuidance").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobType").getter(UpdateImageVersionRequest.getter(UpdateImageVersionRequest::jobTypeAsString)).setter(UpdateImageVersionRequest.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final SdkField<String> ML_FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MLFramework").getter(UpdateImageVersionRequest.getter(UpdateImageVersionRequest::mlFramework)).setter(UpdateImageVersionRequest.setter(Builder::mlFramework)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLFramework").build()}).build();
    private static final SdkField<String> PROGRAMMING_LANG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgrammingLang").getter(UpdateImageVersionRequest.getter(UpdateImageVersionRequest::programmingLang)).setter(UpdateImageVersionRequest.setter(Builder::programmingLang)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgrammingLang").build()}).build();
    private static final SdkField<String> PROCESSOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Processor").getter(UpdateImageVersionRequest.getter(UpdateImageVersionRequest::processorAsString)).setter(UpdateImageVersionRequest.setter(Builder::processor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processor").build()}).build();
    private static final SdkField<Boolean> HOROVOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Horovod").getter(UpdateImageVersionRequest.getter(UpdateImageVersionRequest::horovod)).setter(UpdateImageVersionRequest.setter(Builder::horovod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Horovod").build()}).build();
    private static final SdkField<String> RELEASE_NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReleaseNotes").getter(UpdateImageVersionRequest.getter(UpdateImageVersionRequest::releaseNotes)).setter(UpdateImageVersionRequest.setter(Builder::releaseNotes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseNotes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_NAME_FIELD, ALIAS_FIELD, VERSION_FIELD, ALIASES_TO_ADD_FIELD, ALIASES_TO_DELETE_FIELD, VENDOR_GUIDANCE_FIELD, JOB_TYPE_FIELD, ML_FRAMEWORK_FIELD, PROGRAMMING_LANG_FIELD, PROCESSOR_FIELD, HOROVOD_FIELD, RELEASE_NOTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateImageVersionRequest.memberNameToFieldInitializer();
    private final String imageName;
    private final String alias;
    private final Integer version;
    private final List<String> aliasesToAdd;
    private final List<String> aliasesToDelete;
    private final String vendorGuidance;
    private final String jobType;
    private final String mlFramework;
    private final String programmingLang;
    private final String processor;
    private final Boolean horovod;
    private final String releaseNotes;

    private UpdateImageVersionRequest(BuilderImpl builder) {
        super(builder);
        this.imageName = builder.imageName;
        this.alias = builder.alias;
        this.version = builder.version;
        this.aliasesToAdd = builder.aliasesToAdd;
        this.aliasesToDelete = builder.aliasesToDelete;
        this.vendorGuidance = builder.vendorGuidance;
        this.jobType = builder.jobType;
        this.mlFramework = builder.mlFramework;
        this.programmingLang = builder.programmingLang;
        this.processor = builder.processor;
        this.horovod = builder.horovod;
        this.releaseNotes = builder.releaseNotes;
    }

    public final String imageName() {
        return this.imageName;
    }

    public final String alias() {
        return this.alias;
    }

    public final Integer version() {
        return this.version;
    }

    public final boolean hasAliasesToAdd() {
        return this.aliasesToAdd != null && !(this.aliasesToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> aliasesToAdd() {
        return this.aliasesToAdd;
    }

    public final boolean hasAliasesToDelete() {
        return this.aliasesToDelete != null && !(this.aliasesToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> aliasesToDelete() {
        return this.aliasesToDelete;
    }

    public final VendorGuidance vendorGuidance() {
        return VendorGuidance.fromValue(this.vendorGuidance);
    }

    public final String vendorGuidanceAsString() {
        return this.vendorGuidance;
    }

    public final JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final String mlFramework() {
        return this.mlFramework;
    }

    public final String programmingLang() {
        return this.programmingLang;
    }

    public final Processor processor() {
        return Processor.fromValue(this.processor);
    }

    public final String processorAsString() {
        return this.processor;
    }

    public final Boolean horovod() {
        return this.horovod;
    }

    public final String releaseNotes() {
        return this.releaseNotes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAliasesToAdd() ? this.aliasesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAliasesToDelete() ? this.aliasesToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorGuidanceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlFramework());
        hashCode = 31 * hashCode + Objects.hashCode(this.programmingLang());
        hashCode = 31 * hashCode + Objects.hashCode(this.processorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.horovod());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseNotes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImageVersionRequest)) {
            return false;
        }
        UpdateImageVersionRequest other = (UpdateImageVersionRequest)((Object)obj);
        return Objects.equals(this.imageName(), other.imageName()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.version(), other.version()) && this.hasAliasesToAdd() == other.hasAliasesToAdd() && Objects.equals(this.aliasesToAdd(), other.aliasesToAdd()) && this.hasAliasesToDelete() == other.hasAliasesToDelete() && Objects.equals(this.aliasesToDelete(), other.aliasesToDelete()) && Objects.equals(this.vendorGuidanceAsString(), other.vendorGuidanceAsString()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.mlFramework(), other.mlFramework()) && Objects.equals(this.programmingLang(), other.programmingLang()) && Objects.equals(this.processorAsString(), other.processorAsString()) && Objects.equals(this.horovod(), other.horovod()) && Objects.equals(this.releaseNotes(), other.releaseNotes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateImageVersionRequest").add("ImageName", (Object)this.imageName()).add("Alias", (Object)this.alias()).add("Version", (Object)this.version()).add("AliasesToAdd", this.hasAliasesToAdd() ? this.aliasesToAdd() : null).add("AliasesToDelete", this.hasAliasesToDelete() ? this.aliasesToDelete() : null).add("VendorGuidance", (Object)this.vendorGuidanceAsString()).add("JobType", (Object)this.jobTypeAsString()).add("MLFramework", (Object)this.mlFramework()).add("ProgrammingLang", (Object)this.programmingLang()).add("Processor", (Object)this.processorAsString()).add("Horovod", (Object)this.horovod()).add("ReleaseNotes", (Object)this.releaseNotes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageName": {
                return Optional.ofNullable(clazz.cast(this.imageName()));
            }
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "AliasesToAdd": {
                return Optional.ofNullable(clazz.cast(this.aliasesToAdd()));
            }
            case "AliasesToDelete": {
                return Optional.ofNullable(clazz.cast(this.aliasesToDelete()));
            }
            case "VendorGuidance": {
                return Optional.ofNullable(clazz.cast(this.vendorGuidanceAsString()));
            }
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "MLFramework": {
                return Optional.ofNullable(clazz.cast(this.mlFramework()));
            }
            case "ProgrammingLang": {
                return Optional.ofNullable(clazz.cast(this.programmingLang()));
            }
            case "Processor": {
                return Optional.ofNullable(clazz.cast(this.processorAsString()));
            }
            case "Horovod": {
                return Optional.ofNullable(clazz.cast(this.horovod()));
            }
            case "ReleaseNotes": {
                return Optional.ofNullable(clazz.cast(this.releaseNotes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImageName", IMAGE_NAME_FIELD);
        map.put("Alias", ALIAS_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("AliasesToAdd", ALIASES_TO_ADD_FIELD);
        map.put("AliasesToDelete", ALIASES_TO_DELETE_FIELD);
        map.put("VendorGuidance", VENDOR_GUIDANCE_FIELD);
        map.put("JobType", JOB_TYPE_FIELD);
        map.put("MLFramework", ML_FRAMEWORK_FIELD);
        map.put("ProgrammingLang", PROGRAMMING_LANG_FIELD);
        map.put("Processor", PROCESSOR_FIELD);
        map.put("Horovod", HOROVOD_FIELD);
        map.put("ReleaseNotes", RELEASE_NOTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateImageVersionRequest, T> g) {
        return obj -> g.apply((UpdateImageVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String imageName;
        private String alias;
        private Integer version;
        private List<String> aliasesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> aliasesToDelete = DefaultSdkAutoConstructList.getInstance();
        private String vendorGuidance;
        private String jobType;
        private String mlFramework;
        private String programmingLang;
        private String processor;
        private Boolean horovod;
        private String releaseNotes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImageVersionRequest model) {
            super(model);
            this.imageName(model.imageName);
            this.alias(model.alias);
            this.version(model.version);
            this.aliasesToAdd(model.aliasesToAdd);
            this.aliasesToDelete(model.aliasesToDelete);
            this.vendorGuidance(model.vendorGuidance);
            this.jobType(model.jobType);
            this.mlFramework(model.mlFramework);
            this.programmingLang(model.programmingLang);
            this.processor(model.processor);
            this.horovod(model.horovod);
            this.releaseNotes(model.releaseNotes);
        }

        public final String getImageName() {
            return this.imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final Integer getVersion() {
            return this.version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final Collection<String> getAliasesToAdd() {
            if (this.aliasesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aliasesToAdd;
        }

        public final void setAliasesToAdd(Collection<String> aliasesToAdd) {
            this.aliasesToAdd = SageMakerImageVersionAliasesCopier.copy(aliasesToAdd);
        }

        @Override
        public final Builder aliasesToAdd(Collection<String> aliasesToAdd) {
            this.aliasesToAdd = SageMakerImageVersionAliasesCopier.copy(aliasesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasesToAdd(String ... aliasesToAdd) {
            this.aliasesToAdd(Arrays.asList(aliasesToAdd));
            return this;
        }

        public final Collection<String> getAliasesToDelete() {
            if (this.aliasesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aliasesToDelete;
        }

        public final void setAliasesToDelete(Collection<String> aliasesToDelete) {
            this.aliasesToDelete = SageMakerImageVersionAliasesCopier.copy(aliasesToDelete);
        }

        @Override
        public final Builder aliasesToDelete(Collection<String> aliasesToDelete) {
            this.aliasesToDelete = SageMakerImageVersionAliasesCopier.copy(aliasesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasesToDelete(String ... aliasesToDelete) {
            this.aliasesToDelete(Arrays.asList(aliasesToDelete));
            return this;
        }

        public final String getVendorGuidance() {
            return this.vendorGuidance;
        }

        public final void setVendorGuidance(String vendorGuidance) {
            this.vendorGuidance = vendorGuidance;
        }

        @Override
        public final Builder vendorGuidance(String vendorGuidance) {
            this.vendorGuidance = vendorGuidance;
            return this;
        }

        @Override
        public final Builder vendorGuidance(VendorGuidance vendorGuidance) {
            this.vendorGuidance(vendorGuidance == null ? null : vendorGuidance.toString());
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getMlFramework() {
            return this.mlFramework;
        }

        public final void setMlFramework(String mlFramework) {
            this.mlFramework = mlFramework;
        }

        @Override
        public final Builder mlFramework(String mlFramework) {
            this.mlFramework = mlFramework;
            return this;
        }

        public final String getProgrammingLang() {
            return this.programmingLang;
        }

        public final void setProgrammingLang(String programmingLang) {
            this.programmingLang = programmingLang;
        }

        @Override
        public final Builder programmingLang(String programmingLang) {
            this.programmingLang = programmingLang;
            return this;
        }

        public final String getProcessor() {
            return this.processor;
        }

        public final void setProcessor(String processor) {
            this.processor = processor;
        }

        @Override
        public final Builder processor(String processor) {
            this.processor = processor;
            return this;
        }

        @Override
        public final Builder processor(Processor processor) {
            this.processor(processor == null ? null : processor.toString());
            return this;
        }

        public final Boolean getHorovod() {
            return this.horovod;
        }

        public final void setHorovod(Boolean horovod) {
            this.horovod = horovod;
        }

        @Override
        public final Builder horovod(Boolean horovod) {
            this.horovod = horovod;
            return this;
        }

        public final String getReleaseNotes() {
            return this.releaseNotes;
        }

        public final void setReleaseNotes(String releaseNotes) {
            this.releaseNotes = releaseNotes;
        }

        @Override
        public final Builder releaseNotes(String releaseNotes) {
            this.releaseNotes = releaseNotes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateImageVersionRequest build() {
            return new UpdateImageVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateImageVersionRequest> {
        public Builder imageName(String var1);

        public Builder alias(String var1);

        public Builder version(Integer var1);

        public Builder aliasesToAdd(Collection<String> var1);

        public Builder aliasesToAdd(String ... var1);

        public Builder aliasesToDelete(Collection<String> var1);

        public Builder aliasesToDelete(String ... var1);

        public Builder vendorGuidance(String var1);

        public Builder vendorGuidance(VendorGuidance var1);

        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder mlFramework(String var1);

        public Builder programmingLang(String var1);

        public Builder processor(String var1);

        public Builder processor(Processor var1);

        public Builder horovod(Boolean var1);

        public Builder releaseNotes(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

