/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ReservedCapacityInstanceType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResourceName;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResourceNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchTrainingPlanOfferingsRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, SearchTrainingPlanOfferingsRequest> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(SearchTrainingPlanOfferingsRequest.getter(SearchTrainingPlanOfferingsRequest::instanceTypeAsString)).setter(SearchTrainingPlanOfferingsRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(SearchTrainingPlanOfferingsRequest.getter(SearchTrainingPlanOfferingsRequest::instanceCount)).setter(SearchTrainingPlanOfferingsRequest.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final SdkField<Instant> START_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTimeAfter").getter(SearchTrainingPlanOfferingsRequest.getter(SearchTrainingPlanOfferingsRequest::startTimeAfter)).setter(SearchTrainingPlanOfferingsRequest.setter(Builder::startTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeAfter").build()}).build();
    private static final SdkField<Instant> END_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTimeBefore").getter(SearchTrainingPlanOfferingsRequest.getter(SearchTrainingPlanOfferingsRequest::endTimeBefore)).setter(SearchTrainingPlanOfferingsRequest.setter(Builder::endTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimeBefore").build()}).build();
    private static final SdkField<Long> DURATION_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationHours").getter(SearchTrainingPlanOfferingsRequest.getter(SearchTrainingPlanOfferingsRequest::durationHours)).setter(SearchTrainingPlanOfferingsRequest.setter(Builder::durationHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationHours").build()}).build();
    private static final SdkField<List<String>> TARGET_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetResources").getter(SearchTrainingPlanOfferingsRequest.getter(SearchTrainingPlanOfferingsRequest::targetResourcesAsStrings)).setter(SearchTrainingPlanOfferingsRequest.setter(Builder::targetResourcesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, INSTANCE_COUNT_FIELD, START_TIME_AFTER_FIELD, END_TIME_BEFORE_FIELD, DURATION_HOURS_FIELD, TARGET_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchTrainingPlanOfferingsRequest.memberNameToFieldInitializer();
    private final String instanceType;
    private final Integer instanceCount;
    private final Instant startTimeAfter;
    private final Instant endTimeBefore;
    private final Long durationHours;
    private final List<String> targetResources;

    private SearchTrainingPlanOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.startTimeAfter = builder.startTimeAfter;
        this.endTimeBefore = builder.endTimeBefore;
        this.durationHours = builder.durationHours;
        this.targetResources = builder.targetResources;
    }

    public final ReservedCapacityInstanceType instanceType() {
        return ReservedCapacityInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final Instant startTimeAfter() {
        return this.startTimeAfter;
    }

    public final Instant endTimeBefore() {
        return this.endTimeBefore;
    }

    public final Long durationHours() {
        return this.durationHours;
    }

    public final List<SageMakerResourceName> targetResources() {
        return SageMakerResourceNamesCopier.copyStringToEnum(this.targetResources);
    }

    public final boolean hasTargetResources() {
        return this.targetResources != null && !(this.targetResources instanceof SdkAutoConstructList);
    }

    public final List<String> targetResourcesAsStrings() {
        return this.targetResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetResources() ? this.targetResourcesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTrainingPlanOfferingsRequest)) {
            return false;
        }
        SearchTrainingPlanOfferingsRequest other = (SearchTrainingPlanOfferingsRequest)((Object)obj);
        return Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.startTimeAfter(), other.startTimeAfter()) && Objects.equals(this.endTimeBefore(), other.endTimeBefore()) && Objects.equals(this.durationHours(), other.durationHours()) && this.hasTargetResources() == other.hasTargetResources() && Objects.equals(this.targetResourcesAsStrings(), other.targetResourcesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"SearchTrainingPlanOfferingsRequest").add("InstanceType", (Object)this.instanceTypeAsString()).add("InstanceCount", (Object)this.instanceCount()).add("StartTimeAfter", (Object)this.startTimeAfter()).add("EndTimeBefore", (Object)this.endTimeBefore()).add("DurationHours", (Object)this.durationHours()).add("TargetResources", this.hasTargetResources() ? this.targetResourcesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "StartTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.startTimeAfter()));
            }
            case "EndTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.endTimeBefore()));
            }
            case "DurationHours": {
                return Optional.ofNullable(clazz.cast(this.durationHours()));
            }
            case "TargetResources": {
                return Optional.ofNullable(clazz.cast(this.targetResourcesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("StartTimeAfter", START_TIME_AFTER_FIELD);
        map.put("EndTimeBefore", END_TIME_BEFORE_FIELD);
        map.put("DurationHours", DURATION_HOURS_FIELD);
        map.put("TargetResources", TARGET_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchTrainingPlanOfferingsRequest, T> g) {
        return obj -> g.apply((SearchTrainingPlanOfferingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String instanceType;
        private Integer instanceCount;
        private Instant startTimeAfter;
        private Instant endTimeBefore;
        private Long durationHours;
        private List<String> targetResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTrainingPlanOfferingsRequest model) {
            super(model);
            this.instanceType(model.instanceType);
            this.instanceCount(model.instanceCount);
            this.startTimeAfter(model.startTimeAfter);
            this.endTimeBefore(model.endTimeBefore);
            this.durationHours(model.durationHours);
            this.targetResourcesWithStrings(model.targetResources);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ReservedCapacityInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Instant getStartTimeAfter() {
            return this.startTimeAfter;
        }

        public final void setStartTimeAfter(Instant startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
        }

        @Override
        public final Builder startTimeAfter(Instant startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
            return this;
        }

        public final Instant getEndTimeBefore() {
            return this.endTimeBefore;
        }

        public final void setEndTimeBefore(Instant endTimeBefore) {
            this.endTimeBefore = endTimeBefore;
        }

        @Override
        public final Builder endTimeBefore(Instant endTimeBefore) {
            this.endTimeBefore = endTimeBefore;
            return this;
        }

        public final Long getDurationHours() {
            return this.durationHours;
        }

        public final void setDurationHours(Long durationHours) {
            this.durationHours = durationHours;
        }

        @Override
        public final Builder durationHours(Long durationHours) {
            this.durationHours = durationHours;
            return this;
        }

        public final Collection<String> getTargetResources() {
            if (this.targetResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetResources;
        }

        public final void setTargetResources(Collection<String> targetResources) {
            this.targetResources = SageMakerResourceNamesCopier.copy(targetResources);
        }

        @Override
        public final Builder targetResourcesWithStrings(Collection<String> targetResources) {
            this.targetResources = SageMakerResourceNamesCopier.copy(targetResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourcesWithStrings(String ... targetResources) {
            this.targetResourcesWithStrings(Arrays.asList(targetResources));
            return this;
        }

        @Override
        public final Builder targetResources(Collection<SageMakerResourceName> targetResources) {
            this.targetResources = SageMakerResourceNamesCopier.copyEnumToString(targetResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResources(SageMakerResourceName ... targetResources) {
            this.targetResources(Arrays.asList(targetResources));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchTrainingPlanOfferingsRequest build() {
            return new SearchTrainingPlanOfferingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchTrainingPlanOfferingsRequest> {
        public Builder instanceType(String var1);

        public Builder instanceType(ReservedCapacityInstanceType var1);

        public Builder instanceCount(Integer var1);

        public Builder startTimeAfter(Instant var1);

        public Builder endTimeBefore(Instant var1);

        public Builder durationHours(Long var1);

        public Builder targetResourcesWithStrings(Collection<String> var1);

        public Builder targetResourcesWithStrings(String ... var1);

        public Builder targetResources(Collection<SageMakerResourceName> var1);

        public Builder targetResources(SageMakerResourceName ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

