/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.JoinSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataProcessing
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataProcessing> {
    private static final SdkField<String> INPUT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputFilter").getter(DataProcessing.getter(DataProcessing::inputFilter)).setter(DataProcessing.setter(Builder::inputFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFilter").build()}).build();
    private static final SdkField<String> OUTPUT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputFilter").getter(DataProcessing.getter(DataProcessing::outputFilter)).setter(DataProcessing.setter(Builder::outputFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFilter").build()}).build();
    private static final SdkField<String> JOIN_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JoinSource").getter(DataProcessing.getter(DataProcessing::joinSourceAsString)).setter(DataProcessing.setter(Builder::joinSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FILTER_FIELD, OUTPUT_FILTER_FIELD, JOIN_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataProcessing.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String inputFilter;
    private final String outputFilter;
    private final String joinSource;

    private DataProcessing(BuilderImpl builder) {
        this.inputFilter = builder.inputFilter;
        this.outputFilter = builder.outputFilter;
        this.joinSource = builder.joinSource;
    }

    public final String inputFilter() {
        return this.inputFilter;
    }

    public final String outputFilter() {
        return this.outputFilter;
    }

    public final JoinSource joinSource() {
        return JoinSource.fromValue(this.joinSource);
    }

    public final String joinSourceAsString() {
        return this.joinSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.joinSourceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProcessing)) {
            return false;
        }
        DataProcessing other = (DataProcessing)obj;
        return Objects.equals(this.inputFilter(), other.inputFilter()) && Objects.equals(this.outputFilter(), other.outputFilter()) && Objects.equals(this.joinSourceAsString(), other.joinSourceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DataProcessing").add("InputFilter", (Object)this.inputFilter()).add("OutputFilter", (Object)this.outputFilter()).add("JoinSource", (Object)this.joinSourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputFilter": {
                return Optional.ofNullable(clazz.cast(this.inputFilter()));
            }
            case "OutputFilter": {
                return Optional.ofNullable(clazz.cast(this.outputFilter()));
            }
            case "JoinSource": {
                return Optional.ofNullable(clazz.cast(this.joinSourceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InputFilter", INPUT_FILTER_FIELD);
        map.put("OutputFilter", OUTPUT_FILTER_FIELD);
        map.put("JoinSource", JOIN_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProcessing, T> g) {
        return obj -> g.apply((DataProcessing)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputFilter;
        private String outputFilter;
        private String joinSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProcessing model) {
            this.inputFilter(model.inputFilter);
            this.outputFilter(model.outputFilter);
            this.joinSource(model.joinSource);
        }

        public final String getInputFilter() {
            return this.inputFilter;
        }

        public final void setInputFilter(String inputFilter) {
            this.inputFilter = inputFilter;
        }

        @Override
        public final Builder inputFilter(String inputFilter) {
            this.inputFilter = inputFilter;
            return this;
        }

        public final String getOutputFilter() {
            return this.outputFilter;
        }

        public final void setOutputFilter(String outputFilter) {
            this.outputFilter = outputFilter;
        }

        @Override
        public final Builder outputFilter(String outputFilter) {
            this.outputFilter = outputFilter;
            return this;
        }

        public final String getJoinSource() {
            return this.joinSource;
        }

        public final void setJoinSource(String joinSource) {
            this.joinSource = joinSource;
        }

        @Override
        public final Builder joinSource(String joinSource) {
            this.joinSource = joinSource;
            return this;
        }

        @Override
        public final Builder joinSource(JoinSource joinSource) {
            this.joinSource(joinSource == null ? null : joinSource.toString());
            return this;
        }

        public DataProcessing build() {
            return new DataProcessing(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataProcessing> {
        public Builder inputFilter(String var1);

        public Builder outputFilter(String var1);

        public Builder joinSource(String var1);

        public Builder joinSource(JoinSource var1);
    }
}

