/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.BatchTransformInput;
import software.amazon.awssdk.services.sagemaker.model.EndpointInput;
import software.amazon.awssdk.services.sagemaker.model.MonitoringGroundTruthS3Input;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelQualityJobInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelQualityJobInput> {
    private static final SdkField<EndpointInput> ENDPOINT_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointInput").getter(ModelQualityJobInput.getter(ModelQualityJobInput::endpointInput)).setter(ModelQualityJobInput.setter(Builder::endpointInput)).constructor(EndpointInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointInput").build()}).build();
    private static final SdkField<BatchTransformInput> BATCH_TRANSFORM_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BatchTransformInput").getter(ModelQualityJobInput.getter(ModelQualityJobInput::batchTransformInput)).setter(ModelQualityJobInput.setter(Builder::batchTransformInput)).constructor(BatchTransformInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchTransformInput").build()}).build();
    private static final SdkField<MonitoringGroundTruthS3Input> GROUND_TRUTH_S3_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GroundTruthS3Input").getter(ModelQualityJobInput.getter(ModelQualityJobInput::groundTruthS3Input)).setter(ModelQualityJobInput.setter(Builder::groundTruthS3Input)).constructor(MonitoringGroundTruthS3Input::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroundTruthS3Input").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_INPUT_FIELD, BATCH_TRANSFORM_INPUT_FIELD, GROUND_TRUTH_S3_INPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelQualityJobInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EndpointInput endpointInput;
    private final BatchTransformInput batchTransformInput;
    private final MonitoringGroundTruthS3Input groundTruthS3Input;

    private ModelQualityJobInput(BuilderImpl builder) {
        this.endpointInput = builder.endpointInput;
        this.batchTransformInput = builder.batchTransformInput;
        this.groundTruthS3Input = builder.groundTruthS3Input;
    }

    public final EndpointInput endpointInput() {
        return this.endpointInput;
    }

    public final BatchTransformInput batchTransformInput() {
        return this.batchTransformInput;
    }

    public final MonitoringGroundTruthS3Input groundTruthS3Input() {
        return this.groundTruthS3Input;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchTransformInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.groundTruthS3Input());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelQualityJobInput)) {
            return false;
        }
        ModelQualityJobInput other = (ModelQualityJobInput)obj;
        return Objects.equals(this.endpointInput(), other.endpointInput()) && Objects.equals(this.batchTransformInput(), other.batchTransformInput()) && Objects.equals(this.groundTruthS3Input(), other.groundTruthS3Input());
    }

    public final String toString() {
        return ToString.builder((String)"ModelQualityJobInput").add("EndpointInput", (Object)this.endpointInput()).add("BatchTransformInput", (Object)this.batchTransformInput()).add("GroundTruthS3Input", (Object)this.groundTruthS3Input()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointInput": {
                return Optional.ofNullable(clazz.cast(this.endpointInput()));
            }
            case "BatchTransformInput": {
                return Optional.ofNullable(clazz.cast(this.batchTransformInput()));
            }
            case "GroundTruthS3Input": {
                return Optional.ofNullable(clazz.cast(this.groundTruthS3Input()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EndpointInput", ENDPOINT_INPUT_FIELD);
        map.put("BatchTransformInput", BATCH_TRANSFORM_INPUT_FIELD);
        map.put("GroundTruthS3Input", GROUND_TRUTH_S3_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelQualityJobInput, T> g) {
        return obj -> g.apply((ModelQualityJobInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EndpointInput endpointInput;
        private BatchTransformInput batchTransformInput;
        private MonitoringGroundTruthS3Input groundTruthS3Input;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelQualityJobInput model) {
            this.endpointInput(model.endpointInput);
            this.batchTransformInput(model.batchTransformInput);
            this.groundTruthS3Input(model.groundTruthS3Input);
        }

        public final EndpointInput.Builder getEndpointInput() {
            return this.endpointInput != null ? this.endpointInput.toBuilder() : null;
        }

        public final void setEndpointInput(EndpointInput.BuilderImpl endpointInput) {
            this.endpointInput = endpointInput != null ? endpointInput.build() : null;
        }

        @Override
        public final Builder endpointInput(EndpointInput endpointInput) {
            this.endpointInput = endpointInput;
            return this;
        }

        public final BatchTransformInput.Builder getBatchTransformInput() {
            return this.batchTransformInput != null ? this.batchTransformInput.toBuilder() : null;
        }

        public final void setBatchTransformInput(BatchTransformInput.BuilderImpl batchTransformInput) {
            this.batchTransformInput = batchTransformInput != null ? batchTransformInput.build() : null;
        }

        @Override
        public final Builder batchTransformInput(BatchTransformInput batchTransformInput) {
            this.batchTransformInput = batchTransformInput;
            return this;
        }

        public final MonitoringGroundTruthS3Input.Builder getGroundTruthS3Input() {
            return this.groundTruthS3Input != null ? this.groundTruthS3Input.toBuilder() : null;
        }

        public final void setGroundTruthS3Input(MonitoringGroundTruthS3Input.BuilderImpl groundTruthS3Input) {
            this.groundTruthS3Input = groundTruthS3Input != null ? groundTruthS3Input.build() : null;
        }

        @Override
        public final Builder groundTruthS3Input(MonitoringGroundTruthS3Input groundTruthS3Input) {
            this.groundTruthS3Input = groundTruthS3Input;
            return this;
        }

        public ModelQualityJobInput build() {
            return new ModelQualityJobInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelQualityJobInput> {
        public Builder endpointInput(EndpointInput var1);

        default public Builder endpointInput(Consumer<EndpointInput.Builder> endpointInput) {
            return this.endpointInput((EndpointInput)((EndpointInput.Builder)EndpointInput.builder().applyMutation(endpointInput)).build());
        }

        public Builder batchTransformInput(BatchTransformInput var1);

        default public Builder batchTransformInput(Consumer<BatchTransformInput.Builder> batchTransformInput) {
            return this.batchTransformInput((BatchTransformInput)((BatchTransformInput.Builder)BatchTransformInput.builder().applyMutation(batchTransformInput)).build());
        }

        public Builder groundTruthS3Input(MonitoringGroundTruthS3Input var1);

        default public Builder groundTruthS3Input(Consumer<MonitoringGroundTruthS3Input.Builder> groundTruthS3Input) {
            return this.groundTruthS3Input((MonitoringGroundTruthS3Input)((MonitoringGroundTruthS3Input.Builder)MonitoringGroundTruthS3Input.builder().applyMutation(groundTruthS3Input)).build());
        }
    }
}

