/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DeploymentConfiguration;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterSoftwareInstanceGroupSpecification;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterSoftwareInstanceGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateClusterSoftwareRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateClusterSoftwareRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(UpdateClusterSoftwareRequest.getter(UpdateClusterSoftwareRequest::clusterName)).setter(UpdateClusterSoftwareRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<List<UpdateClusterSoftwareInstanceGroupSpecification>> INSTANCE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceGroups").getter(UpdateClusterSoftwareRequest.getter(UpdateClusterSoftwareRequest::instanceGroups)).setter(UpdateClusterSoftwareRequest.setter(Builder::instanceGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateClusterSoftwareInstanceGroupSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeploymentConfig").getter(UpdateClusterSoftwareRequest.getter(UpdateClusterSoftwareRequest::deploymentConfig)).setter(UpdateClusterSoftwareRequest.setter(Builder::deploymentConfig)).constructor(DeploymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, INSTANCE_GROUPS_FIELD, DEPLOYMENT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateClusterSoftwareRequest.memberNameToFieldInitializer();
    private final String clusterName;
    private final List<UpdateClusterSoftwareInstanceGroupSpecification> instanceGroups;
    private final DeploymentConfiguration deploymentConfig;

    private UpdateClusterSoftwareRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.instanceGroups = builder.instanceGroups;
        this.deploymentConfig = builder.deploymentConfig;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final boolean hasInstanceGroups() {
        return this.instanceGroups != null && !(this.instanceGroups instanceof SdkAutoConstructList);
    }

    public final List<UpdateClusterSoftwareInstanceGroupSpecification> instanceGroups() {
        return this.instanceGroups;
    }

    public final DeploymentConfiguration deploymentConfig() {
        return this.deploymentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceGroups() ? this.instanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterSoftwareRequest)) {
            return false;
        }
        UpdateClusterSoftwareRequest other = (UpdateClusterSoftwareRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && this.hasInstanceGroups() == other.hasInstanceGroups() && Objects.equals(this.instanceGroups(), other.instanceGroups()) && Objects.equals(this.deploymentConfig(), other.deploymentConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateClusterSoftwareRequest").add("ClusterName", (Object)this.clusterName()).add("InstanceGroups", this.hasInstanceGroups() ? this.instanceGroups() : null).add("DeploymentConfig", (Object)this.deploymentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "InstanceGroups": {
                return Optional.ofNullable(clazz.cast(this.instanceGroups()));
            }
            case "DeploymentConfig": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("InstanceGroups", INSTANCE_GROUPS_FIELD);
        map.put("DeploymentConfig", DEPLOYMENT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterSoftwareRequest, T> g) {
        return obj -> g.apply((UpdateClusterSoftwareRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private List<UpdateClusterSoftwareInstanceGroupSpecification> instanceGroups = DefaultSdkAutoConstructList.getInstance();
        private DeploymentConfiguration deploymentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterSoftwareRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.instanceGroups(model.instanceGroups);
            this.deploymentConfig(model.deploymentConfig);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final List<UpdateClusterSoftwareInstanceGroupSpecification.Builder> getInstanceGroups() {
            List<UpdateClusterSoftwareInstanceGroupSpecification.Builder> result = UpdateClusterSoftwareInstanceGroupsCopier.copyToBuilder(this.instanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceGroups(Collection<UpdateClusterSoftwareInstanceGroupSpecification.BuilderImpl> instanceGroups) {
            this.instanceGroups = UpdateClusterSoftwareInstanceGroupsCopier.copyFromBuilder(instanceGroups);
        }

        @Override
        public final Builder instanceGroups(Collection<UpdateClusterSoftwareInstanceGroupSpecification> instanceGroups) {
            this.instanceGroups = UpdateClusterSoftwareInstanceGroupsCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(UpdateClusterSoftwareInstanceGroupSpecification ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<UpdateClusterSoftwareInstanceGroupSpecification.Builder> ... instanceGroups) {
            this.instanceGroups(Stream.of(instanceGroups).map(c -> (UpdateClusterSoftwareInstanceGroupSpecification)((UpdateClusterSoftwareInstanceGroupSpecification.Builder)UpdateClusterSoftwareInstanceGroupSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfig() {
            return this.deploymentConfig != null ? this.deploymentConfig.toBuilder() : null;
        }

        public final void setDeploymentConfig(DeploymentConfiguration.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        @Override
        public final Builder deploymentConfig(DeploymentConfiguration deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterSoftwareRequest build() {
            return new UpdateClusterSoftwareRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateClusterSoftwareRequest> {
        public Builder clusterName(String var1);

        public Builder instanceGroups(Collection<UpdateClusterSoftwareInstanceGroupSpecification> var1);

        public Builder instanceGroups(UpdateClusterSoftwareInstanceGroupSpecification ... var1);

        public Builder instanceGroups(Consumer<UpdateClusterSoftwareInstanceGroupSpecification.Builder> ... var1);

        public Builder deploymentConfig(DeploymentConfiguration var1);

        default public Builder deploymentConfig(Consumer<DeploymentConfiguration.Builder> deploymentConfig) {
            return this.deploymentConfig((DeploymentConfiguration)((DeploymentConfiguration.Builder)DeploymentConfiguration.builder().applyMutation(deploymentConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

