/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CustomFileSystemConfig;
import software.amazon.awssdk.services.sagemaker.model.CustomFileSystemConfigsCopier;
import software.amazon.awssdk.services.sagemaker.model.CustomPosixUserConfig;
import software.amazon.awssdk.services.sagemaker.model.DefaultSpaceStorageSettings;
import software.amazon.awssdk.services.sagemaker.model.JupyterLabAppSettings;
import software.amazon.awssdk.services.sagemaker.model.JupyterServerAppSettings;
import software.amazon.awssdk.services.sagemaker.model.KernelGatewayAppSettings;
import software.amazon.awssdk.services.sagemaker.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefaultSpaceSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DefaultSpaceSettings> {
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRole").getter(DefaultSpaceSettings.getter(DefaultSpaceSettings::executionRole)).setter(DefaultSpaceSettings.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(DefaultSpaceSettings.getter(DefaultSpaceSettings::securityGroups)).setter(DefaultSpaceSettings.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<JupyterServerAppSettings> JUPYTER_SERVER_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JupyterServerAppSettings").getter(DefaultSpaceSettings.getter(DefaultSpaceSettings::jupyterServerAppSettings)).setter(DefaultSpaceSettings.setter(Builder::jupyterServerAppSettings)).constructor(JupyterServerAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JupyterServerAppSettings").build()}).build();
    private static final SdkField<KernelGatewayAppSettings> KERNEL_GATEWAY_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KernelGatewayAppSettings").getter(DefaultSpaceSettings.getter(DefaultSpaceSettings::kernelGatewayAppSettings)).setter(DefaultSpaceSettings.setter(Builder::kernelGatewayAppSettings)).constructor(KernelGatewayAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelGatewayAppSettings").build()}).build();
    private static final SdkField<JupyterLabAppSettings> JUPYTER_LAB_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JupyterLabAppSettings").getter(DefaultSpaceSettings.getter(DefaultSpaceSettings::jupyterLabAppSettings)).setter(DefaultSpaceSettings.setter(Builder::jupyterLabAppSettings)).constructor(JupyterLabAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JupyterLabAppSettings").build()}).build();
    private static final SdkField<DefaultSpaceStorageSettings> SPACE_STORAGE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpaceStorageSettings").getter(DefaultSpaceSettings.getter(DefaultSpaceSettings::spaceStorageSettings)).setter(DefaultSpaceSettings.setter(Builder::spaceStorageSettings)).constructor(DefaultSpaceStorageSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceStorageSettings").build()}).build();
    private static final SdkField<CustomPosixUserConfig> CUSTOM_POSIX_USER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomPosixUserConfig").getter(DefaultSpaceSettings.getter(DefaultSpaceSettings::customPosixUserConfig)).setter(DefaultSpaceSettings.setter(Builder::customPosixUserConfig)).constructor(CustomPosixUserConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPosixUserConfig").build()}).build();
    private static final SdkField<List<CustomFileSystemConfig>> CUSTOM_FILE_SYSTEM_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomFileSystemConfigs").getter(DefaultSpaceSettings.getter(DefaultSpaceSettings::customFileSystemConfigs)).setter(DefaultSpaceSettings.setter(Builder::customFileSystemConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomFileSystemConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomFileSystemConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ROLE_FIELD, SECURITY_GROUPS_FIELD, JUPYTER_SERVER_APP_SETTINGS_FIELD, KERNEL_GATEWAY_APP_SETTINGS_FIELD, JUPYTER_LAB_APP_SETTINGS_FIELD, SPACE_STORAGE_SETTINGS_FIELD, CUSTOM_POSIX_USER_CONFIG_FIELD, CUSTOM_FILE_SYSTEM_CONFIGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DefaultSpaceSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String executionRole;
    private final List<String> securityGroups;
    private final JupyterServerAppSettings jupyterServerAppSettings;
    private final KernelGatewayAppSettings kernelGatewayAppSettings;
    private final JupyterLabAppSettings jupyterLabAppSettings;
    private final DefaultSpaceStorageSettings spaceStorageSettings;
    private final CustomPosixUserConfig customPosixUserConfig;
    private final List<CustomFileSystemConfig> customFileSystemConfigs;

    private DefaultSpaceSettings(BuilderImpl builder) {
        this.executionRole = builder.executionRole;
        this.securityGroups = builder.securityGroups;
        this.jupyterServerAppSettings = builder.jupyterServerAppSettings;
        this.kernelGatewayAppSettings = builder.kernelGatewayAppSettings;
        this.jupyterLabAppSettings = builder.jupyterLabAppSettings;
        this.spaceStorageSettings = builder.spaceStorageSettings;
        this.customPosixUserConfig = builder.customPosixUserConfig;
        this.customFileSystemConfigs = builder.customFileSystemConfigs;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final JupyterServerAppSettings jupyterServerAppSettings() {
        return this.jupyterServerAppSettings;
    }

    public final KernelGatewayAppSettings kernelGatewayAppSettings() {
        return this.kernelGatewayAppSettings;
    }

    public final JupyterLabAppSettings jupyterLabAppSettings() {
        return this.jupyterLabAppSettings;
    }

    public final DefaultSpaceStorageSettings spaceStorageSettings() {
        return this.spaceStorageSettings;
    }

    public final CustomPosixUserConfig customPosixUserConfig() {
        return this.customPosixUserConfig;
    }

    public final boolean hasCustomFileSystemConfigs() {
        return this.customFileSystemConfigs != null && !(this.customFileSystemConfigs instanceof SdkAutoConstructList);
    }

    public final List<CustomFileSystemConfig> customFileSystemConfigs() {
        return this.customFileSystemConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jupyterServerAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelGatewayAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.jupyterLabAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceStorageSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPosixUserConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomFileSystemConfigs() ? this.customFileSystemConfigs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultSpaceSettings)) {
            return false;
        }
        DefaultSpaceSettings other = (DefaultSpaceSettings)obj;
        return Objects.equals(this.executionRole(), other.executionRole()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.jupyterServerAppSettings(), other.jupyterServerAppSettings()) && Objects.equals(this.kernelGatewayAppSettings(), other.kernelGatewayAppSettings()) && Objects.equals(this.jupyterLabAppSettings(), other.jupyterLabAppSettings()) && Objects.equals(this.spaceStorageSettings(), other.spaceStorageSettings()) && Objects.equals(this.customPosixUserConfig(), other.customPosixUserConfig()) && this.hasCustomFileSystemConfigs() == other.hasCustomFileSystemConfigs() && Objects.equals(this.customFileSystemConfigs(), other.customFileSystemConfigs());
    }

    public final String toString() {
        return ToString.builder((String)"DefaultSpaceSettings").add("ExecutionRole", (Object)this.executionRole()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("JupyterServerAppSettings", (Object)this.jupyterServerAppSettings()).add("KernelGatewayAppSettings", (Object)this.kernelGatewayAppSettings()).add("JupyterLabAppSettings", (Object)this.jupyterLabAppSettings()).add("SpaceStorageSettings", (Object)this.spaceStorageSettings()).add("CustomPosixUserConfig", (Object)this.customPosixUserConfig()).add("CustomFileSystemConfigs", this.hasCustomFileSystemConfigs() ? this.customFileSystemConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "JupyterServerAppSettings": {
                return Optional.ofNullable(clazz.cast(this.jupyterServerAppSettings()));
            }
            case "KernelGatewayAppSettings": {
                return Optional.ofNullable(clazz.cast(this.kernelGatewayAppSettings()));
            }
            case "JupyterLabAppSettings": {
                return Optional.ofNullable(clazz.cast(this.jupyterLabAppSettings()));
            }
            case "SpaceStorageSettings": {
                return Optional.ofNullable(clazz.cast(this.spaceStorageSettings()));
            }
            case "CustomPosixUserConfig": {
                return Optional.ofNullable(clazz.cast(this.customPosixUserConfig()));
            }
            case "CustomFileSystemConfigs": {
                return Optional.ofNullable(clazz.cast(this.customFileSystemConfigs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExecutionRole", EXECUTION_ROLE_FIELD);
        map.put("SecurityGroups", SECURITY_GROUPS_FIELD);
        map.put("JupyterServerAppSettings", JUPYTER_SERVER_APP_SETTINGS_FIELD);
        map.put("KernelGatewayAppSettings", KERNEL_GATEWAY_APP_SETTINGS_FIELD);
        map.put("JupyterLabAppSettings", JUPYTER_LAB_APP_SETTINGS_FIELD);
        map.put("SpaceStorageSettings", SPACE_STORAGE_SETTINGS_FIELD);
        map.put("CustomPosixUserConfig", CUSTOM_POSIX_USER_CONFIG_FIELD);
        map.put("CustomFileSystemConfigs", CUSTOM_FILE_SYSTEM_CONFIGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultSpaceSettings, T> g) {
        return obj -> g.apply((DefaultSpaceSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionRole;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private JupyterServerAppSettings jupyterServerAppSettings;
        private KernelGatewayAppSettings kernelGatewayAppSettings;
        private JupyterLabAppSettings jupyterLabAppSettings;
        private DefaultSpaceStorageSettings spaceStorageSettings;
        private CustomPosixUserConfig customPosixUserConfig;
        private List<CustomFileSystemConfig> customFileSystemConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultSpaceSettings model) {
            this.executionRole(model.executionRole);
            this.securityGroups(model.securityGroups);
            this.jupyterServerAppSettings(model.jupyterServerAppSettings);
            this.kernelGatewayAppSettings(model.kernelGatewayAppSettings);
            this.jupyterLabAppSettings(model.jupyterLabAppSettings);
            this.spaceStorageSettings(model.spaceStorageSettings);
            this.customPosixUserConfig(model.customPosixUserConfig);
            this.customFileSystemConfigs(model.customFileSystemConfigs);
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final JupyterServerAppSettings.Builder getJupyterServerAppSettings() {
            return this.jupyterServerAppSettings != null ? this.jupyterServerAppSettings.toBuilder() : null;
        }

        public final void setJupyterServerAppSettings(JupyterServerAppSettings.BuilderImpl jupyterServerAppSettings) {
            this.jupyterServerAppSettings = jupyterServerAppSettings != null ? jupyterServerAppSettings.build() : null;
        }

        @Override
        public final Builder jupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings) {
            this.jupyterServerAppSettings = jupyterServerAppSettings;
            return this;
        }

        public final KernelGatewayAppSettings.Builder getKernelGatewayAppSettings() {
            return this.kernelGatewayAppSettings != null ? this.kernelGatewayAppSettings.toBuilder() : null;
        }

        public final void setKernelGatewayAppSettings(KernelGatewayAppSettings.BuilderImpl kernelGatewayAppSettings) {
            this.kernelGatewayAppSettings = kernelGatewayAppSettings != null ? kernelGatewayAppSettings.build() : null;
        }

        @Override
        public final Builder kernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings) {
            this.kernelGatewayAppSettings = kernelGatewayAppSettings;
            return this;
        }

        public final JupyterLabAppSettings.Builder getJupyterLabAppSettings() {
            return this.jupyterLabAppSettings != null ? this.jupyterLabAppSettings.toBuilder() : null;
        }

        public final void setJupyterLabAppSettings(JupyterLabAppSettings.BuilderImpl jupyterLabAppSettings) {
            this.jupyterLabAppSettings = jupyterLabAppSettings != null ? jupyterLabAppSettings.build() : null;
        }

        @Override
        public final Builder jupyterLabAppSettings(JupyterLabAppSettings jupyterLabAppSettings) {
            this.jupyterLabAppSettings = jupyterLabAppSettings;
            return this;
        }

        public final DefaultSpaceStorageSettings.Builder getSpaceStorageSettings() {
            return this.spaceStorageSettings != null ? this.spaceStorageSettings.toBuilder() : null;
        }

        public final void setSpaceStorageSettings(DefaultSpaceStorageSettings.BuilderImpl spaceStorageSettings) {
            this.spaceStorageSettings = spaceStorageSettings != null ? spaceStorageSettings.build() : null;
        }

        @Override
        public final Builder spaceStorageSettings(DefaultSpaceStorageSettings spaceStorageSettings) {
            this.spaceStorageSettings = spaceStorageSettings;
            return this;
        }

        public final CustomPosixUserConfig.Builder getCustomPosixUserConfig() {
            return this.customPosixUserConfig != null ? this.customPosixUserConfig.toBuilder() : null;
        }

        public final void setCustomPosixUserConfig(CustomPosixUserConfig.BuilderImpl customPosixUserConfig) {
            this.customPosixUserConfig = customPosixUserConfig != null ? customPosixUserConfig.build() : null;
        }

        @Override
        public final Builder customPosixUserConfig(CustomPosixUserConfig customPosixUserConfig) {
            this.customPosixUserConfig = customPosixUserConfig;
            return this;
        }

        public final List<CustomFileSystemConfig.Builder> getCustomFileSystemConfigs() {
            List<CustomFileSystemConfig.Builder> result = CustomFileSystemConfigsCopier.copyToBuilder(this.customFileSystemConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomFileSystemConfigs(Collection<CustomFileSystemConfig.BuilderImpl> customFileSystemConfigs) {
            this.customFileSystemConfigs = CustomFileSystemConfigsCopier.copyFromBuilder(customFileSystemConfigs);
        }

        @Override
        public final Builder customFileSystemConfigs(Collection<CustomFileSystemConfig> customFileSystemConfigs) {
            this.customFileSystemConfigs = CustomFileSystemConfigsCopier.copy(customFileSystemConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFileSystemConfigs(CustomFileSystemConfig ... customFileSystemConfigs) {
            this.customFileSystemConfigs(Arrays.asList(customFileSystemConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFileSystemConfigs(Consumer<CustomFileSystemConfig.Builder> ... customFileSystemConfigs) {
            this.customFileSystemConfigs(Stream.of(customFileSystemConfigs).map(c -> (CustomFileSystemConfig)((CustomFileSystemConfig.Builder)CustomFileSystemConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DefaultSpaceSettings build() {
            return new DefaultSpaceSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DefaultSpaceSettings> {
        public Builder executionRole(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder jupyterServerAppSettings(JupyterServerAppSettings var1);

        default public Builder jupyterServerAppSettings(Consumer<JupyterServerAppSettings.Builder> jupyterServerAppSettings) {
            return this.jupyterServerAppSettings((JupyterServerAppSettings)((JupyterServerAppSettings.Builder)JupyterServerAppSettings.builder().applyMutation(jupyterServerAppSettings)).build());
        }

        public Builder kernelGatewayAppSettings(KernelGatewayAppSettings var1);

        default public Builder kernelGatewayAppSettings(Consumer<KernelGatewayAppSettings.Builder> kernelGatewayAppSettings) {
            return this.kernelGatewayAppSettings((KernelGatewayAppSettings)((KernelGatewayAppSettings.Builder)KernelGatewayAppSettings.builder().applyMutation(kernelGatewayAppSettings)).build());
        }

        public Builder jupyterLabAppSettings(JupyterLabAppSettings var1);

        default public Builder jupyterLabAppSettings(Consumer<JupyterLabAppSettings.Builder> jupyterLabAppSettings) {
            return this.jupyterLabAppSettings((JupyterLabAppSettings)((JupyterLabAppSettings.Builder)JupyterLabAppSettings.builder().applyMutation(jupyterLabAppSettings)).build());
        }

        public Builder spaceStorageSettings(DefaultSpaceStorageSettings var1);

        default public Builder spaceStorageSettings(Consumer<DefaultSpaceStorageSettings.Builder> spaceStorageSettings) {
            return this.spaceStorageSettings((DefaultSpaceStorageSettings)((DefaultSpaceStorageSettings.Builder)DefaultSpaceStorageSettings.builder().applyMutation(spaceStorageSettings)).build());
        }

        public Builder customPosixUserConfig(CustomPosixUserConfig var1);

        default public Builder customPosixUserConfig(Consumer<CustomPosixUserConfig.Builder> customPosixUserConfig) {
            return this.customPosixUserConfig((CustomPosixUserConfig)((CustomPosixUserConfig.Builder)CustomPosixUserConfig.builder().applyMutation(customPosixUserConfig)).build());
        }

        public Builder customFileSystemConfigs(Collection<CustomFileSystemConfig> var1);

        public Builder customFileSystemConfigs(CustomFileSystemConfig ... var1);

        public Builder customFileSystemConfigs(Consumer<CustomFileSystemConfig.Builder> ... var1);
    }
}

