/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ErrorInfo;
import software.amazon.awssdk.services.sagemaker.model.PartnerAppAuthType;
import software.amazon.awssdk.services.sagemaker.model.PartnerAppConfig;
import software.amazon.awssdk.services.sagemaker.model.PartnerAppMaintenanceConfig;
import software.amazon.awssdk.services.sagemaker.model.PartnerAppStatus;
import software.amazon.awssdk.services.sagemaker.model.PartnerAppType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePartnerAppResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribePartnerAppResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribePartnerAppResponse.getter(DescribePartnerAppResponse::arn)).setter(DescribePartnerAppResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribePartnerAppResponse.getter(DescribePartnerAppResponse::name)).setter(DescribePartnerAppResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DescribePartnerAppResponse.getter(DescribePartnerAppResponse::typeAsString)).setter(DescribePartnerAppResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribePartnerAppResponse.getter(DescribePartnerAppResponse::statusAsString)).setter(DescribePartnerAppResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribePartnerAppResponse.getter(DescribePartnerAppResponse::creationTime)).setter(DescribePartnerAppResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribePartnerAppResponse.getter(DescribePartnerAppResponse::lastModifiedTime)).setter(DescribePartnerAppResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(DescribePartnerAppResponse.getter(DescribePartnerAppResponse::executionRoleArn)).setter(DescribePartnerAppResponse.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(DescribePartnerAppResponse.getter(DescribePartnerAppResponse::kmsKeyId)).setter(DescribePartnerAppResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> BASE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseUrl").getter(DescribePartnerAppResponse.getter(DescribePartnerAppResponse::baseUrl)).setter(DescribePartnerAppResponse.setter(Builder::baseUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseUrl").build()}).build();
    private static final SdkField<PartnerAppMaintenanceConfig> MAINTENANCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceConfig").getter(DescribePartnerAppResponse.getter(DescribePartnerAppResponse::maintenanceConfig)).setter(DescribePartnerAppResponse.setter(Builder::maintenanceConfig)).constructor(PartnerAppMaintenanceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceConfig").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(DescribePartnerAppResponse.getter(DescribePartnerAppResponse::tier)).setter(DescribePartnerAppResponse.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(DescribePartnerAppResponse.getter(DescribePartnerAppResponse::version)).setter(DescribePartnerAppResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<PartnerAppConfig> APPLICATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationConfig").getter(DescribePartnerAppResponse.getter(DescribePartnerAppResponse::applicationConfig)).setter(DescribePartnerAppResponse.setter(Builder::applicationConfig)).constructor(PartnerAppConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationConfig").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthType").getter(DescribePartnerAppResponse.getter(DescribePartnerAppResponse::authTypeAsString)).setter(DescribePartnerAppResponse.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()}).build();
    private static final SdkField<Boolean> ENABLE_IAM_SESSION_BASED_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableIamSessionBasedIdentity").getter(DescribePartnerAppResponse.getter(DescribePartnerAppResponse::enableIamSessionBasedIdentity)).setter(DescribePartnerAppResponse.setter(Builder::enableIamSessionBasedIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIamSessionBasedIdentity").build()}).build();
    private static final SdkField<ErrorInfo> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(DescribePartnerAppResponse.getter(DescribePartnerAppResponse::error)).setter(DescribePartnerAppResponse.setter(Builder::error)).constructor(ErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, TYPE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, EXECUTION_ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, BASE_URL_FIELD, MAINTENANCE_CONFIG_FIELD, TIER_FIELD, VERSION_FIELD, APPLICATION_CONFIG_FIELD, AUTH_TYPE_FIELD, ENABLE_IAM_SESSION_BASED_IDENTITY_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribePartnerAppResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String name;
    private final String type;
    private final String status;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String executionRoleArn;
    private final String kmsKeyId;
    private final String baseUrl;
    private final PartnerAppMaintenanceConfig maintenanceConfig;
    private final String tier;
    private final String version;
    private final PartnerAppConfig applicationConfig;
    private final String authType;
    private final Boolean enableIamSessionBasedIdentity;
    private final ErrorInfo error;

    private DescribePartnerAppResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.executionRoleArn = builder.executionRoleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.baseUrl = builder.baseUrl;
        this.maintenanceConfig = builder.maintenanceConfig;
        this.tier = builder.tier;
        this.version = builder.version;
        this.applicationConfig = builder.applicationConfig;
        this.authType = builder.authType;
        this.enableIamSessionBasedIdentity = builder.enableIamSessionBasedIdentity;
        this.error = builder.error;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final PartnerAppType type() {
        return PartnerAppType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final PartnerAppStatus status() {
        return PartnerAppStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String baseUrl() {
        return this.baseUrl;
    }

    public final PartnerAppMaintenanceConfig maintenanceConfig() {
        return this.maintenanceConfig;
    }

    public final String tier() {
        return this.tier;
    }

    public final String version() {
        return this.version;
    }

    public final PartnerAppConfig applicationConfig() {
        return this.applicationConfig;
    }

    public final PartnerAppAuthType authType() {
        return PartnerAppAuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final Boolean enableIamSessionBasedIdentity() {
        return this.enableIamSessionBasedIdentity;
    }

    public final ErrorInfo error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.tier());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIamSessionBasedIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePartnerAppResponse)) {
            return false;
        }
        DescribePartnerAppResponse other = (DescribePartnerAppResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.baseUrl(), other.baseUrl()) && Objects.equals(this.maintenanceConfig(), other.maintenanceConfig()) && Objects.equals(this.tier(), other.tier()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.applicationConfig(), other.applicationConfig()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.enableIamSessionBasedIdentity(), other.enableIamSessionBasedIdentity()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePartnerAppResponse").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("KmsKeyId", (Object)this.kmsKeyId()).add("BaseUrl", (Object)this.baseUrl()).add("MaintenanceConfig", (Object)this.maintenanceConfig()).add("Tier", (Object)this.tier()).add("Version", (Object)this.version()).add("ApplicationConfig", (Object)this.applicationConfig()).add("AuthType", (Object)this.authTypeAsString()).add("EnableIamSessionBasedIdentity", (Object)this.enableIamSessionBasedIdentity()).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "BaseUrl": {
                return Optional.ofNullable(clazz.cast(this.baseUrl()));
            }
            case "MaintenanceConfig": {
                return Optional.ofNullable(clazz.cast(this.maintenanceConfig()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tier()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "ApplicationConfig": {
                return Optional.ofNullable(clazz.cast(this.applicationConfig()));
            }
            case "AuthType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "EnableIamSessionBasedIdentity": {
                return Optional.ofNullable(clazz.cast(this.enableIamSessionBasedIdentity()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("BaseUrl", BASE_URL_FIELD);
        map.put("MaintenanceConfig", MAINTENANCE_CONFIG_FIELD);
        map.put("Tier", TIER_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("ApplicationConfig", APPLICATION_CONFIG_FIELD);
        map.put("AuthType", AUTH_TYPE_FIELD);
        map.put("EnableIamSessionBasedIdentity", ENABLE_IAM_SESSION_BASED_IDENTITY_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePartnerAppResponse, T> g) {
        return obj -> g.apply((DescribePartnerAppResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String type;
        private String status;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String executionRoleArn;
        private String kmsKeyId;
        private String baseUrl;
        private PartnerAppMaintenanceConfig maintenanceConfig;
        private String tier;
        private String version;
        private PartnerAppConfig applicationConfig;
        private String authType;
        private Boolean enableIamSessionBasedIdentity;
        private ErrorInfo error;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePartnerAppResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.type(model.type);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.executionRoleArn(model.executionRoleArn);
            this.kmsKeyId(model.kmsKeyId);
            this.baseUrl(model.baseUrl);
            this.maintenanceConfig(model.maintenanceConfig);
            this.tier(model.tier);
            this.version(model.version);
            this.applicationConfig(model.applicationConfig);
            this.authType(model.authType);
            this.enableIamSessionBasedIdentity(model.enableIamSessionBasedIdentity);
            this.error(model.error);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PartnerAppType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PartnerAppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getBaseUrl() {
            return this.baseUrl;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final PartnerAppMaintenanceConfig.Builder getMaintenanceConfig() {
            return this.maintenanceConfig != null ? this.maintenanceConfig.toBuilder() : null;
        }

        public final void setMaintenanceConfig(PartnerAppMaintenanceConfig.BuilderImpl maintenanceConfig) {
            this.maintenanceConfig = maintenanceConfig != null ? maintenanceConfig.build() : null;
        }

        @Override
        public final Builder maintenanceConfig(PartnerAppMaintenanceConfig maintenanceConfig) {
            this.maintenanceConfig = maintenanceConfig;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final PartnerAppConfig.Builder getApplicationConfig() {
            return this.applicationConfig != null ? this.applicationConfig.toBuilder() : null;
        }

        public final void setApplicationConfig(PartnerAppConfig.BuilderImpl applicationConfig) {
            this.applicationConfig = applicationConfig != null ? applicationConfig.build() : null;
        }

        @Override
        public final Builder applicationConfig(PartnerAppConfig applicationConfig) {
            this.applicationConfig = applicationConfig;
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(PartnerAppAuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final Boolean getEnableIamSessionBasedIdentity() {
            return this.enableIamSessionBasedIdentity;
        }

        public final void setEnableIamSessionBasedIdentity(Boolean enableIamSessionBasedIdentity) {
            this.enableIamSessionBasedIdentity = enableIamSessionBasedIdentity;
        }

        @Override
        public final Builder enableIamSessionBasedIdentity(Boolean enableIamSessionBasedIdentity) {
            this.enableIamSessionBasedIdentity = enableIamSessionBasedIdentity;
            return this;
        }

        public final ErrorInfo.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorInfo.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorInfo error) {
            this.error = error;
            return this;
        }

        @Override
        public DescribePartnerAppResponse build() {
            return new DescribePartnerAppResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePartnerAppResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(PartnerAppType var1);

        public Builder status(String var1);

        public Builder status(PartnerAppStatus var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder executionRoleArn(String var1);

        public Builder kmsKeyId(String var1);

        public Builder baseUrl(String var1);

        public Builder maintenanceConfig(PartnerAppMaintenanceConfig var1);

        default public Builder maintenanceConfig(Consumer<PartnerAppMaintenanceConfig.Builder> maintenanceConfig) {
            return this.maintenanceConfig((PartnerAppMaintenanceConfig)((PartnerAppMaintenanceConfig.Builder)PartnerAppMaintenanceConfig.builder().applyMutation(maintenanceConfig)).build());
        }

        public Builder tier(String var1);

        public Builder version(String var1);

        public Builder applicationConfig(PartnerAppConfig var1);

        default public Builder applicationConfig(Consumer<PartnerAppConfig.Builder> applicationConfig) {
            return this.applicationConfig((PartnerAppConfig)((PartnerAppConfig.Builder)PartnerAppConfig.builder().applyMutation(applicationConfig)).build());
        }

        public Builder authType(String var1);

        public Builder authType(PartnerAppAuthType var1);

        public Builder enableIamSessionBasedIdentity(Boolean var1);

        public Builder error(ErrorInfo var1);

        default public Builder error(Consumer<ErrorInfo.Builder> error) {
            return this.error((ErrorInfo)((ErrorInfo.Builder)ErrorInfo.builder().applyMutation(error)).build());
        }
    }
}

