/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.FairShare;
import software.amazon.awssdk.services.sagemaker.model.PriorityClass;
import software.amazon.awssdk.services.sagemaker.model.PriorityClassListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchedulerConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchedulerConfig> {
    private static final SdkField<List<PriorityClass>> PRIORITY_CLASSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PriorityClasses").getter(SchedulerConfig.getter(SchedulerConfig::priorityClasses)).setter(SchedulerConfig.setter(Builder::priorityClasses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriorityClasses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PriorityClass::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FAIR_SHARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FairShare").getter(SchedulerConfig.getter(SchedulerConfig::fairShareAsString)).setter(SchedulerConfig.setter(Builder::fairShare)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FairShare").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIORITY_CLASSES_FIELD, FAIR_SHARE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SchedulerConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<PriorityClass> priorityClasses;
    private final String fairShare;

    private SchedulerConfig(BuilderImpl builder) {
        this.priorityClasses = builder.priorityClasses;
        this.fairShare = builder.fairShare;
    }

    public final boolean hasPriorityClasses() {
        return this.priorityClasses != null && !(this.priorityClasses instanceof SdkAutoConstructList);
    }

    public final List<PriorityClass> priorityClasses() {
        return this.priorityClasses;
    }

    public final FairShare fairShare() {
        return FairShare.fromValue(this.fairShare);
    }

    public final String fairShareAsString() {
        return this.fairShare;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPriorityClasses() ? this.priorityClasses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fairShareAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchedulerConfig)) {
            return false;
        }
        SchedulerConfig other = (SchedulerConfig)obj;
        return this.hasPriorityClasses() == other.hasPriorityClasses() && Objects.equals(this.priorityClasses(), other.priorityClasses()) && Objects.equals(this.fairShareAsString(), other.fairShareAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SchedulerConfig").add("PriorityClasses", this.hasPriorityClasses() ? this.priorityClasses() : null).add("FairShare", (Object)this.fairShareAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PriorityClasses": {
                return Optional.ofNullable(clazz.cast(this.priorityClasses()));
            }
            case "FairShare": {
                return Optional.ofNullable(clazz.cast(this.fairShareAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PriorityClasses", PRIORITY_CLASSES_FIELD);
        map.put("FairShare", FAIR_SHARE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchedulerConfig, T> g) {
        return obj -> g.apply((SchedulerConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PriorityClass> priorityClasses = DefaultSdkAutoConstructList.getInstance();
        private String fairShare;

        private BuilderImpl() {
        }

        private BuilderImpl(SchedulerConfig model) {
            this.priorityClasses(model.priorityClasses);
            this.fairShare(model.fairShare);
        }

        public final List<PriorityClass.Builder> getPriorityClasses() {
            List<PriorityClass.Builder> result = PriorityClassListCopier.copyToBuilder(this.priorityClasses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPriorityClasses(Collection<PriorityClass.BuilderImpl> priorityClasses) {
            this.priorityClasses = PriorityClassListCopier.copyFromBuilder(priorityClasses);
        }

        @Override
        public final Builder priorityClasses(Collection<PriorityClass> priorityClasses) {
            this.priorityClasses = PriorityClassListCopier.copy(priorityClasses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priorityClasses(PriorityClass ... priorityClasses) {
            this.priorityClasses(Arrays.asList(priorityClasses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priorityClasses(Consumer<PriorityClass.Builder> ... priorityClasses) {
            this.priorityClasses(Stream.of(priorityClasses).map(c -> (PriorityClass)((PriorityClass.Builder)PriorityClass.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFairShare() {
            return this.fairShare;
        }

        public final void setFairShare(String fairShare) {
            this.fairShare = fairShare;
        }

        @Override
        public final Builder fairShare(String fairShare) {
            this.fairShare = fairShare;
            return this;
        }

        @Override
        public final Builder fairShare(FairShare fairShare) {
            this.fairShare(fairShare == null ? null : fairShare.toString());
            return this;
        }

        public SchedulerConfig build() {
            return new SchedulerConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchedulerConfig> {
        public Builder priorityClasses(Collection<PriorityClass> var1);

        public Builder priorityClasses(PriorityClass ... var1);

        public Builder priorityClasses(Consumer<PriorityClass.Builder> ... var1);

        public Builder fairShare(String var1);

        public Builder fairShare(FairShare var1);
    }
}

