/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AlarmDetails;
import software.amazon.awssdk.services.sagemaker.model.AutoRollbackAlarmsCopier;
import software.amazon.awssdk.services.sagemaker.model.RollingDeploymentPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentConfiguration> {
    private static final SdkField<RollingDeploymentPolicy> ROLLING_UPDATE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RollingUpdatePolicy").getter(DeploymentConfiguration.getter(DeploymentConfiguration::rollingUpdatePolicy)).setter(DeploymentConfiguration.setter(Builder::rollingUpdatePolicy)).constructor(RollingDeploymentPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollingUpdatePolicy").build()}).build();
    private static final SdkField<Integer> WAIT_INTERVAL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WaitIntervalInSeconds").getter(DeploymentConfiguration.getter(DeploymentConfiguration::waitIntervalInSeconds)).setter(DeploymentConfiguration.setter(Builder::waitIntervalInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitIntervalInSeconds").build()}).build();
    private static final SdkField<List<AlarmDetails>> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutoRollbackConfiguration").getter(DeploymentConfiguration.getter(DeploymentConfiguration::autoRollbackConfiguration)).setter(DeploymentConfiguration.setter(Builder::autoRollbackConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRollbackConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlarmDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLLING_UPDATE_POLICY_FIELD, WAIT_INTERVAL_IN_SECONDS_FIELD, AUTO_ROLLBACK_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeploymentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RollingDeploymentPolicy rollingUpdatePolicy;
    private final Integer waitIntervalInSeconds;
    private final List<AlarmDetails> autoRollbackConfiguration;

    private DeploymentConfiguration(BuilderImpl builder) {
        this.rollingUpdatePolicy = builder.rollingUpdatePolicy;
        this.waitIntervalInSeconds = builder.waitIntervalInSeconds;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
    }

    public final RollingDeploymentPolicy rollingUpdatePolicy() {
        return this.rollingUpdatePolicy;
    }

    public final Integer waitIntervalInSeconds() {
        return this.waitIntervalInSeconds;
    }

    public final boolean hasAutoRollbackConfiguration() {
        return this.autoRollbackConfiguration != null && !(this.autoRollbackConfiguration instanceof SdkAutoConstructList);
    }

    public final List<AlarmDetails> autoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rollingUpdatePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitIntervalInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoRollbackConfiguration() ? this.autoRollbackConfiguration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfiguration)) {
            return false;
        }
        DeploymentConfiguration other = (DeploymentConfiguration)obj;
        return Objects.equals(this.rollingUpdatePolicy(), other.rollingUpdatePolicy()) && Objects.equals(this.waitIntervalInSeconds(), other.waitIntervalInSeconds()) && this.hasAutoRollbackConfiguration() == other.hasAutoRollbackConfiguration() && Objects.equals(this.autoRollbackConfiguration(), other.autoRollbackConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentConfiguration").add("RollingUpdatePolicy", (Object)this.rollingUpdatePolicy()).add("WaitIntervalInSeconds", (Object)this.waitIntervalInSeconds()).add("AutoRollbackConfiguration", this.hasAutoRollbackConfiguration() ? this.autoRollbackConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RollingUpdatePolicy": {
                return Optional.ofNullable(clazz.cast(this.rollingUpdatePolicy()));
            }
            case "WaitIntervalInSeconds": {
                return Optional.ofNullable(clazz.cast(this.waitIntervalInSeconds()));
            }
            case "AutoRollbackConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoRollbackConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RollingUpdatePolicy", ROLLING_UPDATE_POLICY_FIELD);
        map.put("WaitIntervalInSeconds", WAIT_INTERVAL_IN_SECONDS_FIELD);
        map.put("AutoRollbackConfiguration", AUTO_ROLLBACK_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentConfiguration, T> g) {
        return obj -> g.apply((DeploymentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RollingDeploymentPolicy rollingUpdatePolicy;
        private Integer waitIntervalInSeconds;
        private List<AlarmDetails> autoRollbackConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfiguration model) {
            this.rollingUpdatePolicy(model.rollingUpdatePolicy);
            this.waitIntervalInSeconds(model.waitIntervalInSeconds);
            this.autoRollbackConfiguration(model.autoRollbackConfiguration);
        }

        public final RollingDeploymentPolicy.Builder getRollingUpdatePolicy() {
            return this.rollingUpdatePolicy != null ? this.rollingUpdatePolicy.toBuilder() : null;
        }

        public final void setRollingUpdatePolicy(RollingDeploymentPolicy.BuilderImpl rollingUpdatePolicy) {
            this.rollingUpdatePolicy = rollingUpdatePolicy != null ? rollingUpdatePolicy.build() : null;
        }

        @Override
        public final Builder rollingUpdatePolicy(RollingDeploymentPolicy rollingUpdatePolicy) {
            this.rollingUpdatePolicy = rollingUpdatePolicy;
            return this;
        }

        public final Integer getWaitIntervalInSeconds() {
            return this.waitIntervalInSeconds;
        }

        public final void setWaitIntervalInSeconds(Integer waitIntervalInSeconds) {
            this.waitIntervalInSeconds = waitIntervalInSeconds;
        }

        @Override
        public final Builder waitIntervalInSeconds(Integer waitIntervalInSeconds) {
            this.waitIntervalInSeconds = waitIntervalInSeconds;
            return this;
        }

        public final List<AlarmDetails.Builder> getAutoRollbackConfiguration() {
            List<AlarmDetails.Builder> result = AutoRollbackAlarmsCopier.copyToBuilder(this.autoRollbackConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoRollbackConfiguration(Collection<AlarmDetails.BuilderImpl> autoRollbackConfiguration) {
            this.autoRollbackConfiguration = AutoRollbackAlarmsCopier.copyFromBuilder(autoRollbackConfiguration);
        }

        @Override
        public final Builder autoRollbackConfiguration(Collection<AlarmDetails> autoRollbackConfiguration) {
            this.autoRollbackConfiguration = AutoRollbackAlarmsCopier.copy(autoRollbackConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoRollbackConfiguration(AlarmDetails ... autoRollbackConfiguration) {
            this.autoRollbackConfiguration(Arrays.asList(autoRollbackConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoRollbackConfiguration(Consumer<AlarmDetails.Builder> ... autoRollbackConfiguration) {
            this.autoRollbackConfiguration(Stream.of(autoRollbackConfiguration).map(c -> (AlarmDetails)((AlarmDetails.Builder)AlarmDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DeploymentConfiguration build() {
            return new DeploymentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentConfiguration> {
        public Builder rollingUpdatePolicy(RollingDeploymentPolicy var1);

        default public Builder rollingUpdatePolicy(Consumer<RollingDeploymentPolicy.Builder> rollingUpdatePolicy) {
            return this.rollingUpdatePolicy((RollingDeploymentPolicy)((RollingDeploymentPolicy.Builder)RollingDeploymentPolicy.builder().applyMutation(rollingUpdatePolicy)).build());
        }

        public Builder waitIntervalInSeconds(Integer var1);

        public Builder autoRollbackConfiguration(Collection<AlarmDetails> var1);

        public Builder autoRollbackConfiguration(AlarmDetails ... var1);

        public Builder autoRollbackConfiguration(Consumer<AlarmDetails.Builder> ... var1);
    }
}

