/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AppType;
import software.amazon.awssdk.services.sagemaker.model.CustomFileSystem;
import software.amazon.awssdk.services.sagemaker.model.CustomFileSystemsCopier;
import software.amazon.awssdk.services.sagemaker.model.JupyterServerAppSettings;
import software.amazon.awssdk.services.sagemaker.model.KernelGatewayAppSettings;
import software.amazon.awssdk.services.sagemaker.model.SpaceCodeEditorAppSettings;
import software.amazon.awssdk.services.sagemaker.model.SpaceJupyterLabAppSettings;
import software.amazon.awssdk.services.sagemaker.model.SpaceStorageSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpaceSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpaceSettings> {
    private static final SdkField<JupyterServerAppSettings> JUPYTER_SERVER_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JupyterServerAppSettings").getter(SpaceSettings.getter(SpaceSettings::jupyterServerAppSettings)).setter(SpaceSettings.setter(Builder::jupyterServerAppSettings)).constructor(JupyterServerAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JupyterServerAppSettings").build()}).build();
    private static final SdkField<KernelGatewayAppSettings> KERNEL_GATEWAY_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KernelGatewayAppSettings").getter(SpaceSettings.getter(SpaceSettings::kernelGatewayAppSettings)).setter(SpaceSettings.setter(Builder::kernelGatewayAppSettings)).constructor(KernelGatewayAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelGatewayAppSettings").build()}).build();
    private static final SdkField<SpaceCodeEditorAppSettings> CODE_EDITOR_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodeEditorAppSettings").getter(SpaceSettings.getter(SpaceSettings::codeEditorAppSettings)).setter(SpaceSettings.setter(Builder::codeEditorAppSettings)).constructor(SpaceCodeEditorAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeEditorAppSettings").build()}).build();
    private static final SdkField<SpaceJupyterLabAppSettings> JUPYTER_LAB_APP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JupyterLabAppSettings").getter(SpaceSettings.getter(SpaceSettings::jupyterLabAppSettings)).setter(SpaceSettings.setter(Builder::jupyterLabAppSettings)).constructor(SpaceJupyterLabAppSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JupyterLabAppSettings").build()}).build();
    private static final SdkField<String> APP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppType").getter(SpaceSettings.getter(SpaceSettings::appTypeAsString)).setter(SpaceSettings.setter(Builder::appType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppType").build()}).build();
    private static final SdkField<SpaceStorageSettings> SPACE_STORAGE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpaceStorageSettings").getter(SpaceSettings.getter(SpaceSettings::spaceStorageSettings)).setter(SpaceSettings.setter(Builder::spaceStorageSettings)).constructor(SpaceStorageSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceStorageSettings").build()}).build();
    private static final SdkField<List<CustomFileSystem>> CUSTOM_FILE_SYSTEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomFileSystems").getter(SpaceSettings.getter(SpaceSettings::customFileSystems)).setter(SpaceSettings.setter(Builder::customFileSystems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomFileSystems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomFileSystem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JUPYTER_SERVER_APP_SETTINGS_FIELD, KERNEL_GATEWAY_APP_SETTINGS_FIELD, CODE_EDITOR_APP_SETTINGS_FIELD, JUPYTER_LAB_APP_SETTINGS_FIELD, APP_TYPE_FIELD, SPACE_STORAGE_SETTINGS_FIELD, CUSTOM_FILE_SYSTEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SpaceSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final JupyterServerAppSettings jupyterServerAppSettings;
    private final KernelGatewayAppSettings kernelGatewayAppSettings;
    private final SpaceCodeEditorAppSettings codeEditorAppSettings;
    private final SpaceJupyterLabAppSettings jupyterLabAppSettings;
    private final String appType;
    private final SpaceStorageSettings spaceStorageSettings;
    private final List<CustomFileSystem> customFileSystems;

    private SpaceSettings(BuilderImpl builder) {
        this.jupyterServerAppSettings = builder.jupyterServerAppSettings;
        this.kernelGatewayAppSettings = builder.kernelGatewayAppSettings;
        this.codeEditorAppSettings = builder.codeEditorAppSettings;
        this.jupyterLabAppSettings = builder.jupyterLabAppSettings;
        this.appType = builder.appType;
        this.spaceStorageSettings = builder.spaceStorageSettings;
        this.customFileSystems = builder.customFileSystems;
    }

    public final JupyterServerAppSettings jupyterServerAppSettings() {
        return this.jupyterServerAppSettings;
    }

    public final KernelGatewayAppSettings kernelGatewayAppSettings() {
        return this.kernelGatewayAppSettings;
    }

    public final SpaceCodeEditorAppSettings codeEditorAppSettings() {
        return this.codeEditorAppSettings;
    }

    public final SpaceJupyterLabAppSettings jupyterLabAppSettings() {
        return this.jupyterLabAppSettings;
    }

    public final AppType appType() {
        return AppType.fromValue(this.appType);
    }

    public final String appTypeAsString() {
        return this.appType;
    }

    public final SpaceStorageSettings spaceStorageSettings() {
        return this.spaceStorageSettings;
    }

    public final boolean hasCustomFileSystems() {
        return this.customFileSystems != null && !(this.customFileSystems instanceof SdkAutoConstructList);
    }

    public final List<CustomFileSystem> customFileSystems() {
        return this.customFileSystems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jupyterServerAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelGatewayAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeEditorAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.jupyterLabAppSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.appTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceStorageSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomFileSystems() ? this.customFileSystems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceSettings)) {
            return false;
        }
        SpaceSettings other = (SpaceSettings)obj;
        return Objects.equals(this.jupyterServerAppSettings(), other.jupyterServerAppSettings()) && Objects.equals(this.kernelGatewayAppSettings(), other.kernelGatewayAppSettings()) && Objects.equals(this.codeEditorAppSettings(), other.codeEditorAppSettings()) && Objects.equals(this.jupyterLabAppSettings(), other.jupyterLabAppSettings()) && Objects.equals(this.appTypeAsString(), other.appTypeAsString()) && Objects.equals(this.spaceStorageSettings(), other.spaceStorageSettings()) && this.hasCustomFileSystems() == other.hasCustomFileSystems() && Objects.equals(this.customFileSystems(), other.customFileSystems());
    }

    public final String toString() {
        return ToString.builder((String)"SpaceSettings").add("JupyterServerAppSettings", (Object)this.jupyterServerAppSettings()).add("KernelGatewayAppSettings", (Object)this.kernelGatewayAppSettings()).add("CodeEditorAppSettings", (Object)this.codeEditorAppSettings()).add("JupyterLabAppSettings", (Object)this.jupyterLabAppSettings()).add("AppType", (Object)this.appTypeAsString()).add("SpaceStorageSettings", (Object)this.spaceStorageSettings()).add("CustomFileSystems", this.hasCustomFileSystems() ? this.customFileSystems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JupyterServerAppSettings": {
                return Optional.ofNullable(clazz.cast(this.jupyterServerAppSettings()));
            }
            case "KernelGatewayAppSettings": {
                return Optional.ofNullable(clazz.cast(this.kernelGatewayAppSettings()));
            }
            case "CodeEditorAppSettings": {
                return Optional.ofNullable(clazz.cast(this.codeEditorAppSettings()));
            }
            case "JupyterLabAppSettings": {
                return Optional.ofNullable(clazz.cast(this.jupyterLabAppSettings()));
            }
            case "AppType": {
                return Optional.ofNullable(clazz.cast(this.appTypeAsString()));
            }
            case "SpaceStorageSettings": {
                return Optional.ofNullable(clazz.cast(this.spaceStorageSettings()));
            }
            case "CustomFileSystems": {
                return Optional.ofNullable(clazz.cast(this.customFileSystems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JupyterServerAppSettings", JUPYTER_SERVER_APP_SETTINGS_FIELD);
        map.put("KernelGatewayAppSettings", KERNEL_GATEWAY_APP_SETTINGS_FIELD);
        map.put("CodeEditorAppSettings", CODE_EDITOR_APP_SETTINGS_FIELD);
        map.put("JupyterLabAppSettings", JUPYTER_LAB_APP_SETTINGS_FIELD);
        map.put("AppType", APP_TYPE_FIELD);
        map.put("SpaceStorageSettings", SPACE_STORAGE_SETTINGS_FIELD);
        map.put("CustomFileSystems", CUSTOM_FILE_SYSTEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpaceSettings, T> g) {
        return obj -> g.apply((SpaceSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private JupyterServerAppSettings jupyterServerAppSettings;
        private KernelGatewayAppSettings kernelGatewayAppSettings;
        private SpaceCodeEditorAppSettings codeEditorAppSettings;
        private SpaceJupyterLabAppSettings jupyterLabAppSettings;
        private String appType;
        private SpaceStorageSettings spaceStorageSettings;
        private List<CustomFileSystem> customFileSystems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SpaceSettings model) {
            this.jupyterServerAppSettings(model.jupyterServerAppSettings);
            this.kernelGatewayAppSettings(model.kernelGatewayAppSettings);
            this.codeEditorAppSettings(model.codeEditorAppSettings);
            this.jupyterLabAppSettings(model.jupyterLabAppSettings);
            this.appType(model.appType);
            this.spaceStorageSettings(model.spaceStorageSettings);
            this.customFileSystems(model.customFileSystems);
        }

        public final JupyterServerAppSettings.Builder getJupyterServerAppSettings() {
            return this.jupyterServerAppSettings != null ? this.jupyterServerAppSettings.toBuilder() : null;
        }

        public final void setJupyterServerAppSettings(JupyterServerAppSettings.BuilderImpl jupyterServerAppSettings) {
            this.jupyterServerAppSettings = jupyterServerAppSettings != null ? jupyterServerAppSettings.build() : null;
        }

        @Override
        public final Builder jupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings) {
            this.jupyterServerAppSettings = jupyterServerAppSettings;
            return this;
        }

        public final KernelGatewayAppSettings.Builder getKernelGatewayAppSettings() {
            return this.kernelGatewayAppSettings != null ? this.kernelGatewayAppSettings.toBuilder() : null;
        }

        public final void setKernelGatewayAppSettings(KernelGatewayAppSettings.BuilderImpl kernelGatewayAppSettings) {
            this.kernelGatewayAppSettings = kernelGatewayAppSettings != null ? kernelGatewayAppSettings.build() : null;
        }

        @Override
        public final Builder kernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings) {
            this.kernelGatewayAppSettings = kernelGatewayAppSettings;
            return this;
        }

        public final SpaceCodeEditorAppSettings.Builder getCodeEditorAppSettings() {
            return this.codeEditorAppSettings != null ? this.codeEditorAppSettings.toBuilder() : null;
        }

        public final void setCodeEditorAppSettings(SpaceCodeEditorAppSettings.BuilderImpl codeEditorAppSettings) {
            this.codeEditorAppSettings = codeEditorAppSettings != null ? codeEditorAppSettings.build() : null;
        }

        @Override
        public final Builder codeEditorAppSettings(SpaceCodeEditorAppSettings codeEditorAppSettings) {
            this.codeEditorAppSettings = codeEditorAppSettings;
            return this;
        }

        public final SpaceJupyterLabAppSettings.Builder getJupyterLabAppSettings() {
            return this.jupyterLabAppSettings != null ? this.jupyterLabAppSettings.toBuilder() : null;
        }

        public final void setJupyterLabAppSettings(SpaceJupyterLabAppSettings.BuilderImpl jupyterLabAppSettings) {
            this.jupyterLabAppSettings = jupyterLabAppSettings != null ? jupyterLabAppSettings.build() : null;
        }

        @Override
        public final Builder jupyterLabAppSettings(SpaceJupyterLabAppSettings jupyterLabAppSettings) {
            this.jupyterLabAppSettings = jupyterLabAppSettings;
            return this;
        }

        public final String getAppType() {
            return this.appType;
        }

        public final void setAppType(String appType) {
            this.appType = appType;
        }

        @Override
        public final Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Override
        public final Builder appType(AppType appType) {
            this.appType(appType == null ? null : appType.toString());
            return this;
        }

        public final SpaceStorageSettings.Builder getSpaceStorageSettings() {
            return this.spaceStorageSettings != null ? this.spaceStorageSettings.toBuilder() : null;
        }

        public final void setSpaceStorageSettings(SpaceStorageSettings.BuilderImpl spaceStorageSettings) {
            this.spaceStorageSettings = spaceStorageSettings != null ? spaceStorageSettings.build() : null;
        }

        @Override
        public final Builder spaceStorageSettings(SpaceStorageSettings spaceStorageSettings) {
            this.spaceStorageSettings = spaceStorageSettings;
            return this;
        }

        public final List<CustomFileSystem.Builder> getCustomFileSystems() {
            List<CustomFileSystem.Builder> result = CustomFileSystemsCopier.copyToBuilder(this.customFileSystems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomFileSystems(Collection<CustomFileSystem.BuilderImpl> customFileSystems) {
            this.customFileSystems = CustomFileSystemsCopier.copyFromBuilder(customFileSystems);
        }

        @Override
        public final Builder customFileSystems(Collection<CustomFileSystem> customFileSystems) {
            this.customFileSystems = CustomFileSystemsCopier.copy(customFileSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFileSystems(CustomFileSystem ... customFileSystems) {
            this.customFileSystems(Arrays.asList(customFileSystems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFileSystems(Consumer<CustomFileSystem.Builder> ... customFileSystems) {
            this.customFileSystems(Stream.of(customFileSystems).map(c -> (CustomFileSystem)((CustomFileSystem.Builder)CustomFileSystem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SpaceSettings build() {
            return new SpaceSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpaceSettings> {
        public Builder jupyterServerAppSettings(JupyterServerAppSettings var1);

        default public Builder jupyterServerAppSettings(Consumer<JupyterServerAppSettings.Builder> jupyterServerAppSettings) {
            return this.jupyterServerAppSettings((JupyterServerAppSettings)((JupyterServerAppSettings.Builder)JupyterServerAppSettings.builder().applyMutation(jupyterServerAppSettings)).build());
        }

        public Builder kernelGatewayAppSettings(KernelGatewayAppSettings var1);

        default public Builder kernelGatewayAppSettings(Consumer<KernelGatewayAppSettings.Builder> kernelGatewayAppSettings) {
            return this.kernelGatewayAppSettings((KernelGatewayAppSettings)((KernelGatewayAppSettings.Builder)KernelGatewayAppSettings.builder().applyMutation(kernelGatewayAppSettings)).build());
        }

        public Builder codeEditorAppSettings(SpaceCodeEditorAppSettings var1);

        default public Builder codeEditorAppSettings(Consumer<SpaceCodeEditorAppSettings.Builder> codeEditorAppSettings) {
            return this.codeEditorAppSettings((SpaceCodeEditorAppSettings)((SpaceCodeEditorAppSettings.Builder)SpaceCodeEditorAppSettings.builder().applyMutation(codeEditorAppSettings)).build());
        }

        public Builder jupyterLabAppSettings(SpaceJupyterLabAppSettings var1);

        default public Builder jupyterLabAppSettings(Consumer<SpaceJupyterLabAppSettings.Builder> jupyterLabAppSettings) {
            return this.jupyterLabAppSettings((SpaceJupyterLabAppSettings)((SpaceJupyterLabAppSettings.Builder)SpaceJupyterLabAppSettings.builder().applyMutation(jupyterLabAppSettings)).build());
        }

        public Builder appType(String var1);

        public Builder appType(AppType var1);

        public Builder spaceStorageSettings(SpaceStorageSettings var1);

        default public Builder spaceStorageSettings(Consumer<SpaceStorageSettings.Builder> spaceStorageSettings) {
            return this.spaceStorageSettings((SpaceStorageSettings)((SpaceStorageSettings.Builder)SpaceStorageSettings.builder().applyMutation(spaceStorageSettings)).build());
        }

        public Builder customFileSystems(Collection<CustomFileSystem> var1);

        public Builder customFileSystems(CustomFileSystem ... var1);

        public Builder customFileSystems(Consumer<CustomFileSystem.Builder> ... var1);
    }
}

