/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CapacitySize;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RollingUpdatePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RollingUpdatePolicy> {
    private static final SdkField<CapacitySize> MAXIMUM_BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaximumBatchSize").getter(RollingUpdatePolicy.getter(RollingUpdatePolicy::maximumBatchSize)).setter(RollingUpdatePolicy.setter(Builder::maximumBatchSize)).constructor(CapacitySize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchSize").build()}).build();
    private static final SdkField<Integer> WAIT_INTERVAL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WaitIntervalInSeconds").getter(RollingUpdatePolicy.getter(RollingUpdatePolicy::waitIntervalInSeconds)).setter(RollingUpdatePolicy.setter(Builder::waitIntervalInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitIntervalInSeconds").build()}).build();
    private static final SdkField<Integer> MAXIMUM_EXECUTION_TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumExecutionTimeoutInSeconds").getter(RollingUpdatePolicy.getter(RollingUpdatePolicy::maximumExecutionTimeoutInSeconds)).setter(RollingUpdatePolicy.setter(Builder::maximumExecutionTimeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumExecutionTimeoutInSeconds").build()}).build();
    private static final SdkField<CapacitySize> ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RollbackMaximumBatchSize").getter(RollingUpdatePolicy.getter(RollingUpdatePolicy::rollbackMaximumBatchSize)).setter(RollingUpdatePolicy.setter(Builder::rollbackMaximumBatchSize)).constructor(CapacitySize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackMaximumBatchSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_BATCH_SIZE_FIELD, WAIT_INTERVAL_IN_SECONDS_FIELD, MAXIMUM_EXECUTION_TIMEOUT_IN_SECONDS_FIELD, ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RollingUpdatePolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CapacitySize maximumBatchSize;
    private final Integer waitIntervalInSeconds;
    private final Integer maximumExecutionTimeoutInSeconds;
    private final CapacitySize rollbackMaximumBatchSize;

    private RollingUpdatePolicy(BuilderImpl builder) {
        this.maximumBatchSize = builder.maximumBatchSize;
        this.waitIntervalInSeconds = builder.waitIntervalInSeconds;
        this.maximumExecutionTimeoutInSeconds = builder.maximumExecutionTimeoutInSeconds;
        this.rollbackMaximumBatchSize = builder.rollbackMaximumBatchSize;
    }

    public final CapacitySize maximumBatchSize() {
        return this.maximumBatchSize;
    }

    public final Integer waitIntervalInSeconds() {
        return this.waitIntervalInSeconds;
    }

    public final Integer maximumExecutionTimeoutInSeconds() {
        return this.maximumExecutionTimeoutInSeconds;
    }

    public final CapacitySize rollbackMaximumBatchSize() {
        return this.rollbackMaximumBatchSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBatchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitIntervalInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumExecutionTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackMaximumBatchSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RollingUpdatePolicy)) {
            return false;
        }
        RollingUpdatePolicy other = (RollingUpdatePolicy)obj;
        return Objects.equals(this.maximumBatchSize(), other.maximumBatchSize()) && Objects.equals(this.waitIntervalInSeconds(), other.waitIntervalInSeconds()) && Objects.equals(this.maximumExecutionTimeoutInSeconds(), other.maximumExecutionTimeoutInSeconds()) && Objects.equals(this.rollbackMaximumBatchSize(), other.rollbackMaximumBatchSize());
    }

    public final String toString() {
        return ToString.builder((String)"RollingUpdatePolicy").add("MaximumBatchSize", (Object)this.maximumBatchSize()).add("WaitIntervalInSeconds", (Object)this.waitIntervalInSeconds()).add("MaximumExecutionTimeoutInSeconds", (Object)this.maximumExecutionTimeoutInSeconds()).add("RollbackMaximumBatchSize", (Object)this.rollbackMaximumBatchSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaximumBatchSize": {
                return Optional.ofNullable(clazz.cast(this.maximumBatchSize()));
            }
            case "WaitIntervalInSeconds": {
                return Optional.ofNullable(clazz.cast(this.waitIntervalInSeconds()));
            }
            case "MaximumExecutionTimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumExecutionTimeoutInSeconds()));
            }
            case "RollbackMaximumBatchSize": {
                return Optional.ofNullable(clazz.cast(this.rollbackMaximumBatchSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MaximumBatchSize", MAXIMUM_BATCH_SIZE_FIELD);
        map.put("WaitIntervalInSeconds", WAIT_INTERVAL_IN_SECONDS_FIELD);
        map.put("MaximumExecutionTimeoutInSeconds", MAXIMUM_EXECUTION_TIMEOUT_IN_SECONDS_FIELD);
        map.put("RollbackMaximumBatchSize", ROLLBACK_MAXIMUM_BATCH_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RollingUpdatePolicy, T> g) {
        return obj -> g.apply((RollingUpdatePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CapacitySize maximumBatchSize;
        private Integer waitIntervalInSeconds;
        private Integer maximumExecutionTimeoutInSeconds;
        private CapacitySize rollbackMaximumBatchSize;

        private BuilderImpl() {
        }

        private BuilderImpl(RollingUpdatePolicy model) {
            this.maximumBatchSize(model.maximumBatchSize);
            this.waitIntervalInSeconds(model.waitIntervalInSeconds);
            this.maximumExecutionTimeoutInSeconds(model.maximumExecutionTimeoutInSeconds);
            this.rollbackMaximumBatchSize(model.rollbackMaximumBatchSize);
        }

        public final CapacitySize.Builder getMaximumBatchSize() {
            return this.maximumBatchSize != null ? this.maximumBatchSize.toBuilder() : null;
        }

        public final void setMaximumBatchSize(CapacitySize.BuilderImpl maximumBatchSize) {
            this.maximumBatchSize = maximumBatchSize != null ? maximumBatchSize.build() : null;
        }

        @Override
        public final Builder maximumBatchSize(CapacitySize maximumBatchSize) {
            this.maximumBatchSize = maximumBatchSize;
            return this;
        }

        public final Integer getWaitIntervalInSeconds() {
            return this.waitIntervalInSeconds;
        }

        public final void setWaitIntervalInSeconds(Integer waitIntervalInSeconds) {
            this.waitIntervalInSeconds = waitIntervalInSeconds;
        }

        @Override
        public final Builder waitIntervalInSeconds(Integer waitIntervalInSeconds) {
            this.waitIntervalInSeconds = waitIntervalInSeconds;
            return this;
        }

        public final Integer getMaximumExecutionTimeoutInSeconds() {
            return this.maximumExecutionTimeoutInSeconds;
        }

        public final void setMaximumExecutionTimeoutInSeconds(Integer maximumExecutionTimeoutInSeconds) {
            this.maximumExecutionTimeoutInSeconds = maximumExecutionTimeoutInSeconds;
        }

        @Override
        public final Builder maximumExecutionTimeoutInSeconds(Integer maximumExecutionTimeoutInSeconds) {
            this.maximumExecutionTimeoutInSeconds = maximumExecutionTimeoutInSeconds;
            return this;
        }

        public final CapacitySize.Builder getRollbackMaximumBatchSize() {
            return this.rollbackMaximumBatchSize != null ? this.rollbackMaximumBatchSize.toBuilder() : null;
        }

        public final void setRollbackMaximumBatchSize(CapacitySize.BuilderImpl rollbackMaximumBatchSize) {
            this.rollbackMaximumBatchSize = rollbackMaximumBatchSize != null ? rollbackMaximumBatchSize.build() : null;
        }

        @Override
        public final Builder rollbackMaximumBatchSize(CapacitySize rollbackMaximumBatchSize) {
            this.rollbackMaximumBatchSize = rollbackMaximumBatchSize;
            return this;
        }

        public RollingUpdatePolicy build() {
            return new RollingUpdatePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RollingUpdatePolicy> {
        public Builder maximumBatchSize(CapacitySize var1);

        default public Builder maximumBatchSize(Consumer<CapacitySize.Builder> maximumBatchSize) {
            return this.maximumBatchSize((CapacitySize)((CapacitySize.Builder)CapacitySize.builder().applyMutation(maximumBatchSize)).build());
        }

        public Builder waitIntervalInSeconds(Integer var1);

        public Builder maximumExecutionTimeoutInSeconds(Integer var1);

        public Builder rollbackMaximumBatchSize(CapacitySize var1);

        default public Builder rollbackMaximumBatchSize(Consumer<CapacitySize.Builder> rollbackMaximumBatchSize) {
            return this.rollbackMaximumBatchSize((CapacitySize)((CapacitySize.Builder)CapacitySize.builder().applyMutation(rollbackMaximumBatchSize)).build());
        }
    }
}

