/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ClusterSchedulerConfigSummary;
import software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsResponse;

public class ListClusterSchedulerConfigsIterable
implements SdkIterable<ListClusterSchedulerConfigsResponse> {
    private final SageMakerClient client;
    private final ListClusterSchedulerConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClusterSchedulerConfigsIterable(SageMakerClient client, ListClusterSchedulerConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListClusterSchedulerConfigsResponseFetcher();
    }

    public Iterator<ListClusterSchedulerConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClusterSchedulerConfigSummary> clusterSchedulerConfigSummaries() {
        Function<ListClusterSchedulerConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterSchedulerConfigSummaries() != null) {
                return response.clusterSchedulerConfigSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClusterSchedulerConfigsResponseFetcher
    implements SyncPageFetcher<ListClusterSchedulerConfigsResponse> {
        private ListClusterSchedulerConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListClusterSchedulerConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClusterSchedulerConfigsResponse nextPage(ListClusterSchedulerConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListClusterSchedulerConfigsIterable.this.client.listClusterSchedulerConfigs(ListClusterSchedulerConfigsIterable.this.firstRequest);
            }
            return ListClusterSchedulerConfigsIterable.this.client.listClusterSchedulerConfigs((ListClusterSchedulerConfigsRequest)((Object)ListClusterSchedulerConfigsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

