/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentRuntimeConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInferenceComponentRuntimeConfigRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateInferenceComponentRuntimeConfigRequest> {
    private static final SdkField<String> INFERENCE_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceComponentName").getter(UpdateInferenceComponentRuntimeConfigRequest.getter(UpdateInferenceComponentRuntimeConfigRequest::inferenceComponentName)).setter(UpdateInferenceComponentRuntimeConfigRequest.setter(Builder::inferenceComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceComponentName").build()}).build();
    private static final SdkField<InferenceComponentRuntimeConfig> DESIRED_RUNTIME_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DesiredRuntimeConfig").getter(UpdateInferenceComponentRuntimeConfigRequest.getter(UpdateInferenceComponentRuntimeConfigRequest::desiredRuntimeConfig)).setter(UpdateInferenceComponentRuntimeConfigRequest.setter(Builder::desiredRuntimeConfig)).constructor(InferenceComponentRuntimeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredRuntimeConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_COMPONENT_NAME_FIELD, DESIRED_RUNTIME_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateInferenceComponentRuntimeConfigRequest.memberNameToFieldInitializer();
    private final String inferenceComponentName;
    private final InferenceComponentRuntimeConfig desiredRuntimeConfig;

    private UpdateInferenceComponentRuntimeConfigRequest(BuilderImpl builder) {
        super(builder);
        this.inferenceComponentName = builder.inferenceComponentName;
        this.desiredRuntimeConfig = builder.desiredRuntimeConfig;
    }

    public final String inferenceComponentName() {
        return this.inferenceComponentName;
    }

    public final InferenceComponentRuntimeConfig desiredRuntimeConfig() {
        return this.desiredRuntimeConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredRuntimeConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInferenceComponentRuntimeConfigRequest)) {
            return false;
        }
        UpdateInferenceComponentRuntimeConfigRequest other = (UpdateInferenceComponentRuntimeConfigRequest)((Object)obj);
        return Objects.equals(this.inferenceComponentName(), other.inferenceComponentName()) && Objects.equals(this.desiredRuntimeConfig(), other.desiredRuntimeConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateInferenceComponentRuntimeConfigRequest").add("InferenceComponentName", (Object)this.inferenceComponentName()).add("DesiredRuntimeConfig", (Object)this.desiredRuntimeConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InferenceComponentName": {
                return Optional.ofNullable(clazz.cast(this.inferenceComponentName()));
            }
            case "DesiredRuntimeConfig": {
                return Optional.ofNullable(clazz.cast(this.desiredRuntimeConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InferenceComponentName", INFERENCE_COMPONENT_NAME_FIELD);
        map.put("DesiredRuntimeConfig", DESIRED_RUNTIME_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateInferenceComponentRuntimeConfigRequest, T> g) {
        return obj -> g.apply((UpdateInferenceComponentRuntimeConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String inferenceComponentName;
        private InferenceComponentRuntimeConfig desiredRuntimeConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInferenceComponentRuntimeConfigRequest model) {
            super(model);
            this.inferenceComponentName(model.inferenceComponentName);
            this.desiredRuntimeConfig(model.desiredRuntimeConfig);
        }

        public final String getInferenceComponentName() {
            return this.inferenceComponentName;
        }

        public final void setInferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
        }

        @Override
        public final Builder inferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
            return this;
        }

        public final InferenceComponentRuntimeConfig.Builder getDesiredRuntimeConfig() {
            return this.desiredRuntimeConfig != null ? this.desiredRuntimeConfig.toBuilder() : null;
        }

        public final void setDesiredRuntimeConfig(InferenceComponentRuntimeConfig.BuilderImpl desiredRuntimeConfig) {
            this.desiredRuntimeConfig = desiredRuntimeConfig != null ? desiredRuntimeConfig.build() : null;
        }

        @Override
        public final Builder desiredRuntimeConfig(InferenceComponentRuntimeConfig desiredRuntimeConfig) {
            this.desiredRuntimeConfig = desiredRuntimeConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInferenceComponentRuntimeConfigRequest build() {
            return new UpdateInferenceComponentRuntimeConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInferenceComponentRuntimeConfigRequest> {
        public Builder inferenceComponentName(String var1);

        public Builder desiredRuntimeConfig(InferenceComponentRuntimeConfig var1);

        default public Builder desiredRuntimeConfig(Consumer<InferenceComponentRuntimeConfig.Builder> desiredRuntimeConfig) {
            return this.desiredRuntimeConfig((InferenceComponentRuntimeConfig)((InferenceComponentRuntimeConfig.Builder)InferenceComponentRuntimeConfig.builder().applyMutation(desiredRuntimeConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

