/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus;
import software.amazon.awssdk.services.sagemaker.model.TargetDevice;
import software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator;
import software.amazon.awssdk.services.sagemaker.model.TargetPlatformArch;
import software.amazon.awssdk.services.sagemaker.model.TargetPlatformOs;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompilationJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompilationJobSummary> {
    private static final SdkField<String> COMPILATION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationJobName").getter(CompilationJobSummary.getter(CompilationJobSummary::compilationJobName)).setter(CompilationJobSummary.setter(Builder::compilationJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobName").build()}).build();
    private static final SdkField<String> COMPILATION_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationJobArn").getter(CompilationJobSummary.getter(CompilationJobSummary::compilationJobArn)).setter(CompilationJobSummary.setter(Builder::compilationJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(CompilationJobSummary.getter(CompilationJobSummary::creationTime)).setter(CompilationJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> COMPILATION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompilationStartTime").getter(CompilationJobSummary.getter(CompilationJobSummary::compilationStartTime)).setter(CompilationJobSummary.setter(Builder::compilationStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationStartTime").build()}).build();
    private static final SdkField<Instant> COMPILATION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompilationEndTime").getter(CompilationJobSummary.getter(CompilationJobSummary::compilationEndTime)).setter(CompilationJobSummary.setter(Builder::compilationEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationEndTime").build()}).build();
    private static final SdkField<String> COMPILATION_TARGET_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationTargetDevice").getter(CompilationJobSummary.getter(CompilationJobSummary::compilationTargetDeviceAsString)).setter(CompilationJobSummary.setter(Builder::compilationTargetDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationTargetDevice").build()}).build();
    private static final SdkField<String> COMPILATION_TARGET_PLATFORM_OS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationTargetPlatformOs").getter(CompilationJobSummary.getter(CompilationJobSummary::compilationTargetPlatformOsAsString)).setter(CompilationJobSummary.setter(Builder::compilationTargetPlatformOs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationTargetPlatformOs").build()}).build();
    private static final SdkField<String> COMPILATION_TARGET_PLATFORM_ARCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationTargetPlatformArch").getter(CompilationJobSummary.getter(CompilationJobSummary::compilationTargetPlatformArchAsString)).setter(CompilationJobSummary.setter(Builder::compilationTargetPlatformArch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationTargetPlatformArch").build()}).build();
    private static final SdkField<String> COMPILATION_TARGET_PLATFORM_ACCELERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationTargetPlatformAccelerator").getter(CompilationJobSummary.getter(CompilationJobSummary::compilationTargetPlatformAcceleratorAsString)).setter(CompilationJobSummary.setter(Builder::compilationTargetPlatformAccelerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationTargetPlatformAccelerator").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(CompilationJobSummary.getter(CompilationJobSummary::lastModifiedTime)).setter(CompilationJobSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> COMPILATION_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationJobStatus").getter(CompilationJobSummary.getter(CompilationJobSummary::compilationJobStatusAsString)).setter(CompilationJobSummary.setter(Builder::compilationJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPILATION_JOB_NAME_FIELD, COMPILATION_JOB_ARN_FIELD, CREATION_TIME_FIELD, COMPILATION_START_TIME_FIELD, COMPILATION_END_TIME_FIELD, COMPILATION_TARGET_DEVICE_FIELD, COMPILATION_TARGET_PLATFORM_OS_FIELD, COMPILATION_TARGET_PLATFORM_ARCH_FIELD, COMPILATION_TARGET_PLATFORM_ACCELERATOR_FIELD, LAST_MODIFIED_TIME_FIELD, COMPILATION_JOB_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CompilationJobSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String compilationJobName;
    private final String compilationJobArn;
    private final Instant creationTime;
    private final Instant compilationStartTime;
    private final Instant compilationEndTime;
    private final String compilationTargetDevice;
    private final String compilationTargetPlatformOs;
    private final String compilationTargetPlatformArch;
    private final String compilationTargetPlatformAccelerator;
    private final Instant lastModifiedTime;
    private final String compilationJobStatus;

    private CompilationJobSummary(BuilderImpl builder) {
        this.compilationJobName = builder.compilationJobName;
        this.compilationJobArn = builder.compilationJobArn;
        this.creationTime = builder.creationTime;
        this.compilationStartTime = builder.compilationStartTime;
        this.compilationEndTime = builder.compilationEndTime;
        this.compilationTargetDevice = builder.compilationTargetDevice;
        this.compilationTargetPlatformOs = builder.compilationTargetPlatformOs;
        this.compilationTargetPlatformArch = builder.compilationTargetPlatformArch;
        this.compilationTargetPlatformAccelerator = builder.compilationTargetPlatformAccelerator;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.compilationJobStatus = builder.compilationJobStatus;
    }

    public final String compilationJobName() {
        return this.compilationJobName;
    }

    public final String compilationJobArn() {
        return this.compilationJobArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant compilationStartTime() {
        return this.compilationStartTime;
    }

    public final Instant compilationEndTime() {
        return this.compilationEndTime;
    }

    public final TargetDevice compilationTargetDevice() {
        return TargetDevice.fromValue(this.compilationTargetDevice);
    }

    public final String compilationTargetDeviceAsString() {
        return this.compilationTargetDevice;
    }

    public final TargetPlatformOs compilationTargetPlatformOs() {
        return TargetPlatformOs.fromValue(this.compilationTargetPlatformOs);
    }

    public final String compilationTargetPlatformOsAsString() {
        return this.compilationTargetPlatformOs;
    }

    public final TargetPlatformArch compilationTargetPlatformArch() {
        return TargetPlatformArch.fromValue(this.compilationTargetPlatformArch);
    }

    public final String compilationTargetPlatformArchAsString() {
        return this.compilationTargetPlatformArch;
    }

    public final TargetPlatformAccelerator compilationTargetPlatformAccelerator() {
        return TargetPlatformAccelerator.fromValue(this.compilationTargetPlatformAccelerator);
    }

    public final String compilationTargetPlatformAcceleratorAsString() {
        return this.compilationTargetPlatformAccelerator;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final CompilationJobStatus compilationJobStatus() {
        return CompilationJobStatus.fromValue(this.compilationJobStatus);
    }

    public final String compilationJobStatusAsString() {
        return this.compilationJobStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationTargetDeviceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationTargetPlatformOsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationTargetPlatformArchAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationTargetPlatformAcceleratorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompilationJobSummary)) {
            return false;
        }
        CompilationJobSummary other = (CompilationJobSummary)obj;
        return Objects.equals(this.compilationJobName(), other.compilationJobName()) && Objects.equals(this.compilationJobArn(), other.compilationJobArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.compilationStartTime(), other.compilationStartTime()) && Objects.equals(this.compilationEndTime(), other.compilationEndTime()) && Objects.equals(this.compilationTargetDeviceAsString(), other.compilationTargetDeviceAsString()) && Objects.equals(this.compilationTargetPlatformOsAsString(), other.compilationTargetPlatformOsAsString()) && Objects.equals(this.compilationTargetPlatformArchAsString(), other.compilationTargetPlatformArchAsString()) && Objects.equals(this.compilationTargetPlatformAcceleratorAsString(), other.compilationTargetPlatformAcceleratorAsString()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.compilationJobStatusAsString(), other.compilationJobStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CompilationJobSummary").add("CompilationJobName", (Object)this.compilationJobName()).add("CompilationJobArn", (Object)this.compilationJobArn()).add("CreationTime", (Object)this.creationTime()).add("CompilationStartTime", (Object)this.compilationStartTime()).add("CompilationEndTime", (Object)this.compilationEndTime()).add("CompilationTargetDevice", (Object)this.compilationTargetDeviceAsString()).add("CompilationTargetPlatformOs", (Object)this.compilationTargetPlatformOsAsString()).add("CompilationTargetPlatformArch", (Object)this.compilationTargetPlatformArchAsString()).add("CompilationTargetPlatformAccelerator", (Object)this.compilationTargetPlatformAcceleratorAsString()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("CompilationJobStatus", (Object)this.compilationJobStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompilationJobName": {
                return Optional.ofNullable(clazz.cast(this.compilationJobName()));
            }
            case "CompilationJobArn": {
                return Optional.ofNullable(clazz.cast(this.compilationJobArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CompilationStartTime": {
                return Optional.ofNullable(clazz.cast(this.compilationStartTime()));
            }
            case "CompilationEndTime": {
                return Optional.ofNullable(clazz.cast(this.compilationEndTime()));
            }
            case "CompilationTargetDevice": {
                return Optional.ofNullable(clazz.cast(this.compilationTargetDeviceAsString()));
            }
            case "CompilationTargetPlatformOs": {
                return Optional.ofNullable(clazz.cast(this.compilationTargetPlatformOsAsString()));
            }
            case "CompilationTargetPlatformArch": {
                return Optional.ofNullable(clazz.cast(this.compilationTargetPlatformArchAsString()));
            }
            case "CompilationTargetPlatformAccelerator": {
                return Optional.ofNullable(clazz.cast(this.compilationTargetPlatformAcceleratorAsString()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "CompilationJobStatus": {
                return Optional.ofNullable(clazz.cast(this.compilationJobStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CompilationJobName", COMPILATION_JOB_NAME_FIELD);
        map.put("CompilationJobArn", COMPILATION_JOB_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CompilationStartTime", COMPILATION_START_TIME_FIELD);
        map.put("CompilationEndTime", COMPILATION_END_TIME_FIELD);
        map.put("CompilationTargetDevice", COMPILATION_TARGET_DEVICE_FIELD);
        map.put("CompilationTargetPlatformOs", COMPILATION_TARGET_PLATFORM_OS_FIELD);
        map.put("CompilationTargetPlatformArch", COMPILATION_TARGET_PLATFORM_ARCH_FIELD);
        map.put("CompilationTargetPlatformAccelerator", COMPILATION_TARGET_PLATFORM_ACCELERATOR_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("CompilationJobStatus", COMPILATION_JOB_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompilationJobSummary, T> g) {
        return obj -> g.apply((CompilationJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String compilationJobName;
        private String compilationJobArn;
        private Instant creationTime;
        private Instant compilationStartTime;
        private Instant compilationEndTime;
        private String compilationTargetDevice;
        private String compilationTargetPlatformOs;
        private String compilationTargetPlatformArch;
        private String compilationTargetPlatformAccelerator;
        private Instant lastModifiedTime;
        private String compilationJobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CompilationJobSummary model) {
            this.compilationJobName(model.compilationJobName);
            this.compilationJobArn(model.compilationJobArn);
            this.creationTime(model.creationTime);
            this.compilationStartTime(model.compilationStartTime);
            this.compilationEndTime(model.compilationEndTime);
            this.compilationTargetDevice(model.compilationTargetDevice);
            this.compilationTargetPlatformOs(model.compilationTargetPlatformOs);
            this.compilationTargetPlatformArch(model.compilationTargetPlatformArch);
            this.compilationTargetPlatformAccelerator(model.compilationTargetPlatformAccelerator);
            this.lastModifiedTime(model.lastModifiedTime);
            this.compilationJobStatus(model.compilationJobStatus);
        }

        public final String getCompilationJobName() {
            return this.compilationJobName;
        }

        public final void setCompilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
        }

        @Override
        public final Builder compilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
            return this;
        }

        public final String getCompilationJobArn() {
            return this.compilationJobArn;
        }

        public final void setCompilationJobArn(String compilationJobArn) {
            this.compilationJobArn = compilationJobArn;
        }

        @Override
        public final Builder compilationJobArn(String compilationJobArn) {
            this.compilationJobArn = compilationJobArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompilationStartTime() {
            return this.compilationStartTime;
        }

        public final void setCompilationStartTime(Instant compilationStartTime) {
            this.compilationStartTime = compilationStartTime;
        }

        @Override
        public final Builder compilationStartTime(Instant compilationStartTime) {
            this.compilationStartTime = compilationStartTime;
            return this;
        }

        public final Instant getCompilationEndTime() {
            return this.compilationEndTime;
        }

        public final void setCompilationEndTime(Instant compilationEndTime) {
            this.compilationEndTime = compilationEndTime;
        }

        @Override
        public final Builder compilationEndTime(Instant compilationEndTime) {
            this.compilationEndTime = compilationEndTime;
            return this;
        }

        public final String getCompilationTargetDevice() {
            return this.compilationTargetDevice;
        }

        public final void setCompilationTargetDevice(String compilationTargetDevice) {
            this.compilationTargetDevice = compilationTargetDevice;
        }

        @Override
        public final Builder compilationTargetDevice(String compilationTargetDevice) {
            this.compilationTargetDevice = compilationTargetDevice;
            return this;
        }

        @Override
        public final Builder compilationTargetDevice(TargetDevice compilationTargetDevice) {
            this.compilationTargetDevice(compilationTargetDevice == null ? null : compilationTargetDevice.toString());
            return this;
        }

        public final String getCompilationTargetPlatformOs() {
            return this.compilationTargetPlatformOs;
        }

        public final void setCompilationTargetPlatformOs(String compilationTargetPlatformOs) {
            this.compilationTargetPlatformOs = compilationTargetPlatformOs;
        }

        @Override
        public final Builder compilationTargetPlatformOs(String compilationTargetPlatformOs) {
            this.compilationTargetPlatformOs = compilationTargetPlatformOs;
            return this;
        }

        @Override
        public final Builder compilationTargetPlatformOs(TargetPlatformOs compilationTargetPlatformOs) {
            this.compilationTargetPlatformOs(compilationTargetPlatformOs == null ? null : compilationTargetPlatformOs.toString());
            return this;
        }

        public final String getCompilationTargetPlatformArch() {
            return this.compilationTargetPlatformArch;
        }

        public final void setCompilationTargetPlatformArch(String compilationTargetPlatformArch) {
            this.compilationTargetPlatformArch = compilationTargetPlatformArch;
        }

        @Override
        public final Builder compilationTargetPlatformArch(String compilationTargetPlatformArch) {
            this.compilationTargetPlatformArch = compilationTargetPlatformArch;
            return this;
        }

        @Override
        public final Builder compilationTargetPlatformArch(TargetPlatformArch compilationTargetPlatformArch) {
            this.compilationTargetPlatformArch(compilationTargetPlatformArch == null ? null : compilationTargetPlatformArch.toString());
            return this;
        }

        public final String getCompilationTargetPlatformAccelerator() {
            return this.compilationTargetPlatformAccelerator;
        }

        public final void setCompilationTargetPlatformAccelerator(String compilationTargetPlatformAccelerator) {
            this.compilationTargetPlatformAccelerator = compilationTargetPlatformAccelerator;
        }

        @Override
        public final Builder compilationTargetPlatformAccelerator(String compilationTargetPlatformAccelerator) {
            this.compilationTargetPlatformAccelerator = compilationTargetPlatformAccelerator;
            return this;
        }

        @Override
        public final Builder compilationTargetPlatformAccelerator(TargetPlatformAccelerator compilationTargetPlatformAccelerator) {
            this.compilationTargetPlatformAccelerator(compilationTargetPlatformAccelerator == null ? null : compilationTargetPlatformAccelerator.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getCompilationJobStatus() {
            return this.compilationJobStatus;
        }

        public final void setCompilationJobStatus(String compilationJobStatus) {
            this.compilationJobStatus = compilationJobStatus;
        }

        @Override
        public final Builder compilationJobStatus(String compilationJobStatus) {
            this.compilationJobStatus = compilationJobStatus;
            return this;
        }

        @Override
        public final Builder compilationJobStatus(CompilationJobStatus compilationJobStatus) {
            this.compilationJobStatus(compilationJobStatus == null ? null : compilationJobStatus.toString());
            return this;
        }

        public CompilationJobSummary build() {
            return new CompilationJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompilationJobSummary> {
        public Builder compilationJobName(String var1);

        public Builder compilationJobArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder compilationStartTime(Instant var1);

        public Builder compilationEndTime(Instant var1);

        public Builder compilationTargetDevice(String var1);

        public Builder compilationTargetDevice(TargetDevice var1);

        public Builder compilationTargetPlatformOs(String var1);

        public Builder compilationTargetPlatformOs(TargetPlatformOs var1);

        public Builder compilationTargetPlatformArch(String var1);

        public Builder compilationTargetPlatformArch(TargetPlatformArch var1);

        public Builder compilationTargetPlatformAccelerator(String var1);

        public Builder compilationTargetPlatformAccelerator(TargetPlatformAccelerator var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder compilationJobStatus(String var1);

        public Builder compilationJobStatus(CompilationJobStatus var1);
    }
}

