/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AttributeNamesCopier;
import software.amazon.awssdk.services.sagemaker.model.HubAccessConfig;
import software.amazon.awssdk.services.sagemaker.model.InstanceGroupNamesCopier;
import software.amazon.awssdk.services.sagemaker.model.ModelAccessConfig;
import software.amazon.awssdk.services.sagemaker.model.S3DataDistribution;
import software.amazon.awssdk.services.sagemaker.model.S3DataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DataSource> {
    private static final SdkField<String> S3_DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3DataType").getter(S3DataSource.getter(S3DataSource::s3DataTypeAsString)).setter(S3DataSource.setter(Builder::s3DataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataType").build()}).build();
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Uri").getter(S3DataSource.getter(S3DataSource::s3Uri)).setter(S3DataSource.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final SdkField<String> S3_DATA_DISTRIBUTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3DataDistributionType").getter(S3DataSource.getter(S3DataSource::s3DataDistributionTypeAsString)).setter(S3DataSource.setter(Builder::s3DataDistributionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataDistributionType").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeNames").getter(S3DataSource.getter(S3DataSource::attributeNames)).setter(S3DataSource.setter(Builder::attributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INSTANCE_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceGroupNames").getter(S3DataSource.getter(S3DataSource::instanceGroupNames)).setter(S3DataSource.setter(Builder::instanceGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ModelAccessConfig> MODEL_ACCESS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelAccessConfig").getter(S3DataSource.getter(S3DataSource::modelAccessConfig)).setter(S3DataSource.setter(Builder::modelAccessConfig)).constructor(ModelAccessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelAccessConfig").build()}).build();
    private static final SdkField<HubAccessConfig> HUB_ACCESS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HubAccessConfig").getter(S3DataSource.getter(S3DataSource::hubAccessConfig)).setter(S3DataSource.setter(Builder::hubAccessConfig)).constructor(HubAccessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubAccessConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_TYPE_FIELD, S3_URI_FIELD, S3_DATA_DISTRIBUTION_TYPE_FIELD, ATTRIBUTE_NAMES_FIELD, INSTANCE_GROUP_NAMES_FIELD, MODEL_ACCESS_CONFIG_FIELD, HUB_ACCESS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3DataSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3DataType;
    private final String s3Uri;
    private final String s3DataDistributionType;
    private final List<String> attributeNames;
    private final List<String> instanceGroupNames;
    private final ModelAccessConfig modelAccessConfig;
    private final HubAccessConfig hubAccessConfig;

    private S3DataSource(BuilderImpl builder) {
        this.s3DataType = builder.s3DataType;
        this.s3Uri = builder.s3Uri;
        this.s3DataDistributionType = builder.s3DataDistributionType;
        this.attributeNames = builder.attributeNames;
        this.instanceGroupNames = builder.instanceGroupNames;
        this.modelAccessConfig = builder.modelAccessConfig;
        this.hubAccessConfig = builder.hubAccessConfig;
    }

    public final S3DataType s3DataType() {
        return S3DataType.fromValue(this.s3DataType);
    }

    public final String s3DataTypeAsString() {
        return this.s3DataType;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final S3DataDistribution s3DataDistributionType() {
        return S3DataDistribution.fromValue(this.s3DataDistributionType);
    }

    public final String s3DataDistributionTypeAsString() {
        return this.s3DataDistributionType;
    }

    public final boolean hasAttributeNames() {
        return this.attributeNames != null && !(this.attributeNames instanceof SdkAutoConstructList);
    }

    public final List<String> attributeNames() {
        return this.attributeNames;
    }

    public final boolean hasInstanceGroupNames() {
        return this.instanceGroupNames != null && !(this.instanceGroupNames instanceof SdkAutoConstructList);
    }

    public final List<String> instanceGroupNames() {
        return this.instanceGroupNames;
    }

    public final ModelAccessConfig modelAccessConfig() {
        return this.modelAccessConfig;
    }

    public final HubAccessConfig hubAccessConfig() {
        return this.hubAccessConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataDistributionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeNames() ? this.attributeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceGroupNames() ? this.instanceGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modelAccessConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubAccessConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataSource)) {
            return false;
        }
        S3DataSource other = (S3DataSource)obj;
        return Objects.equals(this.s3DataTypeAsString(), other.s3DataTypeAsString()) && Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.s3DataDistributionTypeAsString(), other.s3DataDistributionTypeAsString()) && this.hasAttributeNames() == other.hasAttributeNames() && Objects.equals(this.attributeNames(), other.attributeNames()) && this.hasInstanceGroupNames() == other.hasInstanceGroupNames() && Objects.equals(this.instanceGroupNames(), other.instanceGroupNames()) && Objects.equals(this.modelAccessConfig(), other.modelAccessConfig()) && Objects.equals(this.hubAccessConfig(), other.hubAccessConfig());
    }

    public final String toString() {
        return ToString.builder((String)"S3DataSource").add("S3DataType", (Object)this.s3DataTypeAsString()).add("S3Uri", (Object)this.s3Uri()).add("S3DataDistributionType", (Object)this.s3DataDistributionTypeAsString()).add("AttributeNames", this.hasAttributeNames() ? this.attributeNames() : null).add("InstanceGroupNames", this.hasInstanceGroupNames() ? this.instanceGroupNames() : null).add("ModelAccessConfig", (Object)this.modelAccessConfig()).add("HubAccessConfig", (Object)this.hubAccessConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3DataType": {
                return Optional.ofNullable(clazz.cast(this.s3DataTypeAsString()));
            }
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "S3DataDistributionType": {
                return Optional.ofNullable(clazz.cast(this.s3DataDistributionTypeAsString()));
            }
            case "AttributeNames": {
                return Optional.ofNullable(clazz.cast(this.attributeNames()));
            }
            case "InstanceGroupNames": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupNames()));
            }
            case "ModelAccessConfig": {
                return Optional.ofNullable(clazz.cast(this.modelAccessConfig()));
            }
            case "HubAccessConfig": {
                return Optional.ofNullable(clazz.cast(this.hubAccessConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("S3DataType", S3_DATA_TYPE_FIELD);
        map.put("S3Uri", S3_URI_FIELD);
        map.put("S3DataDistributionType", S3_DATA_DISTRIBUTION_TYPE_FIELD);
        map.put("AttributeNames", ATTRIBUTE_NAMES_FIELD);
        map.put("InstanceGroupNames", INSTANCE_GROUP_NAMES_FIELD);
        map.put("ModelAccessConfig", MODEL_ACCESS_CONFIG_FIELD);
        map.put("HubAccessConfig", HUB_ACCESS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3DataSource, T> g) {
        return obj -> g.apply((S3DataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3DataType;
        private String s3Uri;
        private String s3DataDistributionType;
        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> instanceGroupNames = DefaultSdkAutoConstructList.getInstance();
        private ModelAccessConfig modelAccessConfig;
        private HubAccessConfig hubAccessConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DataSource model) {
            this.s3DataType(model.s3DataType);
            this.s3Uri(model.s3Uri);
            this.s3DataDistributionType(model.s3DataDistributionType);
            this.attributeNames(model.attributeNames);
            this.instanceGroupNames(model.instanceGroupNames);
            this.modelAccessConfig(model.modelAccessConfig);
            this.hubAccessConfig(model.hubAccessConfig);
        }

        public final String getS3DataType() {
            return this.s3DataType;
        }

        public final void setS3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
        }

        @Override
        public final Builder s3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
            return this;
        }

        @Override
        public final Builder s3DataType(S3DataType s3DataType) {
            this.s3DataType(s3DataType == null ? null : s3DataType.toString());
            return this;
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getS3DataDistributionType() {
            return this.s3DataDistributionType;
        }

        public final void setS3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
        }

        @Override
        public final Builder s3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
            return this;
        }

        @Override
        public final Builder s3DataDistributionType(S3DataDistribution s3DataDistributionType) {
            this.s3DataDistributionType(s3DataDistributionType == null ? null : s3DataDistributionType.toString());
            return this;
        }

        public final Collection<String> getAttributeNames() {
            if (this.attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeNames;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNamesCopier.copy(attributeNames);
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNamesCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final Collection<String> getInstanceGroupNames() {
            if (this.instanceGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceGroupNames;
        }

        public final void setInstanceGroupNames(Collection<String> instanceGroupNames) {
            this.instanceGroupNames = InstanceGroupNamesCopier.copy(instanceGroupNames);
        }

        @Override
        public final Builder instanceGroupNames(Collection<String> instanceGroupNames) {
            this.instanceGroupNames = InstanceGroupNamesCopier.copy(instanceGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroupNames(String ... instanceGroupNames) {
            this.instanceGroupNames(Arrays.asList(instanceGroupNames));
            return this;
        }

        public final ModelAccessConfig.Builder getModelAccessConfig() {
            return this.modelAccessConfig != null ? this.modelAccessConfig.toBuilder() : null;
        }

        public final void setModelAccessConfig(ModelAccessConfig.BuilderImpl modelAccessConfig) {
            this.modelAccessConfig = modelAccessConfig != null ? modelAccessConfig.build() : null;
        }

        @Override
        public final Builder modelAccessConfig(ModelAccessConfig modelAccessConfig) {
            this.modelAccessConfig = modelAccessConfig;
            return this;
        }

        public final HubAccessConfig.Builder getHubAccessConfig() {
            return this.hubAccessConfig != null ? this.hubAccessConfig.toBuilder() : null;
        }

        public final void setHubAccessConfig(HubAccessConfig.BuilderImpl hubAccessConfig) {
            this.hubAccessConfig = hubAccessConfig != null ? hubAccessConfig.build() : null;
        }

        @Override
        public final Builder hubAccessConfig(HubAccessConfig hubAccessConfig) {
            this.hubAccessConfig = hubAccessConfig;
            return this;
        }

        public S3DataSource build() {
            return new S3DataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DataSource> {
        public Builder s3DataType(String var1);

        public Builder s3DataType(S3DataType var1);

        public Builder s3Uri(String var1);

        public Builder s3DataDistributionType(String var1);

        public Builder s3DataDistributionType(S3DataDistribution var1);

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);

        public Builder instanceGroupNames(Collection<String> var1);

        public Builder instanceGroupNames(String ... var1);

        public Builder modelAccessConfig(ModelAccessConfig var1);

        default public Builder modelAccessConfig(Consumer<ModelAccessConfig.Builder> modelAccessConfig) {
            return this.modelAccessConfig((ModelAccessConfig)((ModelAccessConfig.Builder)ModelAccessConfig.builder().applyMutation(modelAccessConfig)).build());
        }

        public Builder hubAccessConfig(HubAccessConfig var1);

        default public Builder hubAccessConfig(Consumer<HubAccessConfig.Builder> hubAccessConfig) {
            return this.hubAccessConfig((HubAccessConfig)((HubAccessConfig.Builder)HubAccessConfig.builder().applyMutation(hubAccessConfig)).build());
        }
    }
}

