/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrainingPlanStatus {
    PENDING("Pending"),
    ACTIVE("Active"),
    SCHEDULED("Scheduled"),
    EXPIRED("Expired"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrainingPlanStatus> VALUE_MAP;
    private final String value;

    private TrainingPlanStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrainingPlanStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrainingPlanStatus> knownValues() {
        EnumSet<TrainingPlanStatus> knownValues = EnumSet.allOf(TrainingPlanStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrainingPlanStatus.class, TrainingPlanStatus::toString);
    }
}

