/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AggregationTransformationValue;
import software.amazon.awssdk.services.sagemaker.model.AggregationTransformationsCopier;
import software.amazon.awssdk.services.sagemaker.model.FillingTransformationsCopier;
import software.amazon.awssdk.services.sagemaker.model.FillingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeSeriesTransformations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeSeriesTransformations> {
    private static final SdkField<Map<String, Map<String, String>>> FILLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Filling").getter(TimeSeriesTransformations.getter(TimeSeriesTransformations::fillingAsStrings)).setter(TimeSeriesTransformations.setter(Builder::fillingWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filling").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Aggregation").getter(TimeSeriesTransformations.getter(TimeSeriesTransformations::aggregationAsStrings)).setter(TimeSeriesTransformations.setter(Builder::aggregationWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILLING_FIELD, AGGREGATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TimeSeriesTransformations.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, Map<String, String>> filling;
    private final Map<String, String> aggregation;

    private TimeSeriesTransformations(BuilderImpl builder) {
        this.filling = builder.filling;
        this.aggregation = builder.aggregation;
    }

    public final Map<String, Map<FillingType, String>> filling() {
        return FillingTransformationsCopier.copyStringToEnum(this.filling);
    }

    public final boolean hasFilling() {
        return this.filling != null && !(this.filling instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, String>> fillingAsStrings() {
        return this.filling;
    }

    public final Map<String, AggregationTransformationValue> aggregation() {
        return AggregationTransformationsCopier.copyStringToEnum(this.aggregation);
    }

    public final boolean hasAggregation() {
        return this.aggregation != null && !(this.aggregation instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> aggregationAsStrings() {
        return this.aggregation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilling() ? this.fillingAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregation() ? this.aggregationAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesTransformations)) {
            return false;
        }
        TimeSeriesTransformations other = (TimeSeriesTransformations)obj;
        return this.hasFilling() == other.hasFilling() && Objects.equals(this.fillingAsStrings(), other.fillingAsStrings()) && this.hasAggregation() == other.hasAggregation() && Objects.equals(this.aggregationAsStrings(), other.aggregationAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"TimeSeriesTransformations").add("Filling", this.hasFilling() ? this.fillingAsStrings() : null).add("Aggregation", this.hasAggregation() ? this.aggregationAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filling": {
                return Optional.ofNullable(clazz.cast(this.fillingAsStrings()));
            }
            case "Aggregation": {
                return Optional.ofNullable(clazz.cast(this.aggregationAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Filling", FILLING_FIELD);
        map.put("Aggregation", AGGREGATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesTransformations, T> g) {
        return obj -> g.apply((TimeSeriesTransformations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Map<String, String>> filling = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> aggregation = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesTransformations model) {
            this.fillingWithStrings(model.filling);
            this.aggregationWithStrings(model.aggregation);
        }

        public final Map<String, ? extends Map<String, String>> getFilling() {
            if (this.filling instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filling;
        }

        public final void setFilling(Map<String, ? extends Map<String, String>> filling) {
            this.filling = FillingTransformationsCopier.copy(filling);
        }

        @Override
        public final Builder fillingWithStrings(Map<String, ? extends Map<String, String>> filling) {
            this.filling = FillingTransformationsCopier.copy(filling);
            return this;
        }

        public final Map<String, String> getAggregation() {
            if (this.aggregation instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.aggregation;
        }

        public final void setAggregation(Map<String, String> aggregation) {
            this.aggregation = AggregationTransformationsCopier.copy(aggregation);
        }

        @Override
        public final Builder aggregationWithStrings(Map<String, String> aggregation) {
            this.aggregation = AggregationTransformationsCopier.copy(aggregation);
            return this;
        }

        @Override
        public final Builder aggregation(Map<String, AggregationTransformationValue> aggregation) {
            this.aggregation = AggregationTransformationsCopier.copyEnumToString(aggregation);
            return this;
        }

        public TimeSeriesTransformations build() {
            return new TimeSeriesTransformations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeSeriesTransformations> {
        public Builder fillingWithStrings(Map<String, ? extends Map<String, String>> var1);

        public Builder aggregationWithStrings(Map<String, String> var1);

        public Builder aggregation(Map<String, AggregationTransformationValue> var1);
    }
}

