/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.S3DataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformS3DataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformS3DataSource> {
    private static final SdkField<String> S3_DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3DataType").getter(TransformS3DataSource.getter(TransformS3DataSource::s3DataTypeAsString)).setter(TransformS3DataSource.setter(Builder::s3DataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataType").build()}).build();
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Uri").getter(TransformS3DataSource.getter(TransformS3DataSource::s3Uri)).setter(TransformS3DataSource.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_TYPE_FIELD, S3_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransformS3DataSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3DataType;
    private final String s3Uri;

    private TransformS3DataSource(BuilderImpl builder) {
        this.s3DataType = builder.s3DataType;
        this.s3Uri = builder.s3Uri;
    }

    public final S3DataType s3DataType() {
        return S3DataType.fromValue(this.s3DataType);
    }

    public final String s3DataTypeAsString() {
        return this.s3DataType;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformS3DataSource)) {
            return false;
        }
        TransformS3DataSource other = (TransformS3DataSource)obj;
        return Objects.equals(this.s3DataTypeAsString(), other.s3DataTypeAsString()) && Objects.equals(this.s3Uri(), other.s3Uri());
    }

    public final String toString() {
        return ToString.builder((String)"TransformS3DataSource").add("S3DataType", (Object)this.s3DataTypeAsString()).add("S3Uri", (Object)this.s3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3DataType": {
                return Optional.ofNullable(clazz.cast(this.s3DataTypeAsString()));
            }
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("S3DataType", S3_DATA_TYPE_FIELD);
        map.put("S3Uri", S3_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransformS3DataSource, T> g) {
        return obj -> g.apply((TransformS3DataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3DataType;
        private String s3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformS3DataSource model) {
            this.s3DataType(model.s3DataType);
            this.s3Uri(model.s3Uri);
        }

        public final String getS3DataType() {
            return this.s3DataType;
        }

        public final void setS3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
        }

        @Override
        public final Builder s3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
            return this;
        }

        @Override
        public final Builder s3DataType(S3DataType s3DataType) {
            this.s3DataType(s3DataType == null ? null : s3DataType.toString());
            return this;
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public TransformS3DataSource build() {
            return new TransformS3DataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformS3DataSource> {
        public Builder s3DataType(String var1);

        public Builder s3DataType(S3DataType var1);

        public Builder s3Uri(String var1);
    }
}

